/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.ui.editor.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.draw2d.text.ParagraphTextLayout;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.swt.graphics.Color;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.struts.ui.editor.edit.CommentEditPart;
import org.jboss.tools.struts.ui.editor.edit.ProcessItemEditPart;
import org.jboss.tools.struts.ui.editor.figures.CommentFeedbackFigure;
import org.jboss.tools.struts.ui.editor.figures.CommentsCorner;
import org.jboss.tools.struts.ui.editor.figures.ProcessItemFigure;
import org.jboss.tools.struts.ui.editor.model.IProcessItem;

public class CommentFigure
extends ProcessItemFigure
implements FigureListener {
    public static final Color BACKGROUND_COLOR = new Color(null, 255, 255, 205);
    protected PointList fillPointlist;
    protected ProcessItemFigure commented = null;
    protected CommentsCorner corner;
    protected Point deltaPoint = null;
    private TextFlow textFlow;

    public CommentFigure(IProcessItem processItem, CommentEditPart part) {
        super(processItem, part);
        this.setBorder((Border)new CommentBorder());
        if (processItem != null) {
            IProcessItem pItem = processItem.getCommentTarget();
            if (pItem != null) {
                this.commented = (ProcessItemFigure)((ProcessItemEditPart)this.editPart.getViewer().getEditPartRegistry().get(pItem)).getFigure();
                if (this.commented != null) {
                    this.corner = new CommentsCorner(this, this.commented);
                }
            }
            FlowPage flowPage = new FlowPage();
            this.textFlow = new TextFlow();
            this.textFlow.setLayoutManager((LayoutManager)new ParagraphTextLayout(this.textFlow, 1));
            this.textFlow.setFont(processItem.getStrutsModel().getOptions().getCommentFont());
            this.textFlow.setText(((XModelObject)processItem.getSource()).getAttributeValue("comment"));
            flowPage.add((IFigure)this.textFlow);
            this.setLayoutManager((LayoutManager)new StackLayout());
            this.add((IFigure)flowPage);
        }
    }

    public String getText() {
        return this.textFlow.getText();
    }

    public void setText(String newText) {
        this.textFlow.setFont(this.processItem.getStrutsModel().getOptions().getCommentFont());
        this.textFlow.setText(newText);
    }

    protected void calculateDeltaPoint() {
        if (this.commented != null) {
            this.deltaPoint = new Point(this.getLocation().x - this.commented.getLocation().x, this.getLocation().y - this.commented.getLocation().y);
            if (this.deltaPoint.x == 0 && this.deltaPoint.y == 0) {
                this.deltaPoint = null;
            }
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.commented != null) {
            this.corner.setVisible(visible);
        }
    }

    public void figureMoved(IFigure source) {
        if (this instanceof CommentFeedbackFigure) {
            return;
        }
        super.figureMoved(source);
        if (this.commented != null && source == this) {
            if (this.processItem.isJump()) {
                this.calculateDeltaPoint();
                return;
            }
            this.processItem.setJump(true);
            this.calculateDeltaPoint();
            return;
        }
        if (this.commented == null || this.commented != source) {
            return;
        }
        if (this.commented.processItem.isJump()) {
            this.calculateDeltaPoint();
            return;
        }
        this.commented.processItem.setJump(true);
        if (this.deltaPoint != null) {
            Rectangle rect = this.getBounds();
            rect.x = this.commented.getLocation().x + this.deltaPoint.x;
            rect.y = this.commented.getLocation().y + this.deltaPoint.y;
            if (rect.x < 0) {
                rect.x = 0;
            }
            if (rect.y < 0) {
                rect.y = 0;
            }
            this.processItem.setBounds(rect);
            this.corner.figureMoved((IFigure)this);
            this.getParent().revalidate();
            this.getParent().repaint();
        }
    }

    public void addNotify() {
        if (this.commented != null) {
            this.getParent().add((IFigure)this.corner);
            this.commented.addFigureListener(this);
            this.calculateDeltaPoint();
        }
    }

    public void removeNotify() {
        if (this.commented != null) {
            this.getParent().remove((IFigure)this.corner);
            this.commented.removeFigureListener(this);
        }
    }

    protected void resizeFigure() {
        if (this.width == this.getSize().width && this.height == this.getSize().height) {
            return;
        }
        this.width = this.getSize().width - 1;
        this.height = this.getSize().height - 1;
        this.fillPointlist = new PointList();
        this.fillPointlist.addPoint(1, 8);
        this.fillPointlist.addPoint(2, 8);
        this.fillPointlist.addPoint(2, 6);
        this.fillPointlist.addPoint(3, 6);
        this.fillPointlist.addPoint(3, 5);
        this.fillPointlist.addPoint(4, 5);
        this.fillPointlist.addPoint(4, 4);
        this.fillPointlist.addPoint(5, 4);
        this.fillPointlist.addPoint(5, 3);
        this.fillPointlist.addPoint(7, 3);
        this.fillPointlist.addPoint(7, 2);
        this.fillPointlist.addPoint(10, 2);
        this.fillPointlist.addPoint(10, 1);
        this.fillPointlist.addPoint(this.width - 10, 1);
        this.fillPointlist.addPoint(this.width - 10, 2);
        this.fillPointlist.addPoint(this.width - 7, 2);
        this.fillPointlist.addPoint(this.width - 7, 3);
        this.fillPointlist.addPoint(this.width - 5, 3);
        this.fillPointlist.addPoint(this.width - 5, 4);
        this.fillPointlist.addPoint(this.width - 4, 4);
        this.fillPointlist.addPoint(this.width - 4, 5);
        this.fillPointlist.addPoint(this.width - 3, 5);
        this.fillPointlist.addPoint(this.width - 3, 6);
        this.fillPointlist.addPoint(this.width - 2, 6);
        this.fillPointlist.addPoint(this.width - 2, 8);
        this.fillPointlist.addPoint(this.width - 1, 8);
        this.fillPointlist.addPoint(this.width - 1, this.height - 8);
        this.fillPointlist.addPoint(this.width - 2, this.height - 8);
        this.fillPointlist.addPoint(this.width - 2, this.height - 6);
        this.fillPointlist.addPoint(this.width - 3, this.height - 6);
        this.fillPointlist.addPoint(this.width - 3, this.height - 5);
        this.fillPointlist.addPoint(this.width - 4, this.height - 5);
        this.fillPointlist.addPoint(this.width - 4, this.height - 4);
        this.fillPointlist.addPoint(this.width - 5, this.height - 4);
        this.fillPointlist.addPoint(this.width - 5, this.height - 3);
        this.fillPointlist.addPoint(this.width - 7, this.height - 3);
        this.fillPointlist.addPoint(this.width - 7, this.height - 2);
        this.fillPointlist.addPoint(this.width - 10, this.height - 2);
        this.fillPointlist.addPoint(this.width - 10, this.height - 1);
        this.fillPointlist.addPoint(10, this.height - 1);
        this.fillPointlist.addPoint(10, this.height - 2);
        this.fillPointlist.addPoint(7, this.height - 2);
        this.fillPointlist.addPoint(7, this.height - 3);
        this.fillPointlist.addPoint(5, this.height - 3);
        this.fillPointlist.addPoint(5, this.height - 4);
        this.fillPointlist.addPoint(4, this.height - 4);
        this.fillPointlist.addPoint(4, this.height - 5);
        this.fillPointlist.addPoint(3, this.height - 5);
        this.fillPointlist.addPoint(3, this.height - 6);
        this.fillPointlist.addPoint(2, this.height - 6);
        this.fillPointlist.addPoint(2, this.height - 8);
        this.fillPointlist.addPoint(1, this.height - 8);
    }

    protected void paintFigure(Graphics g) {
        Rectangle r = this.getBounds().getCopy();
        g.translate(r.getLocation());
        if (this.processItem == null) {
            g.setBackgroundColor(lightGrayColor);
        } else {
            g.setBackgroundColor(BACKGROUND_COLOR);
        }
        g.fillPolygon(this.fillPointlist);
    }

    class CommentBorder
    extends MarginBorder {
        public CommentBorder() {
            super(6);
        }

        public void paint(IFigure figure, Graphics graphics, Insets insets) {
            Rectangle r = CommentBorder.getPaintRectangle((IFigure)figure, (Insets)insets).getCopy();
            graphics.translate(r.getLocation());
            int width = r.width - 1;
            int height = r.height - 1;
            if (CommentFigure.this.processItem != null && CommentFigure.this.processItem.isConfirmed()) {
                graphics.setForegroundColor(blackColor);
            } else {
                graphics.setForegroundColor(darkGrayColor);
            }
            graphics.drawLine(1, 7, 1, 6);
            graphics.drawLine(2, 5, 4, 3);
            graphics.drawLine(5, 2, 6, 2);
            graphics.drawLine(7, 1, 9, 1);
            graphics.drawLine(10, 0, width - 11, 0);
            graphics.drawLine(width - 10, 1, width - 8, 1);
            graphics.drawLine(width - 7, 2, width - 6, 2);
            graphics.drawLine(width - 5, 3, width - 3, 5);
            graphics.drawLine(width - 2, 6, width - 2, 7);
            graphics.drawLine(width - 1, 8, width - 1, height - 9);
            graphics.drawLine(width - 2, height - 8, width - 2, height - 7);
            graphics.drawLine(width - 3, height - 6, width - 5, height - 4);
            graphics.drawLine(width - 6, height - 3, width - 7, height - 3);
            graphics.drawLine(width - 8, height - 2, width - 10, height - 2);
            graphics.drawLine(width - 11, height - 1, 10, height - 1);
            graphics.drawLine(9, height - 2, 7, height - 2);
            graphics.drawLine(6, height - 3, 5, height - 3);
            graphics.drawLine(4, height - 4, 2, height - 6);
            graphics.drawLine(1, height - 7, 1, height - 8);
            graphics.drawLine(0, height - 9, 0, 8);
            graphics.setBackgroundColor(BACKGROUND_COLOR);
            graphics.setForegroundColor(BACKGROUND_COLOR);
            if (CommentFigure.this.corner != null) {
                if (CommentFigure.this.corner.cornerType == 1 || CommentFigure.this.corner.cornerType == 5 || CommentFigure.this.corner.cornerType == 6) {
                    graphics.drawLine(31, height - 1, 59, height - 1);
                } else if (CommentFigure.this.corner.cornerType == 4 || CommentFigure.this.corner.cornerType == 7 || CommentFigure.this.corner.cornerType == 8) {
                    graphics.drawLine(31, 0, 59, 0);
                } else if (CommentFigure.this.corner.cornerType == 2) {
                    if (height <= 46) {
                        graphics.drawLine(width - 1, 9, width - 1, height - 10);
                    } else {
                        graphics.drawLine(width - 1, 9, width - 1, 37);
                    }
                } else if (CommentFigure.this.corner.cornerType == 3) {
                    if (height <= 46) {
                        graphics.drawLine(0, 9, 0, height - 10);
                    } else {
                        graphics.drawLine(0, 9, 0, 37);
                    }
                }
            }
        }
    }
}

