/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.ui.editor.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.jboss.tools.struts.ui.editor.figures.NodeFigure;
import org.jboss.tools.struts.ui.editor.figures.ProcessItemFigure;

public class CommentsCorner
extends Figure
implements FigureListener {
    public static final int INCORRECT_CORNER = 0;
    public static final int NORTH_CORNER = 1;
    public static final int WEST_CORNER = 2;
    public static final int EAST_CORNER = 3;
    public static final int SOUTH_CORNER = 4;
    public static final int NE_CORNER = 5;
    public static final int NW_CORNER = 6;
    public static final int SE_CORNER = 7;
    public static final int SW_CORNER = 8;
    public static final Color BACKGROUND_COLOR = new Color(null, 255, 255, 205);
    public static final Color FOREGROUND_COLOR = NodeFigure.blackColor;
    public int cornerType = 0;
    private ProcessItemFigure commentView;
    private ProcessItemFigure processItemView;
    private Rectangle commentBounds;
    private Rectangle processItemBounds;
    private Point rightPoint;
    private Point leftPoint;
    private Point basePoint;

    public CommentsCorner(ProcessItemFigure commentView, ProcessItemFigure processItemView) {
        this.setBorder((Border)new CommentCornerBorder(FOREGROUND_COLOR));
        this.commentView = commentView;
        this.processItemView = processItemView;
        this.commentBounds = commentView.getBounds();
        this.processItemBounds = processItemView.getBounds();
        commentView.addFigureListener(this);
        processItemView.addFigureListener(this);
    }

    public void addNotify() {
        this.calculate();
        this.panelRedraw();
    }

    public void close() {
        this.commentView.removeFigureListener(this);
        this.processItemView.removeFigureListener(this);
    }

    public void paintFigure(Graphics g) {
        if (this.cornerType == 0) {
            return;
        }
        g.setBackgroundColor(BACKGROUND_COLOR);
        PointList list = new PointList();
        list.addPoint(this.basePoint);
        list.addPoint(this.rightPoint);
        list.addPoint(this.leftPoint);
        g.fillPolygon(list);
    }

    private void calculate() {
        this.cornerType = 0;
        if (this.commentBounds.y + this.commentBounds.height < this.processItemBounds.y) {
            this.cornerType = this.commentBounds.x + this.commentBounds.width < this.processItemBounds.x ? 6 : (this.processItemBounds.x + this.processItemBounds.width < this.commentBounds.x ? 5 : 1);
        } else if (this.processItemBounds.y + this.processItemBounds.height < this.commentBounds.y) {
            this.cornerType = this.commentBounds.x + this.commentBounds.width < this.processItemBounds.x ? 8 : (this.processItemBounds.x + this.processItemBounds.width < this.commentBounds.x ? 7 : 4);
        } else if (this.commentBounds.x + this.commentBounds.width < this.processItemBounds.x) {
            this.cornerType = 2;
        } else if (this.processItemBounds.x + this.processItemBounds.width < this.commentBounds.x) {
            this.cornerType = 3;
        }
        switch (this.cornerType) {
            case 1: {
                this.basePoint = new Point(this.processItemBounds.x + this.processItemBounds.width / 2, this.processItemBounds.y);
                this.leftPoint = new Point(this.commentBounds.x + 30, this.commentBounds.y + this.commentBounds.height - 1);
                this.rightPoint = new Point(this.commentBounds.x + 60, this.commentBounds.y + this.commentBounds.height - 1);
                break;
            }
            case 4: {
                this.basePoint = new Point(this.processItemBounds.x + this.processItemBounds.width / 2, this.processItemBounds.y + this.processItemBounds.height);
                this.leftPoint = new Point(this.commentBounds.x + 30, this.commentBounds.y);
                this.rightPoint = new Point(this.commentBounds.x + 60, this.commentBounds.y);
                break;
            }
            case 2: {
                this.basePoint = new Point(this.processItemBounds.x, this.processItemBounds.y + this.processItemBounds.height / 2);
                if (this.commentBounds.height <= 46) {
                    this.leftPoint = new Point(this.commentBounds.x + this.commentBounds.width - 1, this.commentBounds.y + 8);
                    this.rightPoint = new Point(this.commentBounds.x + this.commentBounds.width - 1, this.commentBounds.y + this.commentBounds.height - 9);
                    break;
                }
                this.leftPoint = new Point(this.commentBounds.x + this.commentBounds.width - 1, this.commentBounds.y + 8);
                this.rightPoint = new Point(this.commentBounds.x + this.commentBounds.width - 1, this.commentBounds.y + 38);
                break;
            }
            case 3: {
                this.basePoint = new Point(this.processItemBounds.x + this.processItemBounds.width, this.processItemBounds.y + this.processItemBounds.height / 2);
                if (this.commentBounds.height <= 46) {
                    this.leftPoint = new Point(this.commentBounds.x + 1, this.commentBounds.y + 8);
                    this.rightPoint = new Point(this.commentBounds.x + 1, this.commentBounds.y + this.commentBounds.height - 9);
                    break;
                }
                this.leftPoint = new Point(this.commentBounds.x + 1, this.commentBounds.y + 8);
                this.rightPoint = new Point(this.commentBounds.x + 1, this.commentBounds.y + 38);
                break;
            }
            case 5: {
                this.basePoint = new Point(this.processItemBounds.x + this.processItemBounds.width, this.processItemBounds.y + this.processItemBounds.height / 2);
                this.leftPoint = new Point(this.commentBounds.x + 30, this.commentBounds.y + this.commentBounds.height - 1);
                this.rightPoint = new Point(this.commentBounds.x + 60, this.commentBounds.y + this.commentBounds.height - 1);
                break;
            }
            case 6: {
                this.basePoint = new Point(this.processItemBounds.x, this.processItemBounds.y + this.processItemBounds.height / 2);
                this.leftPoint = new Point(this.commentBounds.x + 30, this.commentBounds.y + this.commentBounds.height - 1);
                this.rightPoint = new Point(this.commentBounds.x + 60, this.commentBounds.y + this.commentBounds.height - 1);
                break;
            }
            case 7: {
                this.basePoint = new Point(this.processItemBounds.x + this.processItemBounds.width, this.processItemBounds.y + this.processItemBounds.height / 2);
                this.leftPoint = new Point(this.commentBounds.x + 30, this.commentBounds.y);
                this.rightPoint = new Point(this.commentBounds.x + 60, this.commentBounds.y);
                break;
            }
            case 8: {
                this.basePoint = new Point(this.processItemBounds.x, this.processItemBounds.y + this.processItemBounds.height / 2);
                this.leftPoint = new Point(this.commentBounds.x + 30, this.commentBounds.y);
                this.rightPoint = new Point(this.commentBounds.x + 60, this.commentBounds.y);
            }
        }
    }

    public void panelRedraw() {
        if (this.cornerType == 0) {
            return;
        }
        int minX = this.basePoint.x - 1;
        int minY = this.basePoint.y - 1;
        int maxX = this.basePoint.x + 1;
        int maxY = this.basePoint.y + 1;
        if (this.leftPoint.x - 1 < minX) {
            minX = this.leftPoint.x - 1;
        }
        if (this.leftPoint.y - 1 < minY) {
            minY = this.leftPoint.y - 1;
        }
        if (this.leftPoint.x + 1 > maxX) {
            maxX = this.leftPoint.x + 1;
        }
        if (this.leftPoint.y + 1 > maxY) {
            maxY = this.leftPoint.y + 1;
        }
        if (this.rightPoint.x - 1 < minX) {
            minX = this.rightPoint.x - 1;
        }
        if (this.rightPoint.y - 1 < minY) {
            minY = this.rightPoint.y - 1;
        }
        if (this.rightPoint.x + 1 > maxX) {
            maxX = this.rightPoint.x + 1;
        }
        if (this.rightPoint.y + 1 > maxY) {
            maxY = this.rightPoint.y + 1;
        }
        int width = maxX - minX;
        int height = maxY - minY;
        this.setBounds(new Rectangle(minX, minY, width, height));
        this.repaint();
    }

    public void figureMoved(IFigure source) {
        this.commentBounds = this.commentView.getBounds();
        this.processItemBounds = this.processItemView.getBounds();
        this.calculate();
        this.panelRedraw();
        this.commentView.repaint();
    }

    class CommentCornerBorder
    extends LineBorder {
        public CommentCornerBorder(Color color) {
            super(color);
        }

        public void paint(IFigure figure, Graphics graphics, Insets insets) {
            if (CommentsCorner.this.cornerType == 0) {
                return;
            }
            graphics.setForegroundColor(FOREGROUND_COLOR);
            graphics.drawLine(CommentsCorner.this.basePoint, CommentsCorner.this.rightPoint);
            graphics.drawLine(CommentsCorner.this.basePoint, CommentsCorner.this.leftPoint);
        }
    }
}

