/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.ui.editor.figures;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.gef.EditPart;
import org.eclipse.swt.graphics.Color;
import org.jboss.tools.struts.ui.editor.edit.LinkEditPart;
import org.jboss.tools.struts.ui.editor.edit.StrutsConnectionRouter;
import org.jboss.tools.struts.ui.editor.figures.BreakPointFigure;
import org.jboss.tools.struts.ui.editor.figures.ConnectionFigure;
import org.jboss.tools.struts.ui.editor.figures.xpl.CustomLocator;
import org.jboss.tools.struts.ui.editor.model.ILink;

public class FigureFactory {
    public static final Color normalColor = new Color(null, 181, 181, 181);
    public static final Color selectedColor = new Color(null, 68, 169, 243);
    public static final Color highlightColor = ColorConstants.black;
    public static final PointList TRIANGLE_TIP = new PointList();

    static {
        TRIANGLE_TIP.addPoint(0, 0);
        TRIANGLE_TIP.addPoint(-8, -4);
        TRIANGLE_TIP.addPoint(-10, -4);
        TRIANGLE_TIP.addPoint(-10, -3);
        TRIANGLE_TIP.addPoint(-8, -1);
        TRIANGLE_TIP.addPoint(-8, 1);
        TRIANGLE_TIP.addPoint(-10, 3);
        TRIANGLE_TIP.addPoint(-10, 4);
        TRIANGLE_TIP.addPoint(-8, 4);
    }

    public static ConnectionFigure createNewBendableWire(LinkEditPart part, ILink link) {
        ConnectionFigure conn = new ConnectionFigure(part);
        conn.setForegroundColor(normalColor);
        PolygonDecoration decor = new PolygonDecoration();
        decor.setTemplate(TRIANGLE_TIP);
        decor.setScale(1.0, 1.0);
        conn.setTargetDecoration((RotatableDecoration)decor);
        part.getLinkModel().setTarget();
        BreakPointFigure bp = new BreakPointFigure((EditPart)part, link.getHeadBreakPoint());
        CustomLocator locator = new CustomLocator(conn, true);
        locator.setUDistance(0);
        locator.setVDistance(-4);
        conn.add((IFigure)bp, locator);
        bp = new BreakPointFigure((EditPart)part, link.getTailBreakPoint());
        locator = new CustomLocator(conn, false);
        locator.setUDistance(1);
        locator.setVDistance(-4);
        conn.add((IFigure)bp, locator);
        return conn;
    }

    public static ConnectionFigure createNewLink(ILink link) {
        ConnectionFigure conn = new ConnectionFigure();
        conn.setConnectionRouter((ConnectionRouter)new StrutsConnectionRouter());
        conn.setForegroundColor(selectedColor);
        PolygonDecoration decor = new PolygonDecoration();
        decor.setTemplate(TRIANGLE_TIP);
        decor.setScale(1.0, 1.0);
        conn.setTargetDecoration((RotatableDecoration)decor);
        return conn;
    }
}

