/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.ui.editor.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.swt.graphics.Color;
import org.jboss.tools.struts.ui.editor.edit.ForwardEditPart;
import org.jboss.tools.struts.ui.editor.figures.NodeFigure;
import org.jboss.tools.struts.ui.editor.figures.xpl.FixedConnectionAnchor;
import org.jboss.tools.struts.ui.editor.model.IForward;

public class ForwardFigure
extends NodeFigure
implements HandleBounds {
    private static final Dimension SIZE = new Dimension(56, 16);
    private Color exColor = new Color(null, 202, 0, 2);
    private Color selColor = new Color(null, 0, 0, 0);
    private ForwardEditPart pagePart;
    private IForward page;

    public void setConstraint(IFigure child, Object constraint) {
        super.setConstraint(child, constraint);
    }

    public void init() {
        FixedConnectionAnchor c = new FixedConnectionAnchor((IFigure)this);
        c.offsetV = 3;
        c.leftToRight = false;
        this.connectionAnchors.put("1_OUT", c);
        this.outputConnectionAnchors.addElement(c);
    }

    public void removeConnectionAnchor() {
        if (this.outputConnectionAnchors.size() == 1) {
            return;
        }
        this.outputConnectionAnchors.remove(this.outputConnectionAnchors.size() - 1);
    }

    public void removeAllConnectionAnchor() {
        this.outputConnectionAnchors.removeAllElements();
    }

    public ForwardFigure(ForwardEditPart pagePart) {
        this.setBorder((Border)new ForwardBorder(blackColor));
        this.pagePart = pagePart;
        this.page = pagePart.getForwardModel();
        this.setOpaque(false);
        this.init();
    }

    public Rectangle getHandleBounds() {
        return this.getBounds().getCropped(new Insets(2, 0, 2, 0));
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        return SIZE;
    }

    protected void paintFigure(Graphics g) {
        Rectangle r = this.getBounds().getCopy();
        g.translate(r.getLocation());
        int width = r.width;
        int height = r.height;
        if (this.page.getProcessItem().isConfirmed()) {
            if (this.page.isException()) {
                g.setForegroundColor(this.exColor);
            } else {
                g.setForegroundColor(blackColor);
            }
            g.setBackgroundColor(whiteColor);
        } else {
            if (this.page.isException()) {
                g.setForegroundColor(this.exColor);
            } else {
                g.setForegroundColor(darkGrayColor);
            }
            g.setBackgroundColor(lightGrayColor);
        }
        g.fillRectangle(0, 0, width - 1, height - 1);
        g.setFont(this.page.getStrutsModel().getOptions().getForwardFont());
        g.drawString(this.dottedString(this.page.getName(), width - 30, this.page.getStrutsModel().getOptions().getForwardFont()), 4, 1);
        if (this.pagePart.getSelected() == 2 || this.pagePart.getSelected() == 1) {
            g.setForegroundColor(this.selColor);
            g.drawRectangle(0, 0, width - 3, height - 3);
        }
    }

    class ForwardBorder
    extends LineBorder {
        public ForwardBorder(Color color) {
            super(color);
        }

        public void paint(IFigure figure, Graphics graphics, Insets insets) {
            Rectangle r = ForwardBorder.getPaintRectangle((IFigure)figure, (Insets)insets).getCopy();
            graphics.translate(r.getLocation());
            int width = r.width - 1;
            int height = r.height - 1;
            graphics.setForegroundColor(blackColor);
            graphics.drawLine(0, height - 1, width - 1, height - 1);
        }
    }
}

