/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.ui.editor.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.jboss.tools.struts.ui.editor.edit.ProcessItemEditPart;
import org.jboss.tools.struts.ui.editor.figures.ProcessItemFigure;
import org.jboss.tools.struts.ui.editor.model.IProcessItem;

public class PageFigure
extends ProcessItemFigure {
    protected PointList fillPointlist;
    protected PointList fill2Pointlist;
    protected PointList shadowPointlist;
    protected PointList shadow2Pointlist;

    public PageFigure(IProcessItem processItem, ProcessItemEditPart part) {
        super(processItem, part);
        this.setBorder((Border)new PageBorder(blackColor));
        this.VERTICAL_ANCHOR_OFFSET = 24;
        if (processItem != null) {
            this.init(processItem.getOutputLinks().length);
        }
    }

    protected void resizeFigure() {
        if (this.width == this.getSize().width && this.height == this.getSize().height) {
            return;
        }
        int start = 0;
        this.width = this.getSize().width - 1;
        this.height = this.getSize().height - 1;
        this.fillPointlist = new PointList();
        this.fillPointlist.addPoint(start, 20);
        this.fillPointlist.addPoint(start + 23, 20);
        this.fillPointlist.addPoint(start + 23, 0);
        this.fillPointlist.addPoint(this.width - 15, 0);
        this.fillPointlist.addPoint(this.width - 1, 14);
        this.fillPointlist.addPoint(this.width - 1, this.height - 1);
        this.fillPointlist.addPoint(start, this.height - 1);
        this.shadowPointlist = new PointList();
        this.shadowPointlist.addPoint(this.width - 15, 0);
        this.shadowPointlist.addPoint(this.width - 14, 4);
        this.shadowPointlist.addPoint(this.width - 15, 7);
        this.shadowPointlist.addPoint(this.width - 18, 10);
        this.shadowPointlist.addPoint(this.width - 1, 14);
        this.shadowPointlist.addPoint(this.width - 9, 14);
        this.shadowPointlist.addPoint(this.width - 16, 13);
        this.shadowPointlist.addPoint(this.width - 21, 11);
        this.shadowPointlist.addPoint(this.width - 18, 8);
        this.shadowPointlist.addPoint(this.width - 16, 4);
        this.shadow2Pointlist = new PointList();
        this.shadow2Pointlist.addPoint(this.width - 15, 0);
        this.shadow2Pointlist.addPoint(this.width - 1, 14);
        this.shadow2Pointlist.addPoint(this.width - 3, 14);
        this.shadow2Pointlist.addPoint(this.width - 15, 2);
    }

    protected void paintFigure(Graphics g) {
        Rectangle r = this.getBounds().getCopy();
        g.translate(r.getLocation());
        int width = r.width - 1;
        int height = r.height - 1;
        g.setBackgroundColor(whiteColor);
        g.fillRectangle(1, 1, 22, 19);
        if (this.icon != null) {
            g.drawImage(this.icon, 4, 2);
        }
        if (this.processItem.hasErrors()) {
            g.drawImage(errorIcon, 4, 10);
        }
        if (this.processItem != null && this.processItem.isConfirmed()) {
            g.setBackgroundColor(yellowColor);
        } else {
            g.setBackgroundColor(lightGrayColor);
        }
        g.fillPolygon(this.fillPointlist);
        if (this.processItem != null && this.processItem.isConfirmed()) {
            g.setBackgroundColor(orangeColor);
        } else {
            g.setBackgroundColor(lightGrayColor);
        }
        g.fillPolygon(this.shadowPointlist);
        g.fillPolygon(this.shadow2Pointlist);
        if (this.processItem.hasPageHiddenLinks()) {
            g.setForegroundColor(mediumGrayColor);
            g.drawLine(width - 20, height - 12, width - 13, height - 19);
            g.drawLine(width - 13, height - 19, width - 6, height - 12);
            g.drawLine(width - 6, height - 12, width - 13, height - 5);
            g.drawLine(width - 13, height - 5, width - 20, height - 12);
            g.drawLine(width - 19, height - 12, width - 13, height - 18);
            g.drawLine(width - 13, height - 18, width - 7, height - 12);
            g.drawLine(width - 7, height - 12, width - 13, height - 6);
            g.drawLine(width - 13, height - 6, width - 19, height - 12);
            g.setBackgroundColor(whiteColor);
            g.setForegroundColor(whiteColor);
            int[] points = new int[]{width - 18, height - 12, width - 13, height - 17, width - 8, height - 12, width - 13, height - 7};
            g.fillPolygon(points);
            g.drawLine(width - 13, height - 17, width - 8, height - 12);
            g.drawLine(width - 8, height - 12, width - 13, height - 7);
            g.setForegroundColor(blackColor);
            g.drawLine(width - 15, height - 14, width - 15, height - 10);
            g.drawLine(width - 11, height - 14, width - 11, height - 10);
            g.drawLine(width - 14, height - 12, width - 12, height - 12);
        }
    }

    class PageBorder
    extends LineBorder {
        public PageBorder(Color color) {
            super(color);
        }

        public void paint(IFigure figure, Graphics graphics, Insets insets) {
            Rectangle r = PageBorder.getPaintRectangle((IFigure)figure, (Insets)insets).getCopy();
            graphics.translate(r.getLocation());
            int width = r.width - 1;
            int height = r.height - 1;
            if (PageFigure.this.processItem != null && PageFigure.this.processItem.isConfirmed()) {
                graphics.setForegroundColor(blackColor);
            } else {
                graphics.setForegroundColor(darkGrayColor);
            }
            graphics.drawLine(1, 0, width - 15, 0);
            graphics.drawLine(0, 1, 0, height - 2);
            graphics.drawLine(1, height - 1, width - 2, height - 1);
            graphics.drawLine(width - 1, 14, width - 1, height - 2);
            graphics.drawLine(width - 15, 0, width - 1, 14);
            graphics.drawLine(0, 1, 1, 0);
            graphics.drawLine(0, height - 2, 1, height - 1);
            graphics.drawLine(width - 2, height - 1, width - 1, height - 2);
            graphics.drawLine(width - 15, 0, width - 14, 4);
            graphics.drawLine(width - 14, 4, width - 15, 7);
            graphics.drawLine(width - 15, 7, width - 18, 10);
            graphics.drawLine(width - 18, 10, width - 1, 14);
            graphics.drawLine(23, 0, 23, 19);
            graphics.drawLine(0, 20, 22, 20);
            graphics.drawLine(22, 20, 23, 19);
        }
    }
}

