/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.ui.editor.figures;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.swt.graphics.Image;
import org.jboss.tools.common.gef.GEFGraphicalViewer;
import org.jboss.tools.struts.ui.editor.edit.ProcessItemEditPart;
import org.jboss.tools.struts.ui.editor.figures.BreakPointFigure;
import org.jboss.tools.struts.ui.editor.figures.NodeFigure;
import org.jboss.tools.struts.ui.editor.figures.xpl.FixedConnectionAnchor;
import org.jboss.tools.struts.ui.editor.model.IProcessItem;
import org.jboss.tools.struts.ui.editor.print.PrintIconHelper;

public class ProcessItemFigure
extends NodeFigure
implements HandleBounds,
FigureListener,
MouseListener {
    protected Dimension SIZE = new Dimension(56, 100);
    protected Image icon = null;
    private BreakPointFigure bp = null;
    public IProcessItem processItem;
    protected Label label = null;
    protected int VERTICAL_ANCHOR_OFFSET = 32;
    String path;
    ProcessItemEditPart editPart;
    protected int width;
    protected int height;

    public void setBounds(Rectangle rect) {
        super.setBounds(rect);
        this.resizeFigure();
    }

    public void setConstraint(IFigure child, Object constraint) {
        super.setConstraint(child, constraint);
    }

    public void setPath(String path) {
        this.path = path;
        if (this.label != null) {
            this.label.setText(path);
            this.label.setSize(this.label.getPreferredSize());
        }
    }

    public void refreshFont() {
        if (this.label != null) {
            this.label.setFont(this.processItem.getStrutsModel().getOptions().getPathFont());
            this.label.setSize(this.label.getPreferredSize());
            this.label.setLocation(new Point(this.getLocation().x - 5, this.getLocation().y - (12 + this.processItem.getStrutsModel().getOptions().getPathFont().getFontData()[0].getHeight())));
        }
    }

    public void setIcon(Image i) {
        this.icon = PrintIconHelper.getPrintImage(i);
    }

    public void addNotify() {
        if (this.processItem == null || this.processItem.isGlobal()) {
            return;
        }
        this.label.setFont(this.processItem.getStrutsModel().getOptions().getPathFont());
        this.getParent().add((IFigure)this.label);
        this.label.setForegroundColor(ColorConstants.black);
        this.label.setOpaque(false);
        this.label.setText(this.path);
        this.label.setVisible(true);
        this.label.setSize(this.label.getPreferredSize());
        this.label.setLocation(new Point(this.getLocation().x - 5, this.getLocation().y - (12 + this.processItem.getStrutsModel().getOptions().getPathFont().getFontData()[0].getHeight())));
        this.label.addMouseListener((MouseListener)this);
        this.getParent().add((IFigure)this.bp);
        this.bp.setLocation(new Point(this.getLocation().x - 10, this.getLocation().y + 4));
    }

    public void removeNotify() {
        if (this.processItem == null || this.label == null) {
            return;
        }
        this.label.removeMouseListener((MouseListener)this);
        this.getParent().remove((IFigure)this.label);
        this.getParent().remove((IFigure)this.bp);
    }

    public void figureMoved(IFigure source) {
        if (this.processItem != null && this.label != null) {
            this.label.setLocation(new Point(this.getLocation().x - 5, this.getLocation().y - 20));
            this.bp.setLocation(new Point(this.getLocation().x - 10, this.getLocation().y + 4));
        }
    }

    public void init(int number) {
        if (number == 0) {
            number = 1;
        }
        int i = 0;
        while (i < number) {
            FixedConnectionAnchor c = new FixedConnectionAnchor((IFigure)this);
            c.offsetV = this.VERTICAL_ANCHOR_OFFSET + 16 * i;
            c.leftToRight = false;
            this.connectionAnchors.put(String.valueOf(i + 1) + "_OUT", c);
            this.outputConnectionAnchors.addElement(c);
            ++i;
        }
    }

    public void addConnectionAnchor(int number) {
        if (number == 1) {
            return;
        }
        FixedConnectionAnchor c = new FixedConnectionAnchor((IFigure)this);
        c.offsetV = this.VERTICAL_ANCHOR_OFFSET + 16 * (number - 1);
        c.leftToRight = false;
        this.connectionAnchors.put(String.valueOf(number) + "_OUT", c);
        this.outputConnectionAnchors.addElement(c);
    }

    public void removeConnectionAnchor() {
        if (this.outputConnectionAnchors.size() == 1) {
            return;
        }
        this.outputConnectionAnchors.remove(this.outputConnectionAnchors.size() - 1);
    }

    public void removeAllConnectionAnchor() {
        this.outputConnectionAnchors.removeAllElements();
    }

    public ProcessItemFigure(IProcessItem processItem, ProcessItemEditPart part) {
        this.processItem = processItem;
        this.editPart = part;
        if (processItem != null) {
            this.setIcon(processItem.getImage());
            this.setPath(processItem.getVisiblePath());
            if (!processItem.isGlobal()) {
                this.label = new Label(this.path);
            }
        }
        this.setOpaque(false);
        this.setLayoutManager((LayoutManager)new XYLayout());
        this.resizeFigure();
        this.addFigureListener(this);
        if (processItem != null) {
            this.bp = new BreakPointFigure((EditPart)this.editPart, processItem.getBreakPoint(), true);
        }
        if (processItem != null) {
            FixedConnectionAnchor c = new FixedConnectionAnchor((IFigure)this);
            c.offsetV = 8;
            c.offsetH = -1;
            this.connectionAnchors.put("1_IN", c);
            this.inputConnectionAnchors.addElement(c);
        }
    }

    public Rectangle getHandleBounds() {
        return this.getBounds().getCropped(new Insets(0, 0, 0, 0));
    }

    protected void resizeFigure() {
    }

    public void mouseDoubleClicked(MouseEvent me) {
    }

    public void mousePressed(MouseEvent me) {
        if (me.button == 3) {
            ((GEFGraphicalViewer)this.editPart.getViewer()).setNoDeselect();
            this.editPart.getViewer().select((EditPart)this.editPart);
        }
    }

    public void mouseReleased(MouseEvent me) {
    }
}

