/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.ui.editor.model.impl;

import java.util.Enumeration;
import java.util.Vector;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.struts.ui.editor.model.IForward;
import org.jboss.tools.struts.ui.editor.model.IForwardListener;
import org.jboss.tools.struts.ui.editor.model.ILink;
import org.jboss.tools.struts.ui.editor.model.IProcessItem;
import org.jboss.tools.struts.ui.editor.model.IStrutsElement;
import org.jboss.tools.struts.ui.editor.model.IStrutsElementList;
import org.jboss.tools.struts.ui.editor.model.impl.Link;
import org.jboss.tools.struts.ui.editor.model.impl.ProcessItem;
import org.jboss.tools.struts.ui.editor.model.impl.StrutsElement;
import org.jboss.tools.struts.ui.editor.model.impl.StrutsElementList;

public class Forward
extends StrutsElement
implements IForward {
    public Vector listeners = new Vector();
    Link link;
    IStrutsElementList partList = new StrutsElementList();
    String name;
    String target;
    boolean relink = false;

    public Forward(IStrutsElement parent, XModelObject source) {
        super(parent, source);
        this.target = source.getAttributeValue("target");
        this.initLink();
        this.name = this.getName();
    }

    public Forward(IStrutsElement parent) {
        super(parent);
        this.target = ((XModelObject)parent.getSource()).getAttributeValue("target");
        this.initLink();
        this.name = this.getName();
    }

    public XModelObject getTargetModel() {
        XModelObject target;
        if (this.source == null) {
            this.source = (XModelObject)this.parent.getSource();
            target = this.strutsModel.getHelper().getItemTarget(this.source);
        } else {
            target = this.strutsModel.getHelper().getItemOutputTarget(this.source);
        }
        return target;
    }

    public boolean isHidden() {
        String hidden;
        if (this.source == null) {
            this.source = (XModelObject)this.parent.getSource();
        }
        return "yes".equals(hidden = this.source.getAttributeValue("hidden"));
    }

    public String getTargetString() {
        return this.target;
    }

    public void initLink() {
        XModelObject target = this.getTargetModel();
        if (this.getProcessItem().isPage() && this.isHidden()) {
            this.link = null;
            return;
        }
        this.link = target != null ? new Link(this, target) : null;
    }

    public boolean canRename() {
        return true;
    }

    public boolean canDelete() {
        return true;
    }

    public String getText() {
        return "\t\t\t\t<MSG MESSAGE=\"" + this.getName() + "\"/>";
    }

    public void addForwardListener(IForwardListener listener) {
        this.listeners.add(listener);
    }

    public void removeForwardListener(IForwardListener listener) {
        this.listeners.remove(listener);
    }

    public void fireForwardRemoved() {
        Vector listeners = (Vector)this.listeners.clone();
        int i = 0;
        while (i < listeners.size()) {
            IForwardListener listener = (IForwardListener)listeners.elementAt(i);
            if (listener != null) {
                listener.forwardRemoved(this);
            }
            ++i;
        }
    }

    public void fireForwardChanged() {
        Vector listeners = (Vector)this.listeners.clone();
        int i = 0;
        while (i < listeners.size()) {
            IForwardListener listener = (IForwardListener)listeners.elementAt(i);
            if (listener != null) {
                listener.forwardChanged(this);
            }
            ++i;
        }
    }

    public void removeLink(IForward message) {
    }

    public ILink addLink(IProcessItem toProcessItem) {
        return null;
    }

    public ILink getLink() {
        return this.link;
    }

    public void rename(String newName) {
    }

    public IProcessItem getProcessItem() {
        return (IProcessItem)this.getParentStrutsElement();
    }

    public IStrutsElementList getPartList() {
        return this.partList;
    }

    public boolean isLinkAllowed() {
        return true;
    }

    public Enumeration children() {
        return null;
    }

    public boolean isLeaf() {
        return false;
    }

    public void remove() {
        if (this.link != null) {
            this.link.remove();
        }
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public void nodeChanged(Object eventData) {
        if (!this.name.equals(this.getName())) {
            this.propertyChangeSupport.firePropertyChange("name", this.name, this.getName());
            this.name = this.getName();
        }
        String targ = this.source.getAttributeValue("target");
        ProcessItem item = (ProcessItem)this.getProcessItem();
        if (this.link == null) {
            if (!"".equals(targ)) {
                if (item.isPage() && this.isHidden()) {
                    return;
                }
                this.initLink();
                if (this.link != null) {
                    if (item.isPage()) {
                        item.forwardList.fireElementAdded(this, item.forwardList.indexOf(this));
                        item.forwardList.add(this);
                        item.fireForwardAdd(this);
                    } else {
                        item.fireLinkAdd(this.link);
                        this.fireForwardChanged();
                    }
                }
            }
        } else if (item.isPage() && this.isHidden()) {
            this.link.remove();
            item.fireLinkRemove(this.link);
            this.link = null;
        } else if ("".equals(targ)) {
            this.link.remove();
            item.fireLinkRemove(this.link);
            this.link = null;
        } else if (!targ.equals(this.target)) {
            this.relink = true;
            if (item.isPage() && this.isHidden()) {
                this.relink = false;
            }
            int index = item.getForwardList().indexOf(this);
            this.link.remove();
            item.getForwardList().remove(this);
            item.fireLinkRemove(this.link);
            this.link = null;
            if (index < 0) {
                return;
            }
            item.getForwardList().add(index, this);
            this.initLink();
            if (this.link != null) {
                item.fireLinkAdd(this.link);
            }
            this.relink = false;
        } else {
            this.link.nodeChanged(eventData);
        }
        this.target = targ;
    }

    public boolean isException() {
        return "exception".equals(this.getType());
    }

    public boolean isRelink() {
        return this.relink;
    }
}

