/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.ui.editor.model.impl;

import java.util.Vector;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.action.XModelObjectActionList;
import org.jboss.tools.struts.ui.editor.model.IBreakPoint;
import org.jboss.tools.struts.ui.editor.model.IBreakPointListener;
import org.jboss.tools.struts.ui.editor.model.IForward;
import org.jboss.tools.struts.ui.editor.model.ILink;
import org.jboss.tools.struts.ui.editor.model.ILinkListener;
import org.jboss.tools.struts.ui.editor.model.IProcessItem;
import org.jboss.tools.struts.ui.editor.model.ISegment;
import org.jboss.tools.struts.ui.editor.model.IStrutsElement;
import org.jboss.tools.struts.ui.editor.model.impl.Forward;
import org.jboss.tools.struts.ui.editor.model.impl.ProcessItem;
import org.jboss.tools.struts.ui.editor.model.impl.Segment;
import org.jboss.tools.struts.ui.editor.model.impl.StrutsElement;

public class Link
extends StrutsElement
implements ILink {
    public static final String PATH_PROPERTY = "link shape";
    public static final String SHAPE_PROPERTY = "shape";
    public static final String HIDDEN_PROPERTY = "hidden";
    private boolean global = false;
    private String pathString;
    private String linkStatus;
    private boolean preferredMode = false;
    private int preferredLength = 0;
    Vector linkListeners = new Vector();
    XModelObject target;
    IProcessItem toProcessItem;
    ISegment headSegment;
    ISegment tailSegment;
    public HeadBreakPoint headBP;
    public TailBreakPoint tailBP;

    public boolean isPreferredMode() {
        return this.preferredMode;
    }

    public int getPreferredLength() {
        if (this.preferredMode) {
            return this.preferredLength;
        }
        return 0;
    }

    public void clearPreferred() {
        this.preferredMode = false;
    }

    public void update() {
        this.pathString = this.getPathText();
        if (this.global) {
            this.strutsModel.getHelper().setAttributeValue(this.source, PATH_PROPERTY, this.getPathText());
        } else {
            this.strutsModel.getHelper().setAttributeValue(this.source, SHAPE_PROPERTY, this.getPathText());
        }
    }

    public String getPathFromModel() {
        if (this.preferredMode) {
            return "";
        }
        if (this.global) {
            return this.source.getAttributeValue(PATH_PROPERTY);
        }
        return this.source.getAttributeValue(SHAPE_PROPERTY);
    }

    public String getPathText() {
        String text = "";
        if (this.headSegment != null) {
            ISegment currentSegment = this.headSegment;
            text = String.valueOf(text) + currentSegment.getLength();
            while (currentSegment.getNext() != null) {
                text = String.valueOf(text) + "," + currentSegment.getNext().getLength();
                currentSegment = currentSegment.getNext();
            }
        }
        return text;
    }

    public IBreakPoint getHeadBreakPoint() {
        return this.headBP;
    }

    public IBreakPoint getTailBreakPoint() {
        return this.tailBP;
    }

    public Link(IStrutsElement parent, XModelObject target) {
        super(parent);
        this.target = target;
        this.headBP = new HeadBreakPoint();
        this.tailBP = new TailBreakPoint();
        int[] path = null;
        this.source = (XModelObject)parent.getSource();
        this.global = this.source.getParent() == this.strutsModel.getSource();
        if (this.global) {
            this.pathString = this.source.getAttributeValue(PATH_PROPERTY);
            path = this.strutsModel.getHelper().asIntArray(this.source, PATH_PROPERTY);
        } else {
            this.pathString = this.source.getAttributeValue(SHAPE_PROPERTY);
            path = this.strutsModel.getHelper().asIntArray(this.source, SHAPE_PROPERTY);
        }
        this.linkStatus = this.getLinkStatus();
        if (path.length > 1 && path[0] == -1) {
            this.preferredMode = true;
            this.preferredLength = path[1];
            path = new int[]{};
        } else {
            this.preferredMode = false;
        }
        Segment prevSegment = null;
        int i = 0;
        while (i < path.length) {
            Segment newSegment = new Segment((ILink)this, path[i], prevSegment);
            if (i == 0) {
                this.headSegment = newSegment;
            }
            if (i == path.length - 1) {
                this.tailSegment = newSegment;
            }
            prevSegment = newSegment;
            ++i;
        }
    }

    public void setTarget() {
        if (this.target.getPath() == null) {
            return;
        }
        this.toProcessItem = (IProcessItem)this.strutsModel.findElement(this.target.getPath());
        ((ProcessItem)this.toProcessItem).addInputLink(this);
    }

    public XModelObject getTargetModel() {
        return this.target;
    }

    public Menu getPopupMenu(Control control, Object environment) {
        if (this.getSource() == null) {
            return null;
        }
        if (this.strutsModel.getHelper().getLinkActionList((XModelObject)this.parent.getSource()).getActionItems().length != 0) {
            XModelObjectActionList l = new XModelObjectActionList(this.strutsModel.getHelper().getLinkActionList((XModelObject)this.parent.getSource()), (XModelObject)this.parent.getSource(), null, environment);
            Menu menu = l.createMenu(control);
            return menu;
        }
        return null;
    }

    public String getToProcessItemName() {
        return this.toProcessItem.getPath();
    }

    public IProcessItem getToProcessItem() {
        return this.toProcessItem;
    }

    public IForward getFromForward() {
        return (IForward)this.getParentStrutsElement();
    }

    public IProcessItem getFromProcessItem() {
        return this.getFromForward().getProcessItem();
    }

    public boolean isShortcut() {
        boolean flag = this.strutsModel.getHelper().isShortcut(this.source);
        return flag;
    }

    public boolean isConfirmed() {
        if (((ProcessItem)this.getFromProcessItem()).type.equals("page")) {
            String subtype = this.source.getAttributeValue("subtype");
            return "confirmed".equals(subtype);
        }
        return true;
    }

    public boolean isHidden() {
        String hidden = this.source.getAttributeValue(HIDDEN_PROPERTY);
        return "yes".equals(hidden);
    }

    public void remove() {
        if (this.toProcessItem != null) {
            ((ProcessItem)this.toProcessItem).removeInputLink(this);
        }
        if (((ProcessItem)this.getFromProcessItem()).type.equals("page")) {
            if (!((Forward)this.parent).isRelink()) {
                ((ProcessItem)this.getFromProcessItem()).forwardList.removeForward(this.getFromForward());
            }
        } else {
            ((ProcessItem)this.getFromProcessItem()).forwardList.removeForward(this.getFromForward());
        }
        this.fireLinkRemove();
        ((ProcessItem)this.getFromProcessItem()).fireLinkRemove(this);
    }

    public void addLinkListener(ILinkListener l) {
        this.linkListeners.add(l);
    }

    public void removeLinkListener(ILinkListener l) {
        this.linkListeners.remove(l);
    }

    public ISegment getHeadSegment() {
        return this.headSegment;
    }

    public ISegment getTailSegment() {
        return this.tailSegment;
    }

    public void setHeadSegment(ISegment segment) {
        ISegment oldHeadSegment = this.headSegment;
        this.headSegment = segment;
        this.propertyChangeSupport.firePropertyChange("headSegment", oldHeadSegment, segment);
    }

    public void setTailSegment(ISegment segment) {
        ISegment oldTailSegment = this.tailSegment;
        this.tailSegment = segment;
        this.propertyChangeSupport.firePropertyChange("tailSegment", oldTailSegment, segment);
    }

    public ISegment createSegment(int length, ISegment prevSegment) {
        Segment newSegment = new Segment((ILink)this, length, prevSegment);
        return newSegment;
    }

    public void fireLinkChange() {
        Vector targets = (Vector)this.linkListeners.clone();
        int i = 0;
        while (i < targets.size()) {
            ILinkListener listener = (ILinkListener)targets.get(i);
            if (listener != null) {
                listener.linkChange(this);
            }
            ++i;
        }
    }

    public void fireLinkRemove() {
        Vector targets = (Vector)this.linkListeners.clone();
        int i = 0;
        while (i < targets.size()) {
            ILinkListener listener = (ILinkListener)targets.get(i);
            if (listener != null) {
                listener.linkRemove(this);
            }
            ++i;
        }
        ((ProcessItem)this.getFromProcessItem()).fireLinkRemove(this);
    }

    public void fireLinkRelink() {
        Vector targets = (Vector)this.linkListeners.clone();
        int i = 0;
        while (i < targets.size()) {
            ILinkListener listener = (ILinkListener)targets.get(i);
            if (listener != null) {
                listener.linkRelink(this);
            }
            ++i;
        }
    }

    private String getLinkStatus() {
        return String.valueOf(this.source.getAttributeValue(HIDDEN_PROPERTY)) + ":" + this.source.getAttributeValue("shortcut");
    }

    public void nodeChanged(Object eventData) {
        String temp;
        int[] path = null;
        String ls = this.getLinkStatus();
        if (this.global) {
            temp = this.source.getAttributeValue(PATH_PROPERTY);
            path = this.strutsModel.getHelper().asIntArray(this.source, PATH_PROPERTY);
        } else {
            temp = this.source.getAttributeValue(SHAPE_PROPERTY);
            path = this.strutsModel.getHelper().asIntArray(this.source, SHAPE_PROPERTY);
        }
        if (path.length > 1 && path[0] == -1) {
            this.preferredMode = true;
            this.preferredLength = path[1];
            path = new int[]{};
        } else {
            this.preferredMode = false;
        }
        if (this.pathString.equals(temp) && (this.linkStatus == null || this.linkStatus.equals(ls))) {
            this.fireLinkChange();
            this.tailBP.fireBreakPointChange();
            return;
        }
        Segment prevSegment = null;
        int i = 0;
        while (i < path.length) {
            Segment newSegment = new Segment((ILink)this, path[i], prevSegment);
            if (i == 0) {
                this.headSegment = newSegment;
            }
            if (i == path.length - 1) {
                this.tailSegment = newSegment;
            }
            prevSegment = newSegment;
            ++i;
        }
        this.pathString = temp;
        this.linkStatus = ls;
        this.fireLinkChange();
        this.tailBP.fireBreakPointChange();
    }

    public boolean isHeadBreakpointActive() {
        return (this.getStrutsModel().getHelper().getBreakpointManager((XModelObject)this.getStrutsModel().getSource()).getBreakpointStatus((XModelObject)this.getToProcessItem().getSource()) & 8) > 0;
    }

    public int getTailBreakpointStatus() {
        int value = this.getStrutsModel().getHelper().getBreakpointManager((XModelObject)this.getStrutsModel().getSource()).getBreakpointStatus((XModelObject)this.getSource());
        int status = 0;
        if ((value & 1) > 0) {
            status = 1;
        } else if ((value & 4) > 0) {
            status = 4;
        } else if ((value & 2) > 0) {
            status = 2;
        }
        return status;
    }

    public boolean isTailBreakpointActive() {
        return (this.getStrutsModel().getHelper().getBreakpointManager((XModelObject)this.getStrutsModel().getSource()).getBreakpointStatus((XModelObject)this.getSource()) & 8) > 0;
    }

    public boolean isDebugMode() {
        return this.getStrutsModel().getHelper().getBreakpointManager((XModelObject)this.getStrutsModel().getSource()).isDebugMode();
    }

    public PointList getPointList() {
        int[] path = null;
        if (this.global) {
            this.pathString = this.source.getAttributeValue(PATH_PROPERTY);
            path = this.strutsModel.getHelper().asIntArray(this.source, PATH_PROPERTY);
        } else {
            this.pathString = this.source.getAttributeValue(SHAPE_PROPERTY);
            path = this.strutsModel.getHelper().asIntArray(this.source, SHAPE_PROPERTY);
        }
        PointList list = new PointList();
        if (path.length < 4) {
            return list;
        }
        if (path.length % 2 == 1) {
            return list;
        }
        int i = 0;
        while (i < path.length) {
            list.addPoint(path[i], path[i + 1]);
            i += 2;
        }
        return list;
    }

    public void savePointList(PointList list) {
        String value = new String("");
        int i = 0;
        while (i < list.size()) {
            if (i != 0) {
                value = String.valueOf(value) + ",";
            }
            Point p = list.getPoint(i);
            value = String.valueOf(value) + p.x + "," + p.y;
            ++i;
        }
        if (this.global) {
            this.strutsModel.getHelper().setAttributeValue(this.source, PATH_PROPERTY, value);
        } else {
            this.strutsModel.getHelper().setAttributeValue(this.source, SHAPE_PROPERTY, value);
        }
    }

    public void clearPointList() {
        this.source.setAttributeValue(SHAPE_PROPERTY, "");
    }

    class HeadBreakPoint
    implements IBreakPoint {
        Vector listeners = new Vector();

        HeadBreakPoint() {
        }

        public void addBreakPointListener(IBreakPointListener listener) {
            this.listeners.add(listener);
        }

        public void removeBreakPointListener(IBreakPointListener listener) {
            this.listeners.remove(listener);
        }

        public void fireBreakPointChange() {
            int i = 0;
            while (i < this.listeners.size()) {
                ((IBreakPointListener)this.listeners.get(i)).breakPointChange();
                ++i;
            }
        }

        public boolean isDebugMode() {
            return Link.this.getStrutsModel().getHelper().getBreakpointManager((XModelObject)Link.this.getStrutsModel().getSource()).isDebugMode();
        }

        public int getStatus() {
            int value = Link.this.getStrutsModel().getHelper().getBreakpointManager((XModelObject)Link.this.getStrutsModel().getSource()).getBreakpointStatus((XModelObject)Link.this.getToProcessItem().getSource());
            int status = 0;
            if ((value & 1) > 0) {
                status = 1;
            } else if ((value & 4) > 0) {
                status = 4;
            } else if ((value & 2) > 0) {
                status = 2;
            }
            return status;
        }

        public int getActiveStatus() {
            return Link.this.getStrutsModel().getHelper().getBreakpointManager((XModelObject)Link.this.getStrutsModel().getSource()).getActiveBreakpointNumber((XModelObject)Link.this.getToProcessItem().getSource());
        }

        public boolean isActive() {
            return (Link.this.getStrutsModel().getHelper().getBreakpointManager((XModelObject)Link.this.getStrutsModel().getSource()).getBreakpointStatus((XModelObject)Link.this.getToProcessItem().getSource()) & 8) > 0;
        }

        public boolean isProcessItem() {
            return true;
        }
    }

    class TailBreakPoint
    implements IBreakPoint {
        Vector listeners = new Vector();

        TailBreakPoint() {
        }

        public void addBreakPointListener(IBreakPointListener listener) {
            this.listeners.add(listener);
        }

        public void removeBreakPointListener(IBreakPointListener listener) {
            this.listeners.remove(listener);
        }

        public void fireBreakPointChange() {
            int i = 0;
            while (i < this.listeners.size()) {
                ((IBreakPointListener)this.listeners.get(i)).breakPointChange();
                ++i;
            }
        }

        public boolean isDebugMode() {
            return Link.this.getStrutsModel().getHelper().getBreakpointManager((XModelObject)Link.this.getStrutsModel().getSource()).isDebugMode();
        }

        public int getActiveStatus() {
            return Link.this.getStrutsModel().getHelper().getBreakpointManager((XModelObject)Link.this.getStrutsModel().getSource()).getActiveBreakpointNumber((XModelObject)Link.this.getSource());
        }

        public int getStatus() {
            int value = Link.this.getStrutsModel().getHelper().getBreakpointManager((XModelObject)Link.this.getStrutsModel().getSource()).getBreakpointStatus((XModelObject)Link.this.getSource());
            int status = 0;
            if ((value & 1) > 0) {
                status = 1;
            } else if ((value & 4) > 0) {
                status = 4;
            } else if ((value & 2) > 0) {
                status = 2;
            }
            return status;
        }

        public boolean isActive() {
            return (Link.this.getStrutsModel().getHelper().getBreakpointManager((XModelObject)Link.this.getStrutsModel().getSource()).getBreakpointStatus((XModelObject)Link.this.getSource()) & 8) > 0;
        }

        public boolean isProcessItem() {
            return false;
        }
    }
}

