/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.ui.editor.model.impl;

import java.beans.PropertyChangeEvent;
import java.util.Vector;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.event.XModelTreeEvent;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.struts.model.helpers.StrutsProcessStructureHelper;
import org.jboss.tools.struts.ui.editor.model.IBreakPoint;
import org.jboss.tools.struts.ui.editor.model.IBreakPointListener;
import org.jboss.tools.struts.ui.editor.model.IForward;
import org.jboss.tools.struts.ui.editor.model.ILink;
import org.jboss.tools.struts.ui.editor.model.IProcessItem;
import org.jboss.tools.struts.ui.editor.model.IProcessItemListener;
import org.jboss.tools.struts.ui.editor.model.IStrutsElement;
import org.jboss.tools.struts.ui.editor.model.IStrutsElementList;
import org.jboss.tools.struts.ui.editor.model.IStrutsElementListListener;
import org.jboss.tools.struts.ui.editor.model.IStrutsModel;
import org.jboss.tools.struts.ui.editor.model.impl.Forward;
import org.jboss.tools.struts.ui.editor.model.impl.Link;
import org.jboss.tools.struts.ui.editor.model.impl.StrutsElement;
import org.jboss.tools.struts.ui.editor.model.impl.StrutsElementList;
import org.jboss.tools.struts.ui.editor.model.impl.StrutsModel;

public class ProcessItem
extends StrutsElement
implements IProcessItem,
IStrutsElementListListener {
    public static Color DEFAULT_FOREGROUND_COLOR = new Color(null, 0, 0, 0);
    public static Color DEFAULT_BACKGROUND_COLOR = new Color(null, 228, 228, 228);
    public static String TYPE_PROPERTY = "type";
    public static String SUBTYPE_PROPERTY = "subtype";
    public static String COMMENT_PROPERTY = "comment";
    protected Image icon = null;
    protected Color headerForegroundColor = DEFAULT_FOREGROUND_COLOR;
    protected Color headerBackgroundColor = DEFAULT_BACKGROUND_COLOR;
    String type;
    public ForwardList forwardList;
    Vector processItemListeners = new Vector();
    boolean selected = false;
    Vector<ILink> inputLinks = new Vector();
    String name;
    String path;
    private BreakPoint bp;

    public ProcessItem(IStrutsModel model, XModelObject processItemNode) {
        super(model, processItemNode);
        this.bp = new BreakPoint();
        this.type = processItemNode.getAttributeValue(TYPE_PROPERTY);
        this.icon = EclipseResourceUtil.getImage((XModelObject)processItemNode);
        if (this.type.equals("action") || this.type.equals("page")) {
            this.global = false;
        } else if (this.type.equals("forward") || this.type.equals("exception")) {
            this.global = true;
        }
        if (this.type != null) {
            this.forwardList = new ForwardList(processItemNode);
            this.forwardList.addStrutsElementListListener(this);
        }
        this.name = (String)this.getSourceProperty("name");
        this.path = (String)this.getSourceProperty("path");
    }

    public Image getImage() {
        return this.icon;
    }

    public ProcessItem(IStrutsModel model, IStrutsElement element) {
        super(model);
    }

    public String getViewClassName() {
        return this.strutsModel.getHelper().getItemGUIClass(this.source);
    }

    public String getVisiblePath() {
        if (this.type.equals("page")) {
            return StrutsProcessStructureHelper.instance.getPageTitle(this.source);
        }
        return this.getPath();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean isPage() {
        return this.type.equals("page");
    }

    public boolean isComment() {
        return this.type.equals("comment");
    }

    public boolean hasErrors() {
        return this.getStrutsModel().getHelper().hasErrors((XModelObject)this.getSource());
    }

    public boolean isAction() {
        return this.type.equals("action");
    }

    public boolean isSwitchAction() {
        if (this.isAction()) {
            String subtype = this.source.getAttributeValue(SUBTYPE_PROPERTY);
            return subtype.equals("switch");
        }
        return false;
    }

    public boolean isAnotherModule() {
        return this.strutsModel.getHelper().isItemFromOtherModule((XModelObject)this.getSource());
    }

    public boolean isGlobal() {
        return this.type.equals("forward") || this.type.equals("exception");
    }

    public void setSelected(boolean set) {
        boolean oldValue = this.selected;
        this.selected = set;
        this.propertyChangeSupport.firePropertyChange("selected", oldValue, set);
        if (set) {
            this.getStrutsModel().setSelectedProcessItem(this);
        }
    }

    public void clearSelection() {
        IStrutsElementList list = this.getStrutsModel().getProcessItemList();
        int i = 0;
        while (i < list.size()) {
            IProcessItem activity = (IProcessItem)list.get(i);
            activity.setSelected(false);
            ++i;
        }
    }

    public boolean hasPageHiddenLinks() {
        if (this.getSource() != null && this.isPage()) {
            return this.strutsModel.getHelper().hasPageHiddenLinks((XModelObject)this.getSource());
        }
        return false;
    }

    public IProcessItem getCommentTarget() {
        IProcessItem pItem = null;
        XModelObject target = null;
        if (this.getSource() != null) {
            target = this.strutsModel.getHelper().getItemTarget((XModelObject)this.getSource());
            if (target == null) {
                return null;
            }
            pItem = (IProcessItem)this.strutsModel.findElement(target.getPath());
        }
        return pItem;
    }

    public boolean isConfirmed() {
        if (this.type.equals("page")) {
            return this.strutsModel.getHelper().isPageConfirmed(this.source);
        }
        return !"unknown".equals(this.source.getAttributeValue(SUBTYPE_PROPERTY));
    }

    public void setHeaderForegroundColor(Color color) {
        this.headerForegroundColor = color;
    }

    public Color getHeaderForegroundColor() {
        return this.headerForegroundColor;
    }

    public void setHeaderBackgroundColor(Color color) {
        this.headerBackgroundColor = color;
    }

    public Color getHeaderBackgroundColor() {
        return this.headerBackgroundColor;
    }

    public ILink[] getLinks() {
        IStrutsElementList outputForwards = this.getForwardList();
        Vector links = (Vector)this.inputLinks.clone();
        int i = 0;
        while (i < outputForwards.size()) {
            ILink link = ((IForward)outputForwards.get(i)).getLink();
            if (link != null) {
                links.add(link);
            }
            ++i;
        }
        ILink[] trans = new ILink[links.size()];
        links.toArray(trans);
        return trans;
    }

    public Vector getListInputLinks() {
        return this.inputLinks;
    }

    public Vector getListOutputLinks() {
        IStrutsElementList outputForwards = this.getForwardList();
        Vector<ILink> links = new Vector<ILink>();
        int i = 0;
        while (i < outputForwards.size()) {
            ILink link = ((IForward)outputForwards.get(i)).getLink();
            if (link != null) {
                links.add(link);
            }
            ++i;
        }
        return links;
    }

    public ILink[] getInputLinks() {
        ILink[] links = new ILink[this.inputLinks.size()];
        return this.inputLinks.toArray(links);
    }

    public void addInputLink(ILink link) {
        if (!this.inputLinks.contains(link)) {
            this.inputLinks.add(link);
        }
    }

    public void removeInputLink(ILink link) {
        this.inputLinks.remove(link);
    }

    public ILink[] getOutputLinks() {
        IStrutsElementList outputForwards = this.getForwardList();
        Vector<ILink> links = new Vector<ILink>();
        int i = 0;
        while (i < outputForwards.size()) {
            ILink link = ((IForward)outputForwards.get(i)).getLink();
            if (link != null) {
                links.add(link);
            }
            ++i;
        }
        ILink[] trans = new ILink[links.size()];
        links.toArray(trans);
        return trans;
    }

    public IForward getForward(String forwardName) {
        return (Forward)this.forwardList.get(forwardName);
    }

    public IStrutsElementList getForwardList() {
        return this.forwardList;
    }

    public void fireProcessItemChange() {
        if (this.processItemListeners.size() == 0) {
            return;
        }
        Vector targets = (Vector)this.processItemListeners.clone();
        int i = 0;
        while (i < targets.size()) {
            IProcessItemListener listener = (IProcessItemListener)targets.get(i);
            if (listener != null) {
                listener.processItemChange();
            }
            ++i;
        }
    }

    public void fireForwardAdd(IForward message) {
        Vector listeners = (Vector)this.processItemListeners.clone();
        int i = 0;
        while (i < listeners.size()) {
            IProcessItemListener listener = (IProcessItemListener)listeners.get(i);
            if (listener != null && listener.isProcessItemListenerEnable()) {
                ((IProcessItemListener)listeners.get(i)).processItemForwardAdd(this, message);
            }
            ++i;
        }
    }

    public void fireLinkAdd(ILink link) {
        Vector listeners = (Vector)this.processItemListeners.clone();
        int i = 0;
        while (i < listeners.size()) {
            IProcessItemListener listener = (IProcessItemListener)listeners.get(i);
            if (listener != null && listener.isProcessItemListenerEnable()) {
                ((IProcessItemListener)listeners.get(i)).linkAdd(link);
            }
            ++i;
        }
    }

    public void fireLinkRemove(ILink link) {
        Vector listeners = (Vector)this.processItemListeners.clone();
        int i = 0;
        while (i < listeners.size()) {
            IProcessItemListener listener = (IProcessItemListener)listeners.get(i);
            if (listener != null && listener.isProcessItemListenerEnable()) {
                ((IProcessItemListener)listeners.get(i)).linkRemove(link);
            }
            ++i;
        }
    }

    public void fireForwardRemove(IForward message, int index) {
        Vector listeners = (Vector)this.processItemListeners.clone();
        int i = 0;
        while (i < listeners.size()) {
            IProcessItemListener listener = (IProcessItemListener)listeners.get(i);
            if (listener != null && listener.isProcessItemListenerEnable()) {
                ((IProcessItemListener)listeners.get(i)).processItemForwardRemove(this, message);
            }
            ++i;
        }
    }

    public void fireForwardChange(IForward message, PropertyChangeEvent evt) {
    }

    public void remove() {
        ILink[] links = this.getLinks();
        int i = 0;
        while (i < links.length) {
            links[i].remove();
            ++i;
        }
    }

    public void addProcessItemListener(IProcessItemListener listener) {
        this.processItemListeners.add(listener);
    }

    public void removeProcessItemListener(IProcessItemListener listener) {
    }

    public void removeFromStrutsModel() {
    }

    public void nodeChanged(Object eventData) {
        this.fireProcessItemChange();
        this.propertyChangeSupport.firePropertyChange("name", this.name, this.getSourceProperty("name"));
        this.name = (String)this.getSourceProperty("name");
        this.bp.fireBreakPointChange();
        int i = 0;
        while (i < this.inputLinks.size()) {
            ((Link)this.inputLinks.get((int)i)).headBP.fireBreakPointChange();
            ++i;
        }
        if (this.global) {
            if (this.forwardList.size() == 0) {
                if (!"".equals(this.getPath())) {
                    Forward newForward = new Forward(this);
                    this.forwardList.add(newForward);
                    this.fireForwardAdd(newForward);
                    ILink newLink = newForward.getLink();
                    if (newLink != null) {
                        this.fireLinkAdd(newLink);
                    }
                }
            } else if ("".equals(this.getTarget())) {
                IForward forward = (IForward)this.forwardList.get(0);
                this.forwardList.remove(forward);
                forward.remove();
                this.fireForwardRemove((Forward)forward, 0);
            } else {
                Forward forward = (Forward)this.forwardList.get(0);
                if (!forward.getTargetString().equals(this.getTarget())) {
                    this.forwardList.remove(forward);
                    forward.remove();
                    this.fireForwardRemove(forward, 0);
                    Forward newForward = new Forward(this);
                    this.forwardList.add(newForward);
                    this.fireForwardAdd(newForward);
                    ILink newLink = newForward.getLink();
                    if (newLink != null) {
                        this.fireLinkAdd(newLink);
                    }
                }
                forward.nodeChanged(eventData);
            }
        } else {
            this.propertyChangeSupport.firePropertyChange("path", this.path, this.getSourceProperty("path"));
            this.path = (String)this.getSourceProperty("name");
        }
    }

    public void structureChanged(Object eventData) {
        this.forwardList.structureChanged(eventData);
    }

    public void nodeAdded(Object eventData) {
        this.forwardList.nodeAdded(eventData);
    }

    public void nodeRemoved(Object eventData) {
        this.forwardList.nodeRemoved(eventData);
    }

    public boolean isElementListListenerEnable() {
        return true;
    }

    public void setElementListListenerEnable(boolean set) {
    }

    public void listElementMove(IStrutsElementList list, IStrutsElement element, int newIndex, int oldIndex) {
    }

    public void listElementAdd(IStrutsElementList list, IStrutsElement element, int index) {
        this.fireForwardAdd((IForward)element);
    }

    public void listElementRemove(IStrutsElementList list, IStrutsElement element, int index) {
        this.fireForwardRemove((IForward)element, index);
    }

    public void listElementChange(IStrutsElementList list, IStrutsElement element, int index, PropertyChangeEvent event) {
    }

    public IBreakPoint getBreakPoint() {
        return this.bp;
    }

    class BreakPoint
    implements IBreakPoint {
        Vector listeners = new Vector();

        BreakPoint() {
        }

        public void addBreakPointListener(IBreakPointListener listener) {
            this.listeners.add(listener);
        }

        public void removeBreakPointListener(IBreakPointListener listener) {
            this.listeners.remove(listener);
        }

        public void fireBreakPointChange() {
            int i = 0;
            while (i < this.listeners.size()) {
                ((IBreakPointListener)this.listeners.get(i)).breakPointChange();
                ++i;
            }
        }

        public boolean isProcessItem() {
            return true;
        }

        public int getStatus() {
            int value = ProcessItem.this.getStrutsModel().getHelper().getBreakpointManager((XModelObject)ProcessItem.this.getStrutsModel().getSource()).getBreakpointStatus((XModelObject)ProcessItem.this.getSource());
            int status = 0;
            if ((value & 1) > 0) {
                status = 1;
            } else if ((value & 4) > 0) {
                status = 4;
            } else if ((value & 2) > 0) {
                status = 2;
            }
            return status;
        }

        public boolean isActive() {
            return (ProcessItem.this.getStrutsModel().getHelper().getBreakpointManager((XModelObject)ProcessItem.this.getStrutsModel().getSource()).getBreakpointStatus((XModelObject)ProcessItem.this.getSource()) & 8) > 0;
        }

        public boolean isDebugMode() {
            return ProcessItem.this.getStrutsModel().getHelper().getBreakpointManager((XModelObject)ProcessItem.this.getStrutsModel().getSource()).isDebugMode();
        }

        public int getActiveStatus() {
            return ProcessItem.this.getStrutsModel().getHelper().getBreakpointManager((XModelObject)ProcessItem.this.getStrutsModel().getSource()).getActiveBreakpointNumber((XModelObject)ProcessItem.this.getSource());
        }
    }

    public class ForwardList
    extends StrutsElementList {
        public ForwardList(XModelObject listSource) {
            super(ProcessItem.this);
            if (ProcessItem.this.global) {
                if (this.strutsModel.getHelper().getItemTarget(ProcessItem.this.source) != null) {
                    Forward newForward = new Forward(ProcessItem.this);
                    this.add(newForward);
                }
            } else {
                XModelObject[] forwards = listSource.getChildren();
                int i = 0;
                while (i < forwards.length) {
                    Forward newForward = new Forward(ProcessItem.this, forwards[i]);
                    if (!newForward.isHidden()) {
                        this.add(newForward);
                    }
                    ++i;
                }
            }
        }

        public void structureChanged(Object eventData) {
            XModelObject o;
            IStrutsElement pe;
            XModelObject listSource = (XModelObject)ProcessItem.this.getSource();
            XModelObject[] forwards = listSource.getChildren();
            if (forwards.length != this.size()) {
                return;
            }
            int i = 0;
            while (i < this.size()) {
                pe = this.get(i);
                o = (XModelObject)pe.getSource();
                if (listSource.getChildByPath(o.getPathPart()) == null) {
                    return;
                }
                ++i;
            }
            i = 0;
            while (i < this.size()) {
                pe = this.get(i);
                o = (XModelObject)pe.getSource();
                if (!forwards[i].getPathPart().equals(o.getPathPart())) {
                    this.moveTo(pe, this.size() - 1);
                    --i;
                }
                ++i;
            }
        }

        public void nodeAdded(Object eventData) {
            XModelTreeEvent event = (XModelTreeEvent)eventData;
            Forward newForward = new Forward(ProcessItem.this, (XModelObject)event.getInfo());
            if (ProcessItem.this.type.equals("page") && newForward.getLink() == null) {
                return;
            }
            this.add(newForward);
            ProcessItem.this.fireForwardAdd(newForward);
            ILink newLink = newForward.getLink();
            if (newLink != null) {
                ProcessItem.this.fireLinkAdd(newLink);
            }
        }

        public void nodeRemoved(Object eventData) {
            XModelTreeEvent event = (XModelTreeEvent)eventData;
            IStrutsElement removedForward = this.getFromMap(event.getInfo());
            this.removeFromMap(((XModelTreeEvent)eventData).getInfo());
            int index = this.indexOf(removedForward);
            this.remove(removedForward);
            removedForward.remove();
            ProcessItem.this.fireForwardRemove((Forward)removedForward, index);
        }

        public void addForward(IForward forward) {
            ((StrutsModel)this.strutsModel).putToMap(forward.getSource(), forward);
            this.add(forward);
            ProcessItem.this.fireForwardAdd(forward);
        }

        public void removeForward(IForward forward) {
            this.removeFromMap(forward);
            int index = this.indexOf(forward);
            this.remove(forward);
            ProcessItem.this.fireForwardRemove(forward, index);
        }
    }
}

