/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.ui.editor.model.impl;

import org.jboss.tools.struts.ui.StrutsUIPlugin;
import org.jboss.tools.struts.ui.editor.model.ILink;
import org.jboss.tools.struts.ui.editor.model.ISegment;
import org.jboss.tools.struts.ui.editor.model.impl.StrutsElement;
import org.w3c.dom.Element;

public class Segment
extends StrutsElement
implements ISegment {
    int length;
    ISegment prevSegment;
    ISegment nextSegment;

    public Segment(ILink parent, Element segmentElement, ISegment prevSegment) {
        super(parent);
        try {
            this.setName("SEGMENT");
            this.length = Integer.parseInt(segmentElement.getAttribute("length"));
        }
        catch (Exception e) {
            StrutsUIPlugin.getPluginLog().logError((Throwable)e);
            this.length = 0;
        }
        this.prevSegment = prevSegment;
        if (prevSegment != null) {
            prevSegment.setNext(this);
        }
    }

    public Segment(ILink parent, int length, ISegment prevSegment) {
        super(parent);
        try {
            this.setName("SEGMENT");
            this.length = length;
        }
        catch (Exception e) {
            StrutsUIPlugin.getPluginLog().logError((Throwable)e);
            length = 0;
        }
        this.length = length;
        this.prevSegment = (Segment)prevSegment;
        if (prevSegment != null) {
            prevSegment.setNext(this);
        }
    }

    public ISegment getNext() {
        return this.nextSegment;
    }

    public ISegment getPrev() {
        return this.prevSegment;
    }

    public void setPrev(ISegment segment) {
        ISegment oldPrev = this.prevSegment;
        this.prevSegment = (Segment)segment;
        this.propertyChangeSupport.firePropertyChange("prev", oldPrev, segment);
    }

    public void setNext(ISegment segment) {
        ISegment oldNext = this.nextSegment;
        this.nextSegment = (Segment)segment;
        this.propertyChangeSupport.firePropertyChange("next", oldNext, segment);
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        int oldLength = this.length;
        this.length = length;
        this.propertyChangeSupport.firePropertyChange("length", oldLength, length);
    }

    public String getName() {
        return "" + this.getLength();
    }
}

