/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.ui.editor.model.impl;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.action.XModelObjectActionList;
import org.jboss.tools.struts.model.helpers.StrutsProcessStructureHelper;
import org.jboss.tools.struts.ui.StrutsUIPlugin;
import org.jboss.tools.struts.ui.editor.model.IStrutsElement;
import org.jboss.tools.struts.ui.editor.model.IStrutsModel;
import org.jboss.tools.struts.ui.editor.model.impl.Forward;
import org.jboss.tools.struts.ui.editor.model.impl.StrutsModel;

public class StrutsElement
implements IStrutsElement {
    protected boolean jump = true;
    protected String name = "";
    protected boolean visible = false;
    protected boolean hidden = false;
    protected boolean deleted = false;
    protected boolean global = false;
    protected Dimension size;
    protected Point position;
    protected IStrutsElement parent;
    protected IStrutsModel strutsModel;
    protected String iconPath;
    protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    protected VetoableChangeSupport vetoableChangeSupport = new VetoableChangeSupport(this);
    protected XModelObject source;
    protected Hashtable map = new Hashtable();
    private Rectangle forwardBounds = new Rectangle(0, 0, 0, 0);

    public boolean isJump() {
        return this.jump;
    }

    public void setJump(boolean flag) {
        this.jump = flag;
    }

    public StrutsElement() {
    }

    public StrutsElement(IStrutsElement parent) {
        this.parent = parent;
        this.strutsModel = this.getStrutsModel();
    }

    public StrutsElement(IStrutsElement parent, XModelObject source) {
        this.parent = parent;
        this.source = source;
        this.strutsModel = this.getStrutsModel();
        ((StrutsModel)this.strutsModel).putToMap(source.getPath(), this);
    }

    public Object getSource() {
        return this.source;
    }

    public void setSource(Object obj) {
        this.source = (XModelObject)obj;
    }

    public String getText() {
        return "";
    }

    public IStrutsElement getRoot() {
        IStrutsElement current = this;
        while (current.getParentStrutsElement() != null) {
            current = current.getParentStrutsElement();
        }
        return current;
    }

    public IStrutsModel getStrutsModel() {
        IStrutsElement model = this.getRoot();
        if (model instanceof IStrutsElement) {
            return (IStrutsModel)model;
        }
        return null;
    }

    public String getStrutsElementPath() {
        IStrutsElement current = this;
        String path = current.getName();
        while (current.getParentStrutsElement() != null) {
            current = current.getParentStrutsElement();
            path = String.valueOf(current.getName()) + "/" + path;
        }
        return path;
    }

    public void updateModelModifiedProperty(Object oldValue, Object newValue) {
        block4: {
            if (this.getStrutsModel() != null) {
                try {
                    if (oldValue == null || !oldValue.equals(newValue)) {
                        this.getStrutsModel().setModified(true);
                    }
                }
                catch (Exception e) {
                    StrutsUIPlugin.getPluginLog().logError((Throwable)e);
                    if (newValue == null) break block4;
                    this.getStrutsModel().setModified(true);
                }
            }
        }
    }

    public void updateModelModifiedProperty(int oldValue, int newValue) {
        if (this.getStrutsModel() != null) {
            if (newValue != oldValue) {
                // empty if block
            }
            this.getStrutsModel().setModified(true);
        }
    }

    public void updateModelModifiedProperty(boolean oldValue, boolean newValue) {
        if (this.getStrutsModel() != null) {
            if (newValue != oldValue) {
                // empty if block
            }
            this.getStrutsModel().setModified(true);
        }
    }

    public void fireModelElementChanged() {
    }

    public String getIconPath() {
        return this.iconPath;
    }

    public void setIconPath(String path) {
        String oldValue = this.iconPath;
        this.iconPath = path;
        this.propertyChangeSupport.firePropertyChange("iconPath", oldValue, this.iconPath);
        this.updateModelModifiedProperty(oldValue, path);
    }

    public IStrutsElement getParentStrutsElement() {
        return this.parent;
    }

    public void setParentStrutsElement(IStrutsElement element) {
        IStrutsElement oldValue = this.parent;
        this.parent = element;
        this.strutsModel = this.getStrutsModel();
        this.propertyChangeSupport.firePropertyChange("parent", oldValue, element);
        this.updateModelModifiedProperty(oldValue, element);
    }

    public String getName() {
        return this.source.getAttributeValue("title");
    }

    public String getPath() {
        return StrutsProcessStructureHelper.instance.getModuleRelativePath(this.source);
    }

    public String getType() {
        return this.source.getAttributeValue("type");
    }

    public String getTarget() {
        return this.source.getAttributeValue("target");
    }

    public void setName(String name) throws PropertyVetoException {
        String oldValue = this.name;
        this.vetoableChangeSupport.fireVetoableChange("name", oldValue, name);
        this.name = name;
    }

    public Dimension getSize() {
        int[] bounds = this.strutsModel.getHelper().asIntArray(this.source, "shape");
        if (bounds.length < 4) {
            return new Dimension(0, 0);
        }
        return new Dimension(bounds[2], bounds[3]);
    }

    public void setSize(Dimension size) {
        Dimension oldValue = this.size;
        this.size = size;
        this.updateSourceProperty("shape", this.getPosition(), size);
        this.propertyChangeSupport.firePropertyChange("shape", oldValue, size);
        this.updateModelModifiedProperty(oldValue, size);
    }

    public Point getPosition() {
        int[] bounds = this.strutsModel.getHelper().asIntArray(this.source, "shape");
        if (bounds.length < 2) {
            return DEFAULT_POINT;
        }
        if (bounds[0] == 0 && bounds[1] == 0) {
            return DEFAULT_POINT;
        }
        return new Point(bounds[0], bounds[1]);
    }

    public void setPosition(Point point) {
        Point oldValue = this.position != null ? new Point(this.position.x, this.position.y) : null;
        this.position = point;
        this.updateSourceProperty("shape", point, this.getSize());
        this.propertyChangeSupport.firePropertyChange("shape", oldValue, point);
        this.updateModelModifiedProperty(oldValue, point);
    }

    public Rectangle getBounds() {
        if (this instanceof Forward) {
            return this.forwardBounds;
        }
        int[] bounds = this.strutsModel.getHelper().asIntArray(this.source, "shape");
        if (bounds.length < 4) {
            return new Rectangle(0, 0, 0, 0);
        }
        return new Rectangle(bounds[0], bounds[1], bounds[2], bounds[3]);
    }

    public void setBounds(Rectangle rec) {
        if (this instanceof Forward) {
            this.forwardBounds = rec;
        } else {
            Rectangle oldBounds = this.getBounds();
            this.updateSourceProperty("shape", new Point(rec.x, rec.y), new Dimension(rec.width, rec.height));
            this.propertyChangeSupport.firePropertyChange("shape", oldBounds, new Rectangle(rec.x, rec.y, rec.width, rec.height));
        }
    }

    public void setBounds(int x, int y, int w, int h) {
        this.setBounds(new Rectangle(x, y, w, h));
    }

    public void setSourceProperty(String name, Object value) {
    }

    public Object getSourceProperty(String name) {
        return this.source.getAttributeValue(name);
    }

    public Object getSourceProperty(int index) {
        return null;
    }

    public int getSourcePropertyCounter() {
        return 0;
    }

    public String[] getSourcePropertyNames() {
        XModelObject mobject = this.source;
        XAttribute[] attributes = mobject.getModelEntity().getAttributes();
        String[] attributeNames = new String[attributes.length];
        int i = 0;
        while (i < attributeNames.length) {
            attributeNames[i] = attributes[i].getName();
            ++i;
        }
        return attributeNames;
    }

    public String[] getSourcePropertyDisplayNames() {
        XModelObject mobject = this.source;
        XAttribute[] attributes = mobject.getModelEntity().getAttributes();
        String[] attributeNames = new String[attributes.length];
        int i = 0;
        while (i < attributeNames.length) {
            attributeNames[i] = attributes[i].getName();
            ++i;
        }
        return attributeNames;
    }

    public void remove() {
    }

    public void addVetoableChangeListener(VetoableChangeListener l) {
        this.vetoableChangeSupport.addVetoableChangeListener(l);
    }

    public void removeVetoableChangeListener(VetoableChangeListener l) {
        this.vetoableChangeSupport.removeVetoableChangeListener(l);
    }

    public void addVetoableChangeListener(String propertyName, VetoableChangeListener l) {
        this.vetoableChangeSupport.addVetoableChangeListener(propertyName, l);
    }

    public void removeVetoableChangeListener(String propertyName, VetoableChangeListener l) {
        this.vetoableChangeSupport.removeVetoableChangeListener(propertyName, l);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, l);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, l);
    }

    public Object clone() {
        StrutsElement newElement = new StrutsElement();
        newElement.source = this.source.copy();
        return newElement;
    }

    public Enumeration children() {
        return null;
    }

    public boolean isLeaf() {
        return true;
    }

    public void removeAllListeners() {
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    void updateSourceProperty(String name, Point position, Dimension size) {
        if (this.source != null) {
            this.strutsModel.getHelper().setAttributeValue(this.source, name, position.x + "," + position.y + "," + size.width + "," + size.height);
        }
    }

    public void structureChanged(Object eventData) {
    }

    public void nodeChanged(Object eventData) {
    }

    public void nodeAdded(Object eventData) {
    }

    public void nodeRemoved(Object eventData) {
    }

    public StrutsModel.StrutsHashtable getMap() {
        return ((StrutsModel)this.getStrutsModel()).getMap();
    }

    public void removeFromMap(Object key) {
        ((StrutsModel)this.getStrutsModel()).removeFromMap(key);
    }

    public IStrutsElement getFromMap(Object key) {
        return ((StrutsModel)this.getStrutsModel()).getFromMap(key);
    }

    public Menu getPopupMenu(Control control, Object environment) {
        if (this.getSource() == null) {
            return null;
        }
        if (((XModelObject)this.getSource()).getModelEntity().getActionList().getActionItems().length != 0) {
            XModelObjectActionList l = new XModelObjectActionList(((XModelObject)this.getSource()).getModelEntity().getActionList(), (XModelObject)this.getSource(), null, environment);
            Menu menu = l.createMenu(control);
            return menu;
        }
        return null;
    }

    public Menu getPopupMenu(Control control) {
        return this.getPopupMenu(control, null);
    }

    public boolean isConfirmed() {
        return false;
    }
}

