/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.ui.editor.model.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Vector;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.struts.ui.editor.model.IStrutsElement;
import org.jboss.tools.struts.ui.editor.model.IStrutsElementList;
import org.jboss.tools.struts.ui.editor.model.IStrutsElementListListener;
import org.jboss.tools.struts.ui.editor.model.impl.StrutsElement;
import org.jboss.tools.struts.ui.editor.model.impl.StrutsModel;

public class StrutsElementList
extends StrutsElement
implements IStrutsElementList,
VetoableChangeListener {
    Vector listeners = new Vector();
    Vector<IStrutsElement> elements = new Vector();
    boolean elementListListenerEnable = true;
    boolean allowDuplicate = false;

    public StrutsElementList() {
    }

    public Vector getElements() {
        return this.elements;
    }

    public StrutsElementList(IStrutsElement parent) {
        super(parent);
    }

    public StrutsElementList(IStrutsElement parent, XModelObject source) {
        super(parent, source);
    }

    public StrutsElementList(Vector vector) {
        this.elements = vector;
    }

    public void setAllowDuplicate(boolean set) {
        this.allowDuplicate = set;
    }

    public boolean isAllowDuplicate() {
        return this.allowDuplicate;
    }

    public void moveTo(IStrutsElement object, int index) {
        int currentIndex = this.indexOf(object);
        if (index < 0 || index >= this.size()) {
            return;
        }
        if (currentIndex > index) {
            int i = currentIndex - 1;
            while (i >= index) {
                IStrutsElement elementAt = this.get(i);
                this.set(i + 1, elementAt);
                --i;
            }
            this.set(index, object);
            this.fireElementMoved(object, index, currentIndex);
        } else if (currentIndex < index) {
            int i = currentIndex + 1;
            while (i <= index) {
                IStrutsElement elementAt = this.get(i);
                this.set(i - 1, elementAt);
                ++i;
            }
            this.set(index, object);
            this.fireElementMoved(object, index, currentIndex);
        }
    }

    public void moveUp(IStrutsElement object) {
        int currentIndex = this.indexOf(object);
        if (currentIndex == 0) {
            return;
        }
        this.set(currentIndex, this.get(currentIndex - 1));
        this.set(currentIndex - 1, object);
        this.fireElementMoved(object, currentIndex - 1, currentIndex);
    }

    public void moveDown(IStrutsElement object) {
        int currentIndex = this.indexOf(object);
        if (currentIndex == this.size()) {
            return;
        }
        this.set(currentIndex, this.get(currentIndex + 1));
        this.set(currentIndex + 1, object);
        this.fireElementMoved(object, currentIndex + 1, currentIndex);
    }

    public int size() {
        return this.elements.size();
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public boolean contains(Object o) {
        return this.elements.contains(o);
    }

    public Iterator iterator() {
        return this.elements.iterator();
    }

    public Object[] toArray() {
        return this.elements.toArray();
    }

    public Object[] toArray(Object[] a) {
        return this.elements.toArray(a);
    }

    public boolean add(IStrutsElement o) {
        boolean result = this.elements.add(o);
        if (result) {
            int index = this.elements.size() - 1;
            this.fireElementAdded(o, index);
        }
        return result;
    }

    public void add(IStrutsElementList list) {
        int i = 0;
        while (i < list.size()) {
            this.add(list.get(i));
            this.fireElementAdded(list.get(i), this.elements.size() - 1);
            ++i;
        }
    }

    public boolean remove(IStrutsElement o) {
        int index = this.indexOf(o);
        boolean result = this.elements.remove(o);
        this.fireElementRemoved(o, index);
        return result;
    }

    public void remove(Comparator comp) {
        int i = this.size() - 1;
        while (i >= 0) {
            if (comp.equals(this.get(i))) {
                this.remove(this.get(i));
            }
            --i;
        }
    }

    public void removeAll() {
        int i = this.size() - 1;
        while (i >= 0) {
            this.remove(this.get(i));
            --i;
        }
    }

    public IStrutsElement get(int index) {
        return this.elements.get(index);
    }

    public Object get(String name) {
        if (name == null) {
            return null;
        }
        int i = 0;
        while (i < this.elements.size()) {
            StrutsElement element = (StrutsElement)this.elements.get(i);
            if (name.equals(element.getPath())) {
                return element;
            }
            ++i;
        }
        return null;
    }

    public IStrutsElement set(int index, IStrutsElement element) {
        IStrutsElement newElement = this.elements.set(index, element);
        return newElement;
    }

    public void add(int index, IStrutsElement element) {
        this.elements.add(index, element);
        this.fireElementAdded(element, index);
    }

    public int indexOf(Object o) {
        return this.elements.indexOf(o);
    }

    public IStrutsElement findElement(Comparator comparator) {
        return null;
    }

    public IStrutsElementList findElements(Comparator comparator) {
        return null;
    }

    public String getText() {
        return this.toString();
    }

    public Object clone() {
        Vector newVector = (Vector)this.elements.clone();
        StrutsElementList clone = new StrutsElementList(newVector);
        return clone;
    }

    public StrutsElementList getClone() {
        StrutsElementList list = (StrutsElementList)this.clone();
        return list;
    }

    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
    }

    public void addStrutsElementListListener(IStrutsElementListListener l) {
        this.listeners.add(l);
    }

    public void removeStrutsElementListListener(IStrutsElementListListener l) {
        this.listeners.remove(l);
    }

    protected void fireElementMoved(IStrutsElement element, int newIndex, int oldIndex) {
        int i = 0;
        while (i < this.listeners.size()) {
            IStrutsElementListListener listener = (IStrutsElementListListener)this.listeners.get(i);
            if (listener != null && listener.isElementListListenerEnable()) {
                listener.listElementMove(this, element, newIndex, oldIndex);
            }
            ++i;
        }
        ((StrutsModel)this.getStrutsModel()).fireElementRemoved(element, oldIndex);
        ((StrutsModel)this.getStrutsModel()).fireElementInserted(element);
    }

    protected void fireElementAdded(IStrutsElement element, int index) {
        int i = 0;
        while (i < this.listeners.size()) {
            IStrutsElementListListener listener = (IStrutsElementListListener)this.listeners.get(i);
            if (listener != null && listener.isElementListListenerEnable()) {
                listener.listElementAdd(this, element, index);
            }
            ++i;
        }
    }

    protected void fireElementRemoved(IStrutsElement element, int index) {
        int i = 0;
        while (i < this.listeners.size()) {
            IStrutsElementListListener listener = (IStrutsElementListListener)this.listeners.get(i);
            if (listener != null && listener.isElementListListenerEnable()) {
                listener.listElementRemove(this, element, index);
            }
            ++i;
        }
    }

    protected void fireElementChanged(IStrutsElement element, int index, PropertyChangeEvent event) {
        int i = 0;
        while (i < this.listeners.size()) {
            IStrutsElementListListener listener = (IStrutsElementListListener)this.listeners.get(i);
            if (listener != null && listener.isElementListListenerEnable()) {
                listener.listElementChange(this, element, index, event);
            }
            ++i;
        }
    }

    public void remove(int index) {
        IStrutsElement obj = this.elements.get(index);
        this.elements.remove(obj);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }
}

