/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.ui.editor.model.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.event.XModelTreeEvent;
import org.jboss.tools.common.model.event.XModelTreeListener;
import org.jboss.tools.common.model.ui.action.XModelObjectActionList;
import org.jboss.tools.common.model.ui.util.ModelUtilities;
import org.jboss.tools.common.model.util.XModelTreeListenerSWTSync;
import org.jboss.tools.struts.StrutsPreference;
import org.jboss.tools.struts.model.helpers.StrutsProcessStructureHelper;
import org.jboss.tools.struts.ui.StrutsUIPlugin;
import org.jboss.tools.struts.ui.editor.model.IForward;
import org.jboss.tools.struts.ui.editor.model.IProcessItem;
import org.jboss.tools.struts.ui.editor.model.IStrutsElement;
import org.jboss.tools.struts.ui.editor.model.IStrutsElementList;
import org.jboss.tools.struts.ui.editor.model.IStrutsModel;
import org.jboss.tools.struts.ui.editor.model.IStrutsModelListener;
import org.jboss.tools.struts.ui.editor.model.IStrutsOptions;
import org.jboss.tools.struts.ui.editor.model.impl.Forward;
import org.jboss.tools.struts.ui.editor.model.impl.Link;
import org.jboss.tools.struts.ui.editor.model.impl.ProcessItem;
import org.jboss.tools.struts.ui.editor.model.impl.StrutsElement;
import org.jboss.tools.struts.ui.editor.model.impl.StrutsElementList;
import org.jboss.tools.struts.ui.preferences.WebFlowTabbedPreferencesPage;
import org.xml.sax.SAXException;

public class StrutsModel
extends StrutsElement
implements IStrutsModel,
PropertyChangeListener,
XModelTreeListener {
    protected Vector strutsModelListeners = new Vector();
    protected Vector errors = new Vector();
    protected StrutsHashtable map = new StrutsHashtable();
    protected StrutsElementList processItemList = new ProcessItemList();
    protected StrutsProcessStructureHelper helper = new StrutsProcessStructureHelper();
    protected StrutsOptions options;
    protected int splitPosition = 0;
    protected boolean modified = false;
    IProcessItem selectedProcessItem = null;
    XModelTreeListenerSWTSync listener = null;

    public StrutsModel() {
        try {
            this.setName("Struts Model");
        }
        catch (Exception ex) {
            StrutsUIPlugin.getPluginLog().logError((Throwable)ex);
        }
    }

    public boolean isBorderPaint() {
        return false;
    }

    public IStrutsOptions getOptions() {
        return this.options;
    }

    public StrutsModel(Object data) throws SAXException, Exception {
        this();
        this.setData(((XModelObject)data).getChildByPath("process"));
        this.map.setData((XModelObject)data);
    }

    public void updateLinks() {
        int i = 0;
        while (i < this.getProcessItemList().size()) {
            IProcessItem processItem = (IProcessItem)this.getProcessItemList().get(i);
            int j = 0;
            while (j < processItem.getForwardList().size()) {
                IForward forward = (IForward)processItem.getForwardList().get(j);
                if (forward.getLink() != null) {
                    forward.getLink().setTarget();
                }
                ++j;
            }
            ++i;
        }
    }

    public Object get(String name) {
        return null;
    }

    public void put(String name, Object value) {
    }

    public StrutsProcessStructureHelper getHelper() {
        return this.helper;
    }

    public int getProcessItemCounter() {
        return this.processItemList.size();
    }

    public IProcessItem getProcessItem(int index) {
        return (IProcessItem)this.processItemList.get(index);
    }

    public IProcessItem getProcessItem(String processItemName) {
        return (IProcessItem)this.processItemList.get(processItemName);
    }

    public IProcessItem getProcessItem(Object source) {
        IProcessItem[] is = this.processItemList.elements.toArray(new IProcessItem[0]);
        int i = 0;
        while (i < is.length) {
            if (is[i].getSource() == source) {
                return is[i];
            }
            ++i;
        }
        return null;
    }

    public void removeProcessItem(String moduleName) {
    }

    public void removeProcessItem(IProcessItem removeProcessItem) {
    }

    public void propertyChange(PropertyChangeEvent pce) {
    }

    public void setSelectedProcessItem(IProcessItem processItem) {
        IProcessItem oldValue = this.selectedProcessItem;
        this.selectedProcessItem = processItem;
        this.propertyChangeSupport.firePropertyChange("selectedProcessItem", oldValue, processItem);
    }

    public IProcessItem getSelectedProcessItem() {
        return this.selectedProcessItem;
    }

    public String getText() {
        return "";
    }

    public void setData(Object data) throws Exception {
        this.source = (XModelObject)data;
        if (this.source == null) {
            return;
        }
        this.helper.autolayout(this.source);
        this.map.put(this.source.getPath(), this);
        this.processItemList = new ProcessItemList(this.source);
        this.listener = new XModelTreeListenerSWTSync((XModelTreeListener)this);
        this.source.getModel().addModelTreeListener((XModelTreeListener)this.listener);
        this.options = new StrutsOptions();
    }

    public void disconnectFromModel() {
        if (this.listener != null) {
            this.source.getModel().removeModelTreeListener((XModelTreeListener)this.listener);
        }
        this.options.disconnectFromModel();
        this.map.disconnectFromModel();
    }

    public boolean isEditable() {
        return this.source != null && this.source.getModelEntity().isEditable(this.source, "body");
    }

    public boolean areCommentsVisible() {
        if (this.source == null) {
            return false;
        }
        return !this.helper.areProcessCommentsHidden(this.source);
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean set) {
        boolean oldValue = this.modified;
        this.modified = set;
        this.propertyChangeSupport.firePropertyChange("modified", oldValue, this.modified);
    }

    public void fireProcessChanged(boolean flag) {
        Vector targets = (Vector)this.strutsModelListeners.clone();
        int i = 0;
        while (i < targets.size()) {
            IStrutsModelListener listener = (IStrutsModelListener)targets.get(i);
            if (listener != null) {
                listener.processChanged(flag);
            }
            ++i;
        }
        this.setModified(true);
    }

    public void fireProcessItemAdd(IProcessItem newProcessItem) {
        Vector targets = (Vector)this.strutsModelListeners.clone();
        int i = 0;
        while (i < targets.size()) {
            IStrutsModelListener listener = (IStrutsModelListener)targets.get(i);
            if (listener != null) {
                listener.processItemAdd(newProcessItem);
            }
            ++i;
        }
        this.setModified(true);
    }

    public void fireProcessItemRemove(IProcessItem newProcessItem, int index) {
        Vector targets = (Vector)this.strutsModelListeners.clone();
        int i = 0;
        while (i < targets.size()) {
            IStrutsModelListener listener = (IStrutsModelListener)targets.get(i);
            if (listener != null) {
                listener.processItemRemove(newProcessItem);
            }
            ++i;
        }
        this.setModified(true);
    }

    public void fireElementRemoved(IStrutsElement element, int index) {
    }

    public void fireElementInserted(IStrutsElement element) {
    }

    public void addStrutsModelListener(IStrutsModelListener listener) {
        this.strutsModelListeners.add(listener);
    }

    public void removeStrutsModelListener(IStrutsModelListener listener) {
        this.strutsModelListeners.remove(listener);
    }

    public void remove() {
    }

    public String getIconPath() {
        return null;
    }

    public void setStartProcessItemName(String module) {
    }

    public IProcessItem addProcessItem(IProcessItem processItem) {
        return null;
    }

    public IProcessItem addProcessItem(String processItemName) {
        return null;
    }

    public IProcessItem addProcessItem(Object source, int x, int y) {
        return null;
    }

    public IProcessItem addProcessItem(IStrutsElement element) {
        return null;
    }

    public IStrutsElementList getProcessItemList() {
        return this.processItemList;
    }

    public void nodeChanged(XModelTreeEvent event) {
        if (this.source != null && this.helper.isNodeChangeListenerLocked(this.source)) {
            return;
        }
        try {
            String path;
            this.fireProcessChanged(false);
            StrutsElement element = (StrutsElement)this.map.get(event.getInfo());
            if (element != null && !event.getModelObject().getPath().equals(event.getInfo())) {
                this.updateCash((String)event.getInfo());
            }
            IStrutsElement iStrutsElement = element = (path = event.getModelObject().getPath()) == null ? null : this.map.get(path);
            if (element == null) {
                return;
            }
            element.nodeChanged(event);
        }
        catch (Exception e) {
            StrutsUIPlugin.getPluginLog().logError("Error while processing model event", (Throwable)e);
        }
    }

    public void structureChanged(XModelTreeEvent event) {
        try {
            String obj = event.getModelObject().getPath();
            if (obj == null) {
                return;
            }
            StrutsElement element = (StrutsElement)this.map.get(obj);
            if (element == null) {
                return;
            }
            if (event.kind() == 3) {
                if (obj.equals(this.source.getPath())) {
                    int i = 0;
                    while (i < this.map.map.size()) {
                        element = (StrutsElement)this.map.map.values().toArray()[i];
                        element.nodeChanged(event);
                        ++i;
                    }
                    this.fireProcessChanged(true);
                }
                element.structureChanged(event);
            } else if (event.kind() == 1) {
                element.nodeAdded(event);
            } else if (event.kind() == 2) {
                element.nodeRemoved(event);
            }
        }
        catch (Exception exc) {
            StrutsUIPlugin.getPluginLog().logError("Error while processing model event", (Throwable)exc);
        }
    }

    public void putToMap(Object key, Object value) {
        this.getMap().put(key, value);
    }

    public void removeFromMap(Object key) {
        this.getMap().remove(key);
    }

    public IStrutsElement getFromMap(Object key) {
        return this.getMap().get(key);
    }

    public StrutsHashtable getMap() {
        return this.map;
    }

    public IStrutsElement findElement(String key) {
        return this.map.get(key);
    }

    protected void clearCash(String path) {
        this.updateCash(path, true);
    }

    protected void updateCash(String path) {
        this.updateCash(path, false);
    }

    protected void updateCash(String path, boolean clear) {
        String rpath = String.valueOf(path) + "/";
        Object[] ks = this.map.map.keySet().toArray();
        int i = 0;
        while (i < ks.length) {
            if (ks[i].equals(path) || ks[i].toString().startsWith(rpath)) {
                IStrutsElement n = (IStrutsElement)this.map.map.get(ks[i]);
                this.map.map.remove(ks[i]);
                if (!clear) {
                    XModelObject o = (XModelObject)n.getSource();
                    this.map.map.put(o.getPath(), n);
                }
            }
            ++i;
        }
    }

    public Menu getPopupMenu(Control control, Object environment) {
        if (this.source == null) {
            return null;
        }
        if (this.source.getModelEntity().getActionList().getActionItems().length != 0) {
            XModelObjectActionList l = new XModelObjectActionList(this.source.getModelEntity().getActionList(), this.source, null, environment);
            Menu menu = l.createMenu(control);
            return menu;
        }
        return null;
    }

    public Menu getPopupMenu(Control control) {
        return this.getPopupMenu(control, null);
    }

    public boolean isConfirmed() {
        return true;
    }

    public class ProcessItemList
    extends StrutsElementList {
        protected ProcessItemList() {
        }

        public ProcessItemList(XModelObject processItemSource) {
            super(StrutsModel.this, StrutsModel.this.source);
            if (((XModelObject)StrutsModel.this.getSource()).getPath() == null) {
                return;
            }
            XModelObject[] processItemNodeList = StrutsModel.this.helper.getProcessItems(StrutsModel.this.source);
            int i = 0;
            while (i < processItemNodeList.length) {
                ProcessItem newProcessItem = new ProcessItem((IStrutsModel)StrutsModel.this, processItemNodeList[i]);
                newProcessItem.addPropertyChangeListener("selected", new ProcessItemPropertyChangeListener());
                this.add(newProcessItem);
                ++i;
            }
        }

        public void structureChanged(Object eventData) {
        }

        public void nodeAdded(Object eventData) {
            XModelTreeEvent event = (XModelTreeEvent)eventData;
            ProcessItem newProcessItem = new ProcessItem((IStrutsModel)StrutsModel.this, (XModelObject)event.getInfo());
            this.add(newProcessItem);
            StrutsModel.this.fireProcessItemAdd(newProcessItem);
        }

        public void nodeRemoved(Object eventData) {
            XModelTreeEvent event = (XModelTreeEvent)eventData;
            IStrutsElement removedProcessItem = this.getFromMap(event.getInfo());
            int index = this.indexOf(removedProcessItem);
            removedProcessItem.remove();
            this.remove(removedProcessItem);
            this.removeFromMap(((XModelTreeEvent)eventData).getInfo());
            StrutsModel.this.fireProcessItemRemove((ProcessItem)removedProcessItem, index);
            StrutsModel.this.clearCash((String)event.getInfo());
        }
    }

    public class ProcessItemPropertyChangeListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent event) {
            IProcessItem processItem = (IProcessItem)event.getSource();
            if (event.getPropertyName().equals("selected") && ((Boolean)event.getNewValue()).booleanValue()) {
                StrutsModel.this.setSelectedProcessItem(processItem);
            }
        }
    }

    public class StrutsHashtable
    implements XModelTreeListener {
        Hashtable map = new Hashtable();
        XModelObject source;
        String name;

        public void setData(XModelObject data) {
            this.source = data;
            this.source.getModel().addModelTreeListener((XModelTreeListener)this);
            this.name = this.source.getAttributeValue("name");
        }

        public void disconnectFromModel() {
            this.source.getModel().removeModelTreeListener((XModelTreeListener)this);
        }

        public void put(Object key, Object value) {
            this.map.put(key, value);
        }

        public IStrutsElement get(Object key) {
            return (IStrutsElement)this.map.get(key);
        }

        public void remove(Object key) {
            this.map.remove(key);
        }

        public void nodeChanged(XModelTreeEvent event) {
            if (!this.source.getAttributeValue("name").equals(this.name)) {
                this.name = this.source.getAttributeValue("name");
                Enumeration keys = this.map.keys();
                while (keys.hasMoreElements()) {
                    String path = (String)keys.nextElement();
                    StrutsElement element = (StrutsElement)this.map.get(path);
                    if (element == null || element.getSource() == null) continue;
                    this.map.remove(path);
                    this.map.put(((XModelObject)element.getSource()).getPath(), element);
                }
            }
        }

        public void structureChanged(XModelTreeEvent event) {
        }
    }

    class StrutsOptions
    implements XModelTreeListener,
    IStrutsOptions {
        XModelObject optionsObject = ModelUtilities.getPreferenceModel().getByPath(WebFlowTabbedPreferencesPage.STRUTS_EDITOR_PATH);
        XModelTreeListenerSWTSync optionsListener = new XModelTreeListenerSWTSync((XModelTreeListener)this);
        Font actionFont = null;
        Font forwardFont = null;
        Font pathFont = null;
        Font commentFont = null;

        public StrutsOptions() {
            this.optionsObject.getModel().addModelTreeListener((XModelTreeListener)this.optionsListener);
        }

        public boolean isGridVisible() {
            String str = this.optionsObject.getAttributeValue("Show Grid");
            return str.equals("yes");
        }

        public int getGridStep() {
            String str = this.optionsObject.getAttributeValue("Grid Step");
            return Integer.parseInt(str);
        }

        public Font getActionFont() {
            String name;
            int size = 8;
            int style = 1;
            String str = this.optionsObject.getAttributeValue("Action Font");
            int pos = str.indexOf(",");
            if (pos < 0) {
                name = str;
            } else {
                int pos3;
                name = str.substring(0, pos);
                int pos2 = str.indexOf("size=");
                if (pos2 >= 0) {
                    pos3 = str.indexOf(",", pos2);
                    size = pos3 < 0 ? Integer.parseInt(str.substring(pos2 + 5, str.length())) : Integer.parseInt(str.substring(pos2 + 5, pos3));
                }
                if ((pos2 = str.indexOf("style=")) >= 0) {
                    pos3 = str.indexOf(",", pos2);
                    style = pos3 < 0 ? Integer.parseInt(str.substring(pos2 + 6, str.length())) : Integer.parseInt(str.substring(pos2 + 6, pos3));
                }
            }
            if (this.actionFont == null) {
                this.actionFont = new Font(null, name, size, style);
            } else if (!this.actionFont.getFontData()[0].getName().equals(name) || this.actionFont.getFontData()[0].getHeight() != size || this.actionFont.getFontData()[0].getStyle() != style) {
                this.actionFont = new Font(null, name, size, style);
            }
            return this.actionFont;
        }

        public Font getForwardFont() {
            String name;
            int size = 8;
            int style = 1;
            String str = this.optionsObject.getAttributeValue("Forward Font");
            int pos = str.indexOf(",");
            if (pos < 0) {
                name = str;
            } else {
                int pos3;
                name = str.substring(0, pos);
                int pos2 = str.indexOf("size=");
                if (pos2 >= 0) {
                    pos3 = str.indexOf(",", pos2);
                    size = pos3 < 0 ? Integer.parseInt(str.substring(pos2 + 5, str.length())) : Integer.parseInt(str.substring(pos2 + 5, pos3));
                }
                if ((pos2 = str.indexOf("style=")) >= 0) {
                    pos3 = str.indexOf(",", pos2);
                    style = pos3 < 0 ? Integer.parseInt(str.substring(pos2 + 6, str.length())) : Integer.parseInt(str.substring(pos2 + 6, pos3));
                }
            }
            if (this.forwardFont == null) {
                this.forwardFont = new Font(null, name, size, style);
            } else if (!this.forwardFont.getFontData()[0].getName().equals(name) || this.forwardFont.getFontData()[0].getHeight() != size || this.forwardFont.getFontData()[0].getStyle() != style) {
                this.forwardFont = new Font(null, name, size, style);
            }
            return this.forwardFont;
        }

        public Font getPathFont() {
            String name;
            int size = 8;
            int style = 1;
            String str = this.optionsObject.getAttributeValue("Path Font");
            int pos = str.indexOf(",");
            if (pos < 0) {
                name = str;
            } else {
                int pos3;
                name = str.substring(0, pos);
                int pos2 = str.indexOf("size=");
                if (pos2 >= 0) {
                    pos3 = str.indexOf(",", pos2);
                    size = pos3 < 0 ? Integer.parseInt(str.substring(pos2 + 5, str.length())) : Integer.parseInt(str.substring(pos2 + 5, pos3));
                }
                if ((pos2 = str.indexOf("style=")) >= 0) {
                    pos3 = str.indexOf(",", pos2);
                    style = pos3 < 0 ? Integer.parseInt(str.substring(pos2 + 6, str.length())) : Integer.parseInt(str.substring(pos2 + 6, pos3));
                }
            }
            if (this.pathFont == null) {
                this.pathFont = new Font(null, name, size, style);
            } else if (!this.pathFont.getFontData()[0].getName().equals(name) || this.pathFont.getFontData()[0].getHeight() != size || this.pathFont.getFontData()[0].getStyle() != style) {
                this.pathFont = new Font(null, name, size, style);
            }
            return this.pathFont;
        }

        public Font getCommentFont() {
            String name;
            int size = 8;
            int style = 1;
            String str = this.optionsObject.getAttributeValue("Comment Font");
            int pos = str.indexOf(",");
            if (pos < 0) {
                name = str;
            } else {
                int pos3;
                name = str.substring(0, pos);
                int pos2 = str.indexOf("size=");
                if (pos2 >= 0) {
                    pos3 = str.indexOf(",", pos2);
                    size = pos3 < 0 ? Integer.parseInt(str.substring(pos2 + 5, str.length())) : Integer.parseInt(str.substring(pos2 + 5, pos3));
                }
                if ((pos2 = str.indexOf("style=")) >= 0) {
                    pos3 = str.indexOf(",", pos2);
                    style = pos3 < 0 ? Integer.parseInt(str.substring(pos2 + 6, str.length())) : Integer.parseInt(str.substring(pos2 + 6, pos3));
                }
            }
            if (this.commentFont == null) {
                this.commentFont = new Font(null, name, size, style);
            } else if (!this.commentFont.getFontData()[0].getName().equals(name) || this.commentFont.getFontData()[0].getHeight() != size || this.commentFont.getFontData()[0].getStyle() != style) {
                this.commentFont = new Font(null, name, size, style);
            }
            return this.commentFont;
        }

        public boolean switchToSelectionTool() {
            String str = StrutsPreference.ENABLE_CONTROL_MODE_ON_TRANSITION_COMPLETED.getValue();
            return str != null && str.equals("yes");
        }

        public boolean showShortcutIcon() {
            String str = StrutsPreference.SHOW_SHORTCUT_ICON.getValue();
            return str != null && str.equals("yes");
        }

        public boolean showShortcutPath() {
            String str = StrutsPreference.SHOW_SHORTCUT_PATH.getValue();
            return str != null && str.equals("yes");
        }

        public void disconnectFromModel() {
            this.optionsObject.getModel().removeModelTreeListener((XModelTreeListener)this.optionsListener);
        }

        public void nodeChanged(XModelTreeEvent event) {
            StrutsModel.this.fireProcessChanged(false);
            int i = 0;
            while (i < StrutsModel.this.getProcessItemList().size()) {
                ProcessItem item = (ProcessItem)StrutsModel.this.getProcessItemList().get(i);
                item.fireProcessItemChange();
                int j = 0;
                while (j < item.getForwardList().size()) {
                    Forward forward = (Forward)item.getForwardList().get(j);
                    forward.fireForwardChanged();
                    if (forward.getLink() != null) {
                        ((Link)forward.getLink()).fireLinkChange();
                    }
                    ++j;
                }
                ++i;
            }
        }

        public void structureChanged(XModelTreeEvent event) {
        }
    }
}

