/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.ui.editor.print;

import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.jboss.tools.struts.ui.editor.figures.ProcessItemFigure;
import org.jboss.tools.struts.ui.editor.print.Pages;

public class PagesView
extends Composite
implements MouseListener,
PaintListener {
    double viewScale = 0.25;
    int pageCount = 0;
    boolean selectionEnabled = false;
    Dimension containerSize;
    Pages pages;
    int pW = 0;
    int pH = 0;
    int zeroX = 100;
    int zeroY = 0;
    GraphicalViewer viewer;
    boolean recount = true;
    Vector figures = new Vector();

    public PagesView(Pages p, Dimension viewSize, Composite parent, int style) {
        super(parent, style);
        if (p.isTextPrint()) {
            this.containerSize = viewSize;
            this.pages = p;
        } else {
            this.containerSize = viewSize;
            this.pages = p;
            this.viewer = p.getViewer();
            this.addMouseListener(this);
            this.viewScale = this.calculateScale(this.containerSize, this.pages.getDimension());
            PropertyChangeListener pcl = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("scale")) {
                        PagesView.this.setViewScale(PagesView.this.calculateScale(PagesView.this.containerSize, PagesView.this.pages.getDimension()));
                        if (PagesView.this.pageCount != PagesView.this.pages.getSourcePagesCount()) {
                            PagesView.this.recount = true;
                            PagesView.this.pageCount = PagesView.this.pages.getSourcePagesCount();
                        } else {
                            PagesView.this.recount = false;
                        }
                        PagesView.this.redraw();
                    }
                }
            };
            this.pages.addPropertyChangeListener(pcl);
            this.addPaintListener(this);
            this.pageCount = this.pages.getSourcePagesCount();
        }
    }

    public double calculateScale(Dimension panelSize, Dimension componentSize) {
        double sX = 1.0;
        double sY = 1.0;
        double s = 1.0;
        sX = panelSize.width > componentSize.width ? 1.0 : (double)panelSize.width / (double)componentSize.width;
        sY = panelSize.height > componentSize.height ? 1.0 : (double)panelSize.height / (double)componentSize.height;
        s = sX < sY ? sX : sY;
        return s;
    }

    public void getChilds(IFigure f) {
        for (IFigure o : f.getChildren()) {
            this.figures.add(o);
            this.getChilds(o);
        }
    }

    public int getTrueHeight(Label label, double vScale) {
        String s = label.getText();
        Font ff = label.getFont();
        FontData fd = ff.getFontData()[0];
        int h = fd.getHeight();
        int nh = (int)((double)h * vScale);
        if (nh > 0) {
            fd.setHeight(nh);
            Font f2 = new Font(null, fd);
            int dmm = FigureUtilities.getTextWidth((String)s, (Font)f2);
            int labW = (int)((double)label.getBounds().width * vScale);
            while (labW > dmm) {
                fd.setHeight(++nh);
                Font f3 = new Font(null, fd);
                dmm = FigureUtilities.getTextWidth((String)s, (Font)f3);
                f3.dispose();
            }
            f2.dispose();
            return nh;
        }
        return 0;
    }

    public void paintControl(PaintEvent pe) {
        Point p;
        IFigure f1;
        GC g2 = pe.gc;
        Color white = new Color((Device)pe.display, 255, 255, 255);
        Color black = new Color((Device)pe.display, 0, 0, 0);
        Color gray = pe.display.getSystemColor(15);
        Color yellowColor = new Color(null, 255, 246, 203);
        Color lightGrayColor = new Color(null, 241, 241, 241);
        int xmax = 0;
        int ymax = 0;
        int cx = 0;
        int cy = 0;
        int i = 0;
        while (i < this.pages.getSourcePagesCount()) {
            Rectangle nrz = new Rectangle((int)Math.round((double)this.pages.getSourcePage((int)i).getRectangle().x * this.viewScale), (int)Math.round((double)this.pages.getSourcePage((int)i).getRectangle().y * this.viewScale), (int)Math.round((double)this.pages.getSourcePage((int)i).getRectangle().width * this.viewScale), (int)Math.round((double)this.pages.getSourcePage((int)i).getRectangle().height * this.viewScale));
            if (nrz.y + nrz.height > ymax) {
                ymax = nrz.y + nrz.height;
                if (this.recount) {
                    this.pH = nrz.height;
                }
                ++cy;
            }
            if (nrz.x + nrz.width > xmax) {
                xmax = nrz.x + nrz.width;
                if (this.recount) {
                    this.pW = nrz.width;
                }
                ++cx;
            }
            ++i;
        }
        this.recount = false;
        ymax = cy * this.pH;
        xmax = cx * this.pW;
        this.zeroX = (this.containerSize.width - xmax) / 2;
        this.zeroY = (this.containerSize.height - ymax) / 2;
        LayerManager lm = (LayerManager)this.viewer.getEditPartRegistry().get(LayerManager.ID);
        IFigure f = lm.getLayer((Object)"Printable Layers");
        if (this.figures.isEmpty()) {
            this.getChilds(f);
        }
        int ix = 0;
        int iy = 0;
        int i2 = 0;
        while (i2 < this.figures.size()) {
            f1 = (IFigure)this.figures.get(i2);
            if (f1.getBounds().x < 0 && f1.getBounds().x < ix) {
                ix = f1.getBounds().x;
            }
            if (f1.getBounds().y < 0 && f1.getBounds().y < iy) {
                iy = f1.getBounds().y;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.figures.size()) {
            f1 = (IFigure)this.figures.get(i2);
            Rectangle r = new Rectangle(f1.getBounds().x + Math.abs(ix), f1.getBounds().y + Math.abs(iy), f1.getBounds().width, f1.getBounds().height);
            Rectangle rs = new Rectangle((int)((double)r.x * this.viewScale) + this.zeroX, (int)((double)r.y * this.viewScale) + this.zeroY, (int)((double)r.width * this.viewScale), (int)((double)r.height * this.viewScale));
            if (f1 instanceof PolylineConnection) {
                PolylineConnection plc = (PolylineConnection)f1;
                PointList pl = plc.getPoints();
                int j = 0;
                while (j < pl.size() - 1) {
                    p = new Point(pl.getPoint((int)j).x + Math.abs(ix), pl.getPoint((int)j).y + Math.abs(iy));
                    Point p1 = new Point(pl.getPoint((int)(j + 1)).x + Math.abs(ix), pl.getPoint((int)(j + 1)).y + Math.abs(iy));
                    g2.setBackground(white);
                    g2.setForeground(gray);
                    g2.setLineStyle(1);
                    g2.drawLine((int)((double)p.x * this.viewScale) + this.zeroX, (int)((double)p.y * this.viewScale) + this.zeroY, (int)((double)p1.x * this.viewScale) + this.zeroX, (int)((double)p1.y * this.viewScale) + this.zeroY);
                    ++j;
                }
            } else if (f1 instanceof ProcessItemFigure) {
                ProcessItemFigure group = (ProcessItemFigure)f1;
                g2.setForeground(black);
                if (group.processItem.isConfirmed()) {
                    g2.setBackground(yellowColor);
                } else {
                    g2.setBackground(lightGrayColor);
                }
                g2.fillRectangle(rs.x, rs.y, rs.width, rs.height);
                g2.drawRectangle(rs.x, rs.y, rs.width, rs.height);
            } else if (f1 instanceof Label) {
                String s = ((Label)f1).getText();
                Font ff = f1.getFont();
                FontData fd = ff.getFontData()[0];
                int nn = this.getTrueHeight((Label)f1, this.viewScale);
                if (nn > 0) {
                    fd.setHeight(nn);
                    Font f2 = new Font((Device)pe.display, fd);
                    g2.setFont(f2);
                    g2.setBackground(white);
                    g2.drawString(s, rs.x, rs.y);
                    f2.dispose();
                }
            }
            ++i2;
        }
        g2.setBackground(black);
        g2.setForeground(black);
        g2.setLineStyle(3);
        g2.drawLine(xmax + this.zeroX, this.zeroY, xmax + this.zeroX, ymax + this.zeroY);
        g2.drawLine(this.zeroX, ymax + this.zeroY, xmax + this.zeroX, ymax + this.zeroY);
        int tmp = ymax;
        Vector<Integer> xx = new Vector<Integer>();
        Vector<Integer> yy = new Vector<Integer>();
        while (tmp > 0) {
            g2.drawLine(this.zeroX, tmp - this.pH + this.zeroY, xmax + this.zeroX, tmp - this.pH + this.zeroY);
            yy.add(tmp -= this.pH);
        }
        tmp = xmax;
        while (tmp > 0) {
            g2.drawLine(tmp - this.pW + this.zeroX, this.zeroY, tmp - this.pW + this.zeroX, ymax + this.zeroY);
            xx.add(tmp -= this.pW);
        }
        Vector<Rectangle> rec = new Vector<Rectangle>();
        int i3 = 0;
        while (i3 < yy.size()) {
            int j = 0;
            while (j < xx.size()) {
                rec.add(new Rectangle((Integer)xx.get(j) + this.zeroX, (Integer)yy.get(i3) + this.zeroY, this.pW, this.pH));
                ++j;
            }
            ++i3;
        }
        Object[] rn = rec.toArray();
        int i4 = 0;
        while (i4 < this.pages.getSourcePagesCount()) {
            if (!this.pages.getSourcePage(i4).isSelected()) {
                Rectangle sr = this.pages.getSourcePage(i4).getRectangle();
                p = new Point((int)Math.round((double)sr.x * this.viewScale + (double)(this.pW / 2) + (double)this.zeroX), (int)Math.round((double)sr.y * this.viewScale + (double)(this.pH / 2) + (double)this.zeroY));
                int j = 0;
                while (j < rn.length) {
                    Rectangle rnt = (Rectangle)rn[j];
                    if (rnt.contains(p)) {
                        g2.setXORMode(true);
                        g2.setBackground(pe.display.getSystemColor(16));
                        Rectangle nr = new Rectangle(rnt.x, rnt.y, this.pW + 1, this.pH + 1);
                        g2.fillRectangle(nr);
                        g2.setXORMode(false);
                    }
                    ++j;
                }
            }
            ++i4;
        }
        g2.dispose();
        pe.gc.dispose();
    }

    public void setViewScale(double viewScale) {
        this.viewScale = viewScale;
    }

    public double getViewScale() {
        return this.viewScale;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        return new Dimension((int)((double)this.pages.getDimension().width * this.viewScale), (int)((double)this.pages.getDimension().height * this.viewScale));
    }

    public Point getSize() {
        return new Point(this.getPreferredSize().width, this.getPreferredSize().height);
    }

    public int getWidth() {
        return this.getPreferredSize().width;
    }

    public int getHeight() {
        return this.getPreferredSize().height;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.getLocation().x, this.getLocation().y, this.getPreferredSize().width, this.getPreferredSize().height);
    }

    public void setSelectionEnabled(boolean value) {
        this.selectionEnabled = value;
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        if (this.selectionEnabled) {
            Point p = new Point(e.x, e.y);
            int i = 0;
            while (i < this.pages.getSourcePagesCount()) {
                Rectangle nr = new Rectangle((int)((double)this.pages.getSourcePage((int)i).getRectangle().x * this.viewScale) + this.zeroX, (int)((double)this.pages.getSourcePage((int)i).getRectangle().y * this.viewScale) + this.zeroY, (int)((double)this.pages.getSourcePage((int)i).getRectangle().width * this.viewScale), (int)((double)this.pages.getSourcePage((int)i).getRectangle().height * this.viewScale));
                if (nr.contains(p)) {
                    this.pages.getSourcePage(i).setSelected(!this.pages.getSourcePage(i).isSelected());
                    this.redraw();
                }
                ++i;
            }
        }
    }

    public void mouseUp(MouseEvent e) {
    }
}

