/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.ui.navigator;

import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.event.XModelTreeEvent;
import org.jboss.tools.common.model.impl.XModelImpl;
import org.jboss.tools.common.model.ui.navigator.TreeViewerModelListenerImpl;
import org.jboss.tools.jst.web.model.pv.WebProjectNode;
import org.jboss.tools.struts.model.pv.StrutsProjectTagLibs;
import org.jboss.tools.struts.model.pv.StrutsProjectsRoot;

public class StrutsProjectsTreeListener
extends TreeViewerModelListenerImpl {
    public void nodeChanged(XModelTreeEvent event) {
        WebProjectNode n;
        XModelObject source = event.getModelObject();
        StrutsProjectsRoot root = (StrutsProjectsRoot)this.getProjectRoot(source.getModel());
        if (root == null) {
            return;
        }
        if (!root.isLoaded()) {
            if (source.getFileType() != 0) {
                super.updateNode((XModelObject)root);
            }
            return;
        }
        String entity = source.getModelEntity().getName();
        if (entity.startsWith("FileWebApp") || entity.startsWith("JstWeb")) {
            n = this.getProjectRoot(source.getModel());
            if (n != null) {
                n.invalidate();
            }
        } else if (entity.equals("StrutsConfig11") || entity.equals("StrutsConfig12")) {
            this.invalidateValidators(source.getModel());
            super.nodeChanged(event);
        } else if (entity.equals("StrutsPluginSetProperty11")) {
            this.invalidateValidators(source.getModel());
            this.invalidateTiles(source.getModel());
            super.nodeChanged(event);
        } else if (entity.equals("FileTiles")) {
            this.invalidateTiles(source.getModel());
            super.nodeChanged(event);
        } else {
            super.nodeChanged(event);
        }
        if (!(source instanceof WebProjectNode)) {
            n = this.getProjectRoot(source.getModel());
            if (n == null) {
                return;
            }
            XModelObject p = n.getTreeParent(source);
            if (p instanceof WebProjectNode) {
                ((XModelImpl)p.getModel()).fireNodeChanged(p, p.getPath());
            }
        }
    }

    protected WebProjectNode getProjectRoot(XModel model) {
        return (WebProjectNode)model.getByPath("root:StrutsProjects");
    }

    public void structureChanged(XModelTreeEvent event) {
        if (this.viewer.getControl() == null || this.viewer.getControl().isDisposed()) {
            return;
        }
        XModelObject source = event.getModelObject();
        StrutsProjectsRoot root = (StrutsProjectsRoot)this.getProjectRoot(source.getModel());
        if (root == null || !root.isLoaded()) {
            return;
        }
        if (event.kind() == 1) {
            XModelObject c = (XModelObject)event.getInfo();
            String entity = c.getModelEntity().getName();
            if ("FilePROPERTIES".equals(entity)) {
                this.invalidateBundles(source.getModel());
            } else if (StrutsProjectTagLibs.isTLDFile((XModelObject)c)) {
                this.invalidateTagLibs(source.getModel());
            } else if (entity.startsWith("StrutsConfig")) {
                this.invalidateConfig(source.getModel());
            } else if ("FileTiles".equals(entity)) {
                this.invalidateTiles(source.getModel());
            } else if (entity.startsWith("FileValidationRules")) {
                this.invalidateValidators(source.getModel());
            } else if (entity.startsWith("StrutsPlugin")) {
                this.invalidateValidators(source.getModel());
                this.invalidateTiles(source.getModel());
            } else if ("FileFolder".equals(entity)) {
                WebProjectNode n = this.getProjectRoot(source.getModel());
                if (n != null) {
                    n.invalidate();
                }
            } else {
                String s_entity = source.getModelEntity().getName();
                if (s_entity.startsWith("StrutsPlugin")) {
                    this.invalidateTiles(source.getModel());
                } else if (s_entity.startsWith("JstWeb")) {
                    this.invalidateConfig(source.getModel());
                }
            }
        } else if (event.kind() == 2) {
            if (source.getFileType() > 1) {
                WebProjectNode n = this.getProjectRoot(source.getModel());
                if (n != null) {
                    n.invalidate();
                }
                return;
            }
            if (source.getFileType() == 1) {
                String entity = source.getModelEntity().getName();
                if (entity.startsWith("FileWebApp")) {
                    this.invalidateConfig(source.getModel());
                }
            } else {
                String entity = source.getModelEntity().getName();
                if (entity.startsWith("StrutsPlugin")) {
                    this.invalidateTiles(source.getModel());
                } else if (entity.startsWith("JstWeb")) {
                    this.invalidateConfig(source.getModel());
                }
            }
        }
        super.structureChanged(event);
    }

    private void invalidateBundles(XModel model) {
        this.invalidateFolder(model, "Resource Bundles");
    }

    private void invalidateTagLibs(XModel model) {
        this.invalidateFolder(model, "Tag Libraries");
    }

    private void invalidateConfig(XModel model) {
        this.invalidateFolder(model, "Configuration");
    }

    private void invalidateValidators(XModel model) {
        this.invalidateFolder(model, "Validation");
    }

    private void invalidateTiles(XModel model) {
        this.invalidateFolder(model, "Tiles");
    }

    private void invalidateFolder(XModel model, String name) {
        WebProjectNode n = this.getProjectRoot(model);
        if (n == null) {
            return;
        }
        WebProjectNode b = (WebProjectNode)n.getChildByPath(name);
        b.invalidate();
    }
}

