/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.ui.operation;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.jboss.tools.common.model.filesystems.impl.FileSystemImpl;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.jst.web.WebUtils;
import org.jboss.tools.jst.web.context.RegisterServerContext;
import org.jboss.tools.jst.web.project.helpers.IWebProjectTemplate;
import org.jboss.tools.jst.web.project.helpers.NewWebProjectContext;
import org.jboss.tools.jst.web.ui.operation.WebProjectCreationOperation;
import org.jboss.tools.struts.StrutsUtils;

public class StrutsProjectCreationOperation
extends WebProjectCreationOperation {
    public StrutsProjectCreationOperation(IProject project, IPath projectLocation, RegisterServerContext registry, Properties properties) {
        super(project, projectLocation, registry, properties);
        this.setProperty("WebNatureOperation.TLDS_ID", properties.getProperty("TLDs"));
    }

    public StrutsProjectCreationOperation(NewWebProjectContext context) {
        super(context);
        this.setProperty("WebNatureOperation.TLDS_ID", context.getActionProperties().getProperty("TLDs"));
    }

    protected IWebProjectTemplate createTemplate() {
        return new StrutsUtils();
    }

    protected String getNatureID() {
        return "org.jboss.tools.struts.strutsnature";
    }

    protected String getLibLocation() {
        FileSystemImpl fs = (FileSystemImpl)this.templateModel.getByPath("FileSystems/lib");
        if (fs != null) {
            return fs.getAbsoluteLocation();
        }
        return String.valueOf(this.getWebInfLocation()) + "/lib";
    }

    protected String getWebInfLocation() {
        FileSystemImpl fs = (FileSystemImpl)this.templateModel.getByPath("FileSystems/WEB-INF");
        return fs.getAbsoluteLocation();
    }

    protected void copyTemplate() throws Exception {
        String location;
        String location2 = location = this.getProject().getLocation().toString();
        String templateLocation = this.getTemplateLocation();
        String version = this.getProperty("WebNatureOperation.TEMPLATE_VERSION_ID");
        File templateFile = new File(templateLocation);
        templateLocation = templateFile.getCanonicalPath().replace('\\', '/');
        File targetDir = new File(location);
        File targetDir2 = new File(location2);
        FileUtil.copyDir((File)templateFile, (File)targetDir2, (boolean)true, (boolean)true);
        this.preprocessTemplate(templateFile, targetDir2);
        this.adjustProjectFile(targetDir, targetDir2);
        String tldStr = this.getProperty("WebNatureOperation.TLDS_ID");
        if (tldStr != null) {
            String webinf = this.getWebInfLocation();
            String webInfDir = String.valueOf(location2) + webinf.substring(templateLocation.length());
            String tldDir = String.valueOf(new StrutsUtils().getStrutsSupportTemplatesLocation(version)) + "/tld";
            StringTokenizer tokenizer = new StringTokenizer(tldStr, ";");
            while (tokenizer.hasMoreTokens()) {
                String fileName = tokenizer.nextToken();
                FileUtil.copyFile((File)new File(tldDir, fileName), (File)new File(webInfDir, fileName), (boolean)true);
            }
        }
        String[] strutsJars = this.template.getLibraries(version);
        String libDir = this.getLibLocation();
        libDir = String.valueOf(location2) + libDir.substring(templateLocation.length());
        int i = 0;
        while (i < strutsJars.length) {
            File source = new File(strutsJars[i]);
            FileUtil.copyFile((File)source, (File)new File(libDir, source.getName()), (boolean)true);
            ++i;
        }
        String servletVersion = this.getProperty("WebNatureOperation.SERVLET_VERSION_ID");
        String[] servletJars = WebUtils.getServletLibraries((String)this.template.getTemplatesBase(), (String)servletVersion);
        StringBuffer sb = new StringBuffer();
        int i2 = 0;
        while (i2 < servletJars.length) {
            sb.append(servletJars[i2++]).append(';');
        }
        Properties buildProperties = new Properties();
        buildProperties.setProperty("classpath.external", sb.toString());
        File antDir = new File(String.valueOf(location2) + "/ant");
        if (!antDir.exists()) {
            antDir.mkdirs();
        }
        BufferedOutputStream propFile = new BufferedOutputStream(new FileOutputStream(String.valueOf(location2) + "/ant/build.properties"));
        try {
            buildProperties.store(propFile, "");
        }
        finally {
            ((OutputStream)propFile).close();
        }
        this.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
    }

    private void adjustProjectFile(File targetDir, File targetDir2) {
        File f2 = this.getProjectFile(targetDir2);
        if (f2 != null) {
            f2.delete();
        }
    }

    private File getProjectFile(File targetDir2) {
        File f = new File(targetDir2, ".settings/org.jboss.tools.jst.web.xml");
        if (f.exists()) {
            return f;
        }
        return null;
    }
}

