/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.ui.wizard.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.common.meta.action.XAttributeData;
import org.jboss.tools.common.meta.action.XEntityData;
import org.jboss.tools.common.meta.action.impl.XEntityDataImpl;
import org.jboss.tools.common.meta.action.impl.handlers.HUtil;
import org.jboss.tools.common.model.ui.attribute.XAttributeSupport;
import org.jboss.tools.common.model.ui.attribute.adapter.IModelPropertyEditorAdapter;
import org.jboss.tools.common.model.ui.attribute.editor.DirectoryFieldEditorEx;
import org.jboss.tools.common.model.ui.attribute.editor.ExtendedFieldEditor;
import org.jboss.tools.common.model.ui.util.ModelUtilities;
import org.jboss.tools.jst.web.context.IImportWebProjectContext;
import org.jboss.tools.jst.web.context.ImportWebProjectContext;
import org.jboss.tools.jst.web.ui.wizards.appregister.AppRegisterComponent;
import org.jboss.tools.struts.StrutsPreference;
import org.jboss.tools.struts.StrutsUtils;

public class ImportProjectFoldersPage
extends WizardPage {
    static String[] ATTRIBUTES = new String[]{"classes", "lib", "build", "add libraries", "version", "servlet version"};
    private ImportWebProjectContext context;
    private XAttributeSupport support;
    private IModelPropertyEditorAdapter classesLocationAdapter;
    private IModelPropertyEditorAdapter libLocationAdapter;
    private IModelPropertyEditorAdapter buildXmlLocationAdapter;
    private IModelPropertyEditorAdapter addLibAdapter;
    private IModelPropertyEditorAdapter versionAdapter;
    private IModelPropertyEditorAdapter servletVersionAdapter;
    private PropertyChangeListener updateDataListener;
    AppRegisterComponent appRegister = new AppRegisterComponent();
    boolean lock = false;
    InputChangeListener inputListener = new InputChangeListener();

    protected ImportProjectFoldersPage(ImportWebProjectContext context) {
        super("Import Project Folders");
        this.context = context;
        context.setServletVersion(StrutsPreference.DEFAULT_STRUTS_IMPORT_SERVLET_VERSION.getValue());
        this.appRegister.setContext(context.getRegisterServerContext());
        this.appRegister.setLayoutForSupport(this.getLayoutForSupport());
        this.appRegister.setEnabling(false);
        XEntityDataImpl entityData = XEntityDataImpl.create((String[][])new String[][]{{"WebPrjAdoptStepFolders", ""}, {ATTRIBUTES[0], ""}, {ATTRIBUTES[1], ""}, {ATTRIBUTES[2], ""}, {ATTRIBUTES[3], ""}, {ATTRIBUTES[4], ""}, {ATTRIBUTES[5], ""}});
        XAttributeData[] ad = entityData.getAttributeData();
        int i = 0;
        while (i < ad.length) {
            ad[i].setValue("");
            ++i;
        }
        StrutsUtils t = new StrutsUtils();
        String[] versions = t.getVersionList();
        HUtil.hackAttributeConstraintList((XEntityData[])new XEntityData[]{entityData}, (int)0, (String)"version", (String[])versions);
        if (versions.length > 0) {
            context.setTemplateVersion(versions[0]);
            entityData.setValue("version", versions[0]);
        }
        this.support = new XAttributeSupport(ModelUtilities.getPreferenceModel().getRoot(), (XEntityData)entityData);
        this.support.setLayout(this.getLayoutForSupport());
        this.classesLocationAdapter = this.support.getPropertyEditorAdapterByName("classes");
        this.libLocationAdapter = this.support.getPropertyEditorAdapterByName("lib");
        this.buildXmlLocationAdapter = this.support.getPropertyEditorAdapterByName("build");
        this.addLibAdapter = this.support.getPropertyEditorAdapterByName("add libraries");
        this.versionAdapter = this.support.getPropertyEditorAdapterByName("version");
        this.servletVersionAdapter = this.support.getPropertyEditorAdapterByName("servlet version");
        this.appRegister.init();
        this.initListeners();
    }

    public void dispose() {
        super.dispose();
        if (this.support != null) {
            this.support.dispose();
        }
        this.support = null;
        this.updateDataListener = null;
        if (this.appRegister != null) {
            this.appRegister.dispose();
        }
        this.appRegister = null;
        this.classesLocationAdapter = null;
        this.libLocationAdapter = null;
        this.buildXmlLocationAdapter = null;
        this.addLibAdapter = null;
        this.versionAdapter = null;
        this.servletVersionAdapter = null;
    }

    private Layout getLayoutForSupport() {
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 4;
        gridLayout.marginWidth = 4;
        gridLayout.horizontalSpacing = 10;
        gridLayout.verticalSpacing = 10;
        return gridLayout;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new GridLayout());
        Composite ch = this.support.createControl(c);
        ch.setLayoutData((Object)new GridData(768));
        Label label = new Label(c, 258);
        label.setLayoutData((Object)new GridData(768));
        ch = this.appRegister.createControl(c);
        ch.setLayoutData((Object)new GridData(768));
        this.setControl((Control)c);
        this.validate();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.lock = true;
            this.classesLocationAdapter.setValue((Object)this.context.getClassesLocation());
            this.libLocationAdapter.setValue((Object)this.context.getLibLocation());
            this.buildXmlLocationAdapter.setValue((Object)this.context.getBuildXmlLocation());
            this.addLibAdapter.setValue((Object)("" + this.context.getAddLibraries()));
            this.versionAdapter.setValue((Object)this.context.getTemplateVersion());
            this.servletVersionAdapter.setValue((Object)this.context.getServletVersion());
            int i = 0;
            while (i < ATTRIBUTES.length) {
                ExtendedFieldEditor f = this.support.getPropertyEditorByName(ATTRIBUTES[i]).getFieldEditor(this.getControl().getParent());
                if (f instanceof DirectoryFieldEditorEx) {
                    ((DirectoryFieldEditorEx)f).setLastPath(this.context.getWebInfLocation());
                }
                ++i;
            }
            this.appRegister.loadApplicationName();
            this.lock = false;
        }
        this.validate();
        super.setVisible(visible);
    }

    private void initListeners() {
        this.updateDataListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (!ImportProjectFoldersPage.this.lock) {
                    ImportProjectFoldersPage.this.updateContext();
                    ImportProjectFoldersPage.this.validate();
                }
            }
        };
        this.support.addPropertyChangeListener(this.updateDataListener);
        this.appRegister.addPropertyChangeListener((PropertyChangeListener)this.inputListener);
    }

    private void updateContext() {
        this.context.setClassesLocation(this.classesLocationAdapter.getStringValue(false));
        this.context.setLibLocation(this.libLocationAdapter.getStringValue(false));
        this.context.setBuildXmlLocation(this.buildXmlLocationAdapter.getStringValue(false));
        this.context.setAddLibraries("true".equals(this.addLibAdapter.getStringValue(true)));
        this.context.setTemplateVersion(this.versionAdapter.getStringValue(true));
        this.context.setServletVersion(this.servletVersionAdapter.getStringValue(true));
    }

    public void validate() {
        String message = this.appRegister.getErrorMessage();
        this.setPageComplete(message == null);
        this.setErrorMessage(message);
        if (message != null) {
            return;
        }
        if (!this.context.isServletVersionConsistentToWebXML()) {
            String warning = IImportWebProjectContext.SERVLET_VERSION_WARNING;
            this.setMessage(warning, 2);
        } else {
            this.setMessage(null, 0);
        }
    }

    class InputChangeListener
    implements PropertyChangeListener {
        InputChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String an;
            ImportProjectFoldersPage.this.validate();
            if (!ImportProjectFoldersPage.this.lock && (an = ImportProjectFoldersPage.this.appRegister.getApplicationName()).length() > 0 && !an.equals(ImportProjectFoldersPage.this.context.getProjectName())) {
                ImportProjectFoldersPage.this.context.setApplicationName(an);
            }
        }
    }
}

