/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.ui.wizard.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.action.CommandBar;
import org.jboss.tools.common.model.ui.action.CommandBarListener;
import org.jboss.tools.common.model.ui.objecteditor.XTable;
import org.jboss.tools.common.model.ui.objecteditor.XTableProvider;
import org.jboss.tools.jst.web.context.ImportWebDirProjectContext;
import org.jboss.tools.struts.ui.wizard.addstruts.AddStrutsSupportWizard;
import org.jboss.tools.struts.ui.wizard.sync.ModuleTable;
import org.jboss.tools.struts.ui.wizard.sync.MutableModuleListTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportProjectModulesPage
extends WizardPage
implements PropertyChangeListener {
    private ModuleTable moduleTable = new ModuleTable();
    private ModuleListTableModel listModel = new ModuleListTableModel();
    private XTable list = new XTable();
    boolean lock = false;
    Label addStrutsSupportBarSeparator = null;
    CommandBar addStrutsSupportBar;
    String addStrutsSupportCommand = "         Add Struts Support         ";
    private ImportWebDirProjectContext context;
    Composite parent;
    Composite composite;

    public ImportProjectModulesPage(ImportWebDirProjectContext context) {
        super("");
        this.context = context;
        this.list.setAutoResize(true);
        this.list.setTableProvider((XTableProvider)this.listModel);
    }

    public void dispose() {
        super.dispose();
        if (this.moduleTable != null) {
            this.moduleTable.dispose();
        }
        this.moduleTable = null;
        if (this.list != null) {
            this.list.dispose();
        }
        this.list = null;
        if (this.addStrutsSupportBar != null) {
            this.addStrutsSupportBar.dispose();
        }
        this.addStrutsSupportBar = null;
    }

    public void createControl(Composite parent) {
        Composite composite;
        this.parent = parent;
        this.composite = composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 10;
        layout.verticalSpacing = 10;
        layout.marginHeight = 4;
        layout.marginWidth = 4;
        composite.setLayout((Layout)layout);
        Control c1 = this.list.createControl(composite);
        GridData g1 = new GridData(768);
        g1.horizontalSpan = 2;
        g1.heightHint = 80;
        g1.widthHint = 550;
        c1.setLayoutData((Object)g1);
        this.list.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportProjectModulesPage.this.updateSelection();
                ImportProjectModulesPage.this.validate();
            }
        });
        Label separator = new Label(composite, 258);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        separator.setLayoutData((Object)gd);
        gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        Control c2 = this.moduleTable.createControl(composite, this.context.getTarget());
        GridLayout l = (GridLayout)((Composite)c2).getLayout();
        l.marginWidth = 0;
        l.marginHeight = 0;
        GridData d = new GridData(1808);
        d.horizontalSpan = 2;
        c2.setLayoutData((Object)d);
        this.setControl((Control)composite);
        this.moduleTable.addPropertyChangeListener(this);
        this.validate();
    }

    private void createSupportBar() {
        if (this.addStrutsSupportBarSeparator != null && !this.addStrutsSupportBarSeparator.isDisposed()) {
            return;
        }
        this.addStrutsSupportBarSeparator = new Label(this.composite, 258);
        this.addStrutsSupportBarSeparator.setBackground(Display.getDefault().getSystemColor(9));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.addStrutsSupportBarSeparator.setLayoutData((Object)gd);
        this.addStrutsSupportBar = new CommandBar();
        this.addStrutsSupportBar.setCommands(new String[]{this.addStrutsSupportCommand});
        this.addStrutsSupportBar.addCommandBarListener((CommandBarListener)new CreateConfigOperation());
        this.addStrutsSupportBar.createControl(this.composite);
        this.addStrutsSupportBar.getLayout().left = this.moduleTable.getFieldInset();
        this.composite.update();
        this.composite.layout();
        this.composite.redraw();
    }

    private void removeSupportBar() {
        if (this.addStrutsSupportBarSeparator != null) {
            if (!this.addStrutsSupportBarSeparator.isDisposed()) {
                this.addStrutsSupportBarSeparator.dispose();
            }
            this.addStrutsSupportBarSeparator = null;
        }
        if (this.addStrutsSupportBar != null) {
            this.addStrutsSupportBar.dispose();
            this.addStrutsSupportBar = null;
            this.composite.update();
            this.composite.layout();
            this.composite.redraw();
        }
    }

    public void setDialogSize() {
        this.getShell().setSize(600, 550);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.listModel.setModelObject(this.getModules());
            this.list.update();
            this.list.getTable().setSelection(0);
            this.updateSelection();
        } else {
            this.moduleTable.commit();
        }
        if (visible) {
            this.validate();
        }
        super.setVisible(visible);
        if (visible) {
            this.validate();
        }
    }

    void updateSelection() {
        if (this.lock) {
            return;
        }
        this.lock = true;
        this.moduleTable.commit();
        this.moduleTable.setModelObject(this.getSelectedObject());
        this.lock = false;
    }

    public XModelObject getSelectedObject() {
        int i = this.list.getTable().getSelectionIndex();
        return i < 0 ? null : this.listModel.getModelObject(i);
    }

    @Override
    public void propertyChange(PropertyChangeEvent arg0) {
        if (this.lock) {
            return;
        }
        this.moduleTable.commit();
        this.validate();
        this.list.update();
    }

    public void validate() {
        boolean hasToAddStrutsSupport;
        XModelObject[] modules = this.getModules().toArray(new XModelObject[0]);
        String message = this.context.getModulesErrorMessage(modules, this.getSelectedObject());
        boolean bl = hasToAddStrutsSupport = message == null && modules.length == 0;
        if (hasToAddStrutsSupport) {
            this.createSupportBar();
        } else {
            this.removeSupportBar();
        }
        if (hasToAddStrutsSupport) {
            message = "The project should contain at least one Struts module to be imported";
        }
        this.setPageComplete(message == null);
        this.setErrorMessage(message);
        this.list.update();
    }

    private List<XModelObject> getModules() {
        ArrayList<XModelObject> list = new ArrayList<XModelObject>();
        XModelObject[] os = this.context.getAllModules();
        int i = 0;
        while (i < os.length) {
            list.add(os[i]);
            ++i;
        }
        return list;
    }

    class CreateConfigOperation
    implements CommandBarListener {
        CreateConfigOperation() {
        }

        public void action(String command) {
            int i = AddStrutsSupportWizard.run(ImportProjectModulesPage.this.getControl().getShell(), ImportProjectModulesPage.this.context);
            if (i != 0) {
                return;
            }
            ImportProjectModulesPage.this.listModel.setModelObject(ImportProjectModulesPage.this.getModules());
            ImportProjectModulesPage.this.list.update();
            ImportProjectModulesPage.this.list.getTable().setSelection(0);
            ImportProjectModulesPage.this.updateSelection();
            ImportProjectModulesPage.this.validate();
        }
    }

    private class ModuleListTableModel
    extends MutableModuleListTableModel {
        int[] hints = new int[]{10, 20};

        public ModuleListTableModel() {
            this.attrs = new String[]{"Name", "URI"};
        }

        public int getWidthHint(int c) {
            return this.hints[c];
        }
    }
}

