/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.ui.wizard.selectpage;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.common.model.XFilteredTree;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.navigator.FilteredTreeContentProvider;
import org.jboss.tools.common.model.ui.navigator.NavigatorLabelProvider;
import org.jboss.tools.common.model.ui.wizards.special.AbstractSpecialWizardStep;

public class SelectPageStep
extends AbstractSpecialWizardStep {
    protected XModelObject process;
    protected TreeViewer tree;
    protected XFilteredTree fTree;
    protected Text selected;
    protected XModelObject selectedObject = null;
    protected boolean lock = false;
    protected FilteredTreeContentProvider contentProvider;

    public void dispose() {
        super.dispose();
        if (this.fTree != null) {
            this.fTree.dispose();
        }
        this.fTree = null;
        this.tree = null;
    }

    public Control createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout());
        this.process = this.support.getTarget();
        this.createTree(composite);
        this.createText(composite);
        composite.pack();
        parent.layout();
        composite.layout();
        this.update0();
        return composite;
    }

    protected void createTree(Composite parent) {
        this.tree = new TreeViewer(parent);
        GridData gd = new GridData(1808);
        this.tree.getTree().setLayoutData((Object)gd);
        this.contentProvider = new FCM();
        this.contentProvider.setModel(this.support.getTarget().getModel());
        this.contentProvider.setFilteredTreeName("StrutsWeb");
        this.tree.setContentProvider((IContentProvider)this.contentProvider);
        this.tree.setLabelProvider((IBaseLabelProvider)new NavigatorLabelProvider());
        this.tree.setInput((Object)this.contentProvider);
        this.tree.refresh();
        this.tree.getTree().addSelectionListener((SelectionListener)new SL());
        this.tree.getTree().setVisible(true);
        this.tree.setAutoExpandLevel(2);
    }

    protected void createText(Composite parent) {
        this.selected = new Text(parent, 2048);
        this.selected.setEditable(false);
        GridData gd = new GridData(768);
        gd.heightHint = 18;
        this.selected.setLayoutData((Object)gd);
        this.selected.setBackground(new Color(null, 255, 255, 255));
    }

    public void update() {
    }

    public void update0() {
        this.process = this.support.getTarget();
        this.lock = true;
        this.selectedObject = (XModelObject)this.support.getProperties().get("selectedObject");
        XModelObject o = this.selectedObject;
        if (o != null) {
            this.tree.setSelection((ISelection)new StructuredSelection((Object)o), true);
        } else {
            o = (XModelObject)this.support.getProperties().get("selectedFileSystem");
            if (o != null) {
                this.tree.setSelection((ISelection)new StructuredSelection((Object)o), true);
            } else {
                this.selected.setText("");
            }
        }
        this.selected.setEditable(false);
        if (o != null) {
            this.selected.setText(this.fTree.getPath(o));
        }
        this.lock = false;
    }

    public void save() {
        String sp = this.selected.getText();
        this.support.getProperties().setProperty("selectedPath", sp);
        if (sp.length() > 0 && this.selectedObject != null) {
            this.support.getProperties().put("selectedObject", this.selectedObject);
        } else {
            this.support.getProperties().remove("selectedObject");
        }
        XModelObject fs = this.selectedObject;
        while (fs != null && fs.getFileType() != 3) {
            fs = fs.getParent();
        }
        if (fs != null) {
            this.support.getProperties().put("selectedFileSystem", fs);
        } else {
            this.support.getProperties().remove("selectedFileSystem");
        }
    }

    public Point getMaximumSize() {
        return null;
    }

    public Point getMinimumSize() {
        return null;
    }

    class FCM
    extends FilteredTreeContentProvider {
        protected XFilteredTree createFilteredTree() {
            XFilteredTree tree = super.createFilteredTree();
            if ("yes".equals(SelectPageStep.this.support.getProperties().get("isException"))) {
                tree.setConstraint((Object)new Boolean(true));
            }
            tree.setConstraint((Object)SelectPageStep.this.process);
            SelectPageStep.this.fTree = tree;
            return tree;
        }
    }

    class SL
    extends SelectionAdapter {
        SL() {
        }

        public void widgetSelected(SelectionEvent e) {
            StructuredSelection s = (StructuredSelection)SelectPageStep.this.tree.getSelection();
            Object o = s.getFirstElement();
            if (!(o instanceof XModelObject)) {
                return;
            }
            XModelObject mo = (XModelObject)o;
            SelectPageStep.this.selected.setText(SelectPageStep.this.fTree.getPath(mo));
            SelectPageStep.this.selectedObject = mo;
            SelectPageStep.this.save();
            SelectPageStep.this.validate();
        }
    }
}

