/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.ui.wizard.selectpath;

import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Control;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.action.XAction;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.meta.constraint.impl.XAttributeConstraintProperties;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.IActionHelper;
import org.jboss.tools.common.model.ui.actions.IActionProvider;
import org.jboss.tools.common.model.ui.attribute.adapter.DefaultValueAdapter;
import org.jboss.tools.struts.model.helpers.StrutsProcessStructureHelper;
import org.jboss.tools.struts.model.helpers.TilesHelper;
import org.jboss.tools.struts.model.helpers.path.ActionsTree;
import org.jboss.tools.struts.ui.StrutsUIPlugin;
import org.jboss.tools.struts.webprj.model.helpers.WebModulesHelper;
import org.jboss.tools.struts.webprj.pattern.UrlPattern;

public class PathEditorAdapter
extends DefaultValueAdapter
implements IActionHelper {
    public static int ACTIONS = 1;
    public static int PAGES = 2;
    public static int TILES = 4;
    private XModelObject object;
    private XModelObject contextProcess = null;
    protected String attrname = "";
    Set<String> tiles = new TreeSet<String>();
    ActionsTree actions = null;
    Properties p = null;
    private IActionProvider actionProvider;
    private XActionWrapper labelAction;

    public void dispose() {
        super.dispose();
        if (this.tiles != null) {
            this.tiles.clear();
        }
        this.tiles = null;
        this.p = null;
        if (this.actions != null) {
            this.actions.dispose();
        }
        this.actions = null;
    }

    public void load() {
        this.setConstraints(this.attribute, this.modelObject);
        super.load();
    }

    public String getCommand() {
        return "...";
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IActionHelper.class) {
            return this;
        }
        if (adapter == IActionProvider.class) {
            return this.actionProvider;
        }
        return super.getAdapter(adapter);
    }

    public void setConstraints(XAttribute a, XModelObject o) {
        XAttribute attr = a;
        this.attrname = attr.getName();
        if (a.getConstraint() instanceof XAttributeConstraintProperties) {
            this.p = ((XAttributeConstraintProperties)a.getConstraint()).getProperties();
        }
        this.object = o;
        if (this.object != null && this.isTileDefinition(this.object)) {
            this.contextProcess = this.object;
        } else {
            this.updateContextProcess();
        }
        this.createActionProvider();
    }

    private boolean isTileDefinition(XModelObject o) {
        String entity = o.getModelEntity().getName();
        return entity.equals("TilesDefinition") || entity.equals("FileTiles");
    }

    private boolean isCreatingLink(XModelObject o) {
        String entity = o.getModelEntity().getName();
        return "StrutsProcessItem".equals(entity) && "page".equals(o.getAttributeValue("type"));
    }

    private void updateContextProcess() {
        XModelObject o = this.object;
        while (o != null && o.getFileType() == 0) {
            o = o.getParent();
        }
        this.contextProcess = o == null ? null : o.getChildByPath("process");
    }

    public String invoke(Control control) {
        return this.invoke0(control);
    }

    public String invoke0(Control control) {
        if (this.contextProcess == null) {
            return null;
        }
        Properties runningProperties = new Properties();
        this.loadContext(runningProperties);
        String v = this.getStringValue(false);
        if (!(v == null || v.length() <= 0 || (this.getTools() & TILES) != 0 && this.tiles.contains(v))) {
            if (!v.startsWith("/")) {
                v = "/" + v;
            }
            XModelObject config = StrutsProcessStructureHelper.instance.getParentFile(this.contextProcess);
            WebModulesHelper wmh = WebModulesHelper.getInstance((XModel)config.getModel());
            String module = wmh.getModuleForConfig(config);
            UrlPattern urlPattern = wmh.getUrlPattern(module);
            urlPattern.getActionPath(v);
            if (urlPattern.isActionUrl(v)) {
                v = urlPattern.getActionUrl(v);
            }
        }
        runningProperties.setProperty("selectedPath", v);
        runningProperties.put("contextProcess", this.contextProcess);
        runningProperties.put("title", "Edit " + this.attrname);
        if (control != null) {
            runningProperties.put("shell", control.getShell());
        }
        if (this.object.getModelEntity().getName().startsWith("StrutsException")) {
            runningProperties.setProperty("isException", "yes");
        }
        XActionInvoker.invoke((String)"StrutsCreateActionForwardStep", (String)"EditPath", (XModelObject)this.object, (Properties)runningProperties);
        return runningProperties.getProperty("selectedPath");
    }

    protected int getTools() {
        String entity = this.object.getModelEntity().getName();
        if (this.isTileDefinition(this.object)) {
            if ("path".equals(this.attrname)) {
                return 2;
            }
            if ("controllerUrl".equals(this.attrname)) {
                return 1;
            }
        }
        if (entity.startsWith("StrutsException")) {
            return 3;
        }
        entity = this.object.getParent().getModelEntity().getName();
        if (entity.startsWith("StrutsGlobalForwards")) {
            return 7;
        }
        if (this.isCreatingLink(this.object)) {
            return 3;
        }
        return 6;
    }

    private void loadContext(Properties p) {
        int tools = this.getTools();
        if ((tools & ACTIONS) != 0) {
            this.actions = new ActionsTree();
            this.actions.setModel(this.object.getModel());
            this.actions.setConstraint((Object)this.object);
            p.put("actionsTree", this.actions);
        } else {
            this.actions = null;
            p.remove("actionsTree");
        }
        p.setProperty("tools", "" + tools);
        this.tiles.clear();
        if ((tools & TILES) != 0) {
            this.tiles.addAll(TilesHelper.getTiles((XModelObject)this.object).keySet());
        }
        p.put("tiles", this.tiles);
    }

    private void createActionProvider() {
        this.actionProvider = new ActionProvider();
        String actionPath = this.p == null ? null : this.p.getProperty("linkAction");
        XAction xaction = actionPath == null ? null : XActionInvoker.getAction((String)actionPath, (XModelObject)this.modelObject);
        XActionWrapper xActionWrapper = this.labelAction = xaction != null ? new XActionWrapper(xaction) : null;
        if (this.labelAction != null) {
            this.labelAction.setXModelObject(this.object);
        }
    }

    class ActionProvider
    implements IActionProvider {
        private static final String STRING_BUTTON_ACTION = "Label.Selected";

        ActionProvider() {
        }

        public IAction getAction(String actionName) {
            if (STRING_BUTTON_ACTION.equals(actionName)) {
                return PathEditorAdapter.this.labelAction;
            }
            return null;
        }

        public IAction[] getActions() {
            return new IAction[]{PathEditorAdapter.this.labelAction};
        }

        public void update(ISelection selection) {
        }
    }

    class XActionWrapper
    extends Action {
        private XAction xaction = null;

        public XActionWrapper(XAction xaction) {
            this.xaction = xaction;
        }

        public void setXModelObject(XModelObject xmo) {
            if (xmo != null && this.xaction != null) {
                this.setEnabled(this.xaction.isEnabled(xmo));
                this.setEnabled(Boolean.TRUE);
            } else {
                this.setEnabled(Boolean.FALSE);
            }
        }

        public void run() {
            if (this.xaction != null) {
                try {
                    XActionInvoker.invoke((String)this.xaction.getPath(), (XModelObject)PathEditorAdapter.this.modelObject, (Properties)new Properties());
                }
                catch (Exception e) {
                    StrutsUIPlugin.getPluginLog().logError((Throwable)e);
                }
            }
        }
    }
}

