/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.ui.wizard.selectpath;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.common.model.XFilteredTree;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.navigator.FilteredTreeContentProvider;
import org.jboss.tools.common.model.ui.navigator.NavigatorLabelProvider;
import org.jboss.tools.common.model.ui.wizards.special.AbstractSpecialWizardStep;
import org.jboss.tools.struts.model.helpers.path.ActionsTree;

public class SelectActionScreen
extends AbstractSpecialWizardStep {
    protected TreeViewer tree;
    protected XFilteredTree fTree;
    protected Text selected;
    protected XModelObject selectedObject = null;
    protected boolean lock = false;
    protected FilteredTreeContentProvider contentProvider;
    private SelectionAdapter selectionListener = new SL();

    public void dispose() {
        super.dispose();
        if (this.fTree != null) {
            this.fTree.dispose();
        }
        this.fTree = null;
        if (this.contentProvider != null) {
            this.contentProvider.dispose();
        }
        this.contentProvider = null;
        this.selectionListener = null;
        this.tree = null;
    }

    public Control createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this.createTree(composite);
        this.createText(composite);
        composite.pack();
        parent.layout();
        composite.layout();
        this.update0();
        return composite;
    }

    protected void createTree(Composite parent) {
        this.tree = new TreeViewer(parent);
        GridData gd = new GridData(1808);
        this.tree.getTree().setLayoutData((Object)gd);
        this.contentProvider = new FCM();
        this.contentProvider.setModel(this.support.getTarget().getModel());
        this.contentProvider.setFilteredTreeName("StrutsWeb");
        this.tree.setContentProvider((IContentProvider)this.contentProvider);
        this.tree.setLabelProvider((IBaseLabelProvider)new ALabelProvider());
        this.tree.setInput((Object)this.contentProvider);
        this.tree.refresh();
        this.tree.getTree().addSelectionListener((SelectionListener)this.selectionListener);
        this.tree.getTree().setVisible(true);
        this.tree.setAutoExpandLevel(2);
    }

    protected void createText(Composite parent) {
        this.selected = new Text(parent, 2048);
        this.selected.setEditable(false);
        GridData gd = new GridData(768);
        gd.heightHint = 18;
        this.selected.setLayoutData((Object)gd);
        this.selected.setBackground(new Color(null, 255, 255, 255));
    }

    public void update() {
    }

    public void update0() {
        XModelObject po;
        this.selectedObject = (XModelObject)this.support.getProperties().get("selectedAction");
        XModelObject xModelObject = po = this.selectedObject == null ? null : this.selectedObject.getParent().getParent();
        if (po != null) {
            this.tree.setSelection((ISelection)new StructuredSelection((Object)po), true);
        }
        if (this.selectedObject != null) {
            this.tree.setSelection((ISelection)new StructuredSelection((Object)this.selectedObject), true);
        }
        this.selected.setEditable(false);
        if (this.selectedObject != null) {
            this.selected.setText(this.fTree.getPath(this.selectedObject));
        }
    }

    public void save() {
        String sp = this.selected.getText();
        this.support.getProperties().setProperty("selectedPath", sp);
        if (sp.length() > 0 && this.selectedObject != null) {
            this.support.getProperties().put("selectedAction", this.selectedObject);
        } else {
            this.support.getProperties().remove("selectedAction");
        }
    }

    public Point getMaximumSize() {
        return null;
    }

    public Point getMinimumSize() {
        return null;
    }

    class ALabelProvider
    extends NavigatorLabelProvider {
        ALabelProvider() {
        }

        public String getText(Object element) {
            if (SelectActionScreen.this.fTree == null || !(element instanceof XModelObject)) {
                return super.getText(element);
            }
            XModelObject o = (XModelObject)element;
            return ((ActionsTree)SelectActionScreen.this.fTree).getPresentation(o);
        }
    }

    class FCM
    extends FilteredTreeContentProvider {
        protected XFilteredTree createFilteredTree() {
            ActionsTree tree = new ActionsTree();
            tree.setModel(SelectActionScreen.this.support.getTarget().getModel());
            if ("yes".equals(SelectActionScreen.this.support.getProperties().get("isException"))) {
                tree.setConstraint((Object)new Boolean(true));
            }
            tree.setConstraint((Object)SelectActionScreen.this.support.getTarget());
            SelectActionScreen.this.fTree = tree;
            return tree;
        }
    }

    class SL
    extends SelectionAdapter {
        SL() {
        }

        public void widgetSelected(SelectionEvent e) {
            StructuredSelection s = (StructuredSelection)SelectActionScreen.this.tree.getSelection();
            Object o = s.getFirstElement();
            if (!(o instanceof XModelObject)) {
                return;
            }
            XModelObject mo = (XModelObject)o;
            SelectActionScreen.this.selected.setText(SelectActionScreen.this.fTree.getPath(mo));
            SelectActionScreen.this.selectedObject = mo;
            SelectActionScreen.this.save();
            SelectActionScreen.this.validate();
        }
    }
}

