/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.ui.wizard.sync;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.objecteditor.XAttributeInfo;
import org.jboss.tools.common.model.ui.objecteditor.XTableProvider;
import org.jboss.tools.struts.ui.wizard.sync.ModuleInfoValidator;
import org.jboss.tools.struts.ui.wizard.sync.MutableModuleListTableModel;

public class ModuleInfoTableModel
implements XTableProvider {
    protected XModelObject object = null;
    String[] attrs = new String[]{"name", "URI", "path on disk", "java src", "root"};
    MutableModuleListTableModel list;
    int[] hints = new int[]{5, 15};

    public void dispose() {
        if (this.list != null) {
            this.list.dispose();
        }
        this.list = null;
    }

    public void setModelObject(XModelObject object) {
        if (this.object == object) {
            return;
        }
        this.object = object;
    }

    public void setListener(MutableModuleListTableModel list) {
        this.list = list;
    }

    public int getRowCount() {
        return 5;
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int c) {
        return c == 0 ? "name" : "value";
    }

    public boolean isCellEditable(int r, int c) {
        return this.object != null && c == 1 && r >= 2;
    }

    public String getValueAt(int r, int c) {
        if (this.object == null) {
            return "";
        }
        if (c == 0) {
            if (r < 4) {
                return this.attrs[r];
            }
            String n = this.object.getAttributeValue("name");
            return n.length() == 0 ? "web root" : "module root";
        }
        String v = this.object.getAttributeValue(this.attrs[r]);
        if (r == 0 && v.length() == 0) {
            return "<default>";
        }
        return v;
    }

    public void setValueAt(Object aValue, int r, int c) {
        if (this.object == null || !this.isCellEditable(r, c)) {
            return;
        }
        this.object.setAttributeValue(this.attrs[r], "" + aValue);
    }

    public XModelObject getModelObject() {
        return this.object;
    }

    public boolean isNotUniqueValue(int r, int c) {
        return this.list != null && this.list.isNotUniqueValue(this.attrs[r], this.getValueAt(r, c));
    }

    public Color getColor(int r) {
        XModelObject o = this.getModelObject();
        boolean valid = o == null || o.getObject("error") == null && ModuleInfoValidator.isModuleDataValid(o);
        Color color = valid ? Display.getDefault().getSystemColor(2) : Display.getDefault().getSystemColor(3);
        return color;
    }

    public int getWidthHint(int c) {
        return this.hints[c];
    }

    public Object getDataAt(int r) {
        if (r < 2 || this.getModelObject() == null || "deleted".equals(this.object.get("state"))) {
            return null;
        }
        return new XAttributeInfo(this.getModelObject(), this.attrs[r]);
    }
}

