/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.ui.wizard.sync;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.action.CommandBarListener;
import org.jboss.tools.common.model.ui.objecteditor.XTable;
import org.jboss.tools.common.model.ui.objecteditor.XTableProvider;
import org.jboss.tools.common.model.ui.wizards.special.AbstractSpecialWizardStep;
import org.jboss.tools.struts.ui.Messages;
import org.jboss.tools.struts.ui.StrutsUIPlugin;
import org.jboss.tools.struts.ui.wizard.sync.ModuleInfoValidator;
import org.jboss.tools.struts.ui.wizard.sync.ModuleTable;
import org.jboss.tools.struts.ui.wizard.sync.MutableModuleListTableModel;
import org.jboss.tools.struts.ui.wizard.sync.SyncBar;
import org.jboss.tools.struts.webprj.model.helpers.sync.SyncProjectContext;

public class SyncProjectStepView
extends AbstractSpecialWizardStep
implements PropertyChangeListener {
    protected ArrayList objects = new ArrayList();
    protected Composite panel;
    protected MutableModuleListTableModel listmodel = new MutableModuleListTableModel();
    protected XTable list = new XTable();
    protected SyncBar bar = new SyncBar();
    protected ModuleTable moduleTable = new ModuleTable();
    boolean isDataChanged = false;
    boolean lock = false;

    public SyncProjectStepView() {
        this.list.setAutoResize(true);
        this.list.setTableProvider((XTableProvider)this.listmodel);
        this.bar.getCommandBar().addCommandBarListener((CommandBarListener)new CL());
        this.moduleTable.setListener(this.listmodel);
    }

    public Control createControl(Composite parent) {
        this.panel = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        this.panel.setLayout((Layout)gridLayout);
        Control c1 = this.createListControl(this.panel);
        GridData g1 = new GridData(1808);
        g1.heightHint = 150;
        c1.setLayoutData((Object)g1);
        Composite cs = new Composite(this.panel, 0);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 10;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        cs.setLayout((Layout)gridLayout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        cs.setLayoutData((Object)gd);
        Label separator = new Label(cs, 258);
        separator.setLayoutData((Object)new GridData(768));
        Control c2 = this.moduleTable.createControl(this.panel, this.support.getTarget());
        GridData g2 = new GridData(768);
        g2.widthHint = 600;
        c2.setLayoutData((Object)g2);
        this.update();
        this.moduleTable.addPropertyChangeListener(this);
        return this.panel;
    }

    protected Control createListControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 10;
        gridLayout.marginWidth = 10;
        gridLayout.horizontalSpacing = 10;
        gridLayout.verticalSpacing = 10;
        composite.setLayout((Layout)gridLayout);
        Composite c = new Composite(composite, 0);
        gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        c.setLayout((Layout)gridLayout);
        Control control = this.list.createControl(c);
        this.list.getTable().addSelectionListener((SelectionListener)new SL());
        GridData gd = new GridData(1808);
        control.setLayoutData((Object)gd);
        control = new Label(c, 0);
        gd = new GridData();
        gd.widthHint = 5;
        control.setLayoutData((Object)gd);
        control = this.bar.getCommandBar().createControl(c);
        this.bar.getCommandBar().getLayout().buttonWidth = this.convertHorizontalDLUsToPixels(control, 61);
        gd = new GridData(1040);
        gd.widthHint = this.convertHorizontalDLUsToPixels(control, 61);
        control.setLayoutData((Object)gd);
        gd = new GridData(1808);
        c.setLayoutData((Object)gd);
        gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        return composite;
    }

    public void update() {
        IFile f;
        this.lock = true;
        this.objects = (ArrayList)this.support.getProperties().get("modules");
        this.listmodel.setModelObject(this.objects);
        SyncProjectContext context = (SyncProjectContext)this.support.getProperties().get("context");
        XModelObject webxml = context.getWebXML();
        boolean bl = this.bar.addEnabled = webxml != null && webxml.isObjectEditable();
        if (webxml != null && (f = (IFile)webxml.getAdapter(IFile.class)) != null) {
            this.moduleTable.setDefaultLocation(f.getLocation().toString());
        }
        try {
            this.list.update();
        }
        catch (Exception e) {
            StrutsUIPlugin.getPluginLog().logError((Throwable)e);
        }
        this.lock = false;
        int sel = -1;
        int i = 0;
        while (i < this.objects.size()) {
            XModelObject o = this.listmodel.getModelObject(i);
            if (sel < 0 && !ModuleInfoValidator.isModuleDataValid(o)) {
                sel = i;
            }
            ++i;
        }
        if (sel < 0 && this.objects.size() > 0) {
            sel = 0;
        }
        if (sel >= 0 && this.list.getControl() != null) {
            this.list.getTable().deselectAll();
            this.list.getTable().select(sel);
        }
        if (this.list.getTable() != null) {
            this.updateSelection();
        }
    }

    protected int convertHorizontalDLUsToPixels(Control control, int dlus) {
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        int averageWidth = gc.getFontMetrics().getAverageCharWidth();
        gc.dispose();
        double horizontalDialogUnitSize = (double)averageWidth * 0.25;
        return (int)Math.round((double)dlus * horizontalDialogUnitSize);
    }

    public void dispose() {
        super.dispose();
        this.objects = null;
        if (this.listmodel != null) {
            this.listmodel.dispose();
        }
        this.listmodel = null;
        if (this.list != null) {
            this.list.dispose();
        }
        this.list = null;
        if (this.bar != null) {
            this.bar.dispose();
        }
        this.bar = null;
        if (this.moduleTable != null) {
            this.moduleTable.dispose();
        }
        this.moduleTable = null;
    }

    public XModelObject getSelectedObject() {
        int i = this.list.getTable().getSelectionIndex();
        return i < 0 ? null : this.listmodel.getModelObject(i);
    }

    void updateSelection() {
        if (this.lock) {
            return;
        }
        this.lock = true;
        this.save();
        this.bar.setModelObject(this.getSelectedObject());
        this.moduleTable.update();
        this.moduleTable.setModelObject(this.getSelectedObject());
        this.lock = false;
    }

    public void save() {
        this.stopEditing();
    }

    public void stopEditing() {
        this.moduleTable.commit();
    }

    public Point getMaximumSize() {
        return null;
    }

    public Point getMinimumSize() {
        return new Point(600, -1);
    }

    public void propertyChange(PropertyChangeEvent arg0) {
        if (this.lock) {
            return;
        }
        this.moduleTable.commit();
        this.validate();
    }

    public void validate() {
        Properties p = new Properties();
        p.put("modules", this.objects);
        XModelObject s = this.getSelectedObject();
        if (s == null) {
            p.remove("selected");
        } else {
            p.put("selected", s);
        }
        this.isDataChanged = true;
        if (this.validator != null) {
            this.validator.validate(p);
        }
        this.list.update();
        if (this.validator != null) {
            this.wizard.dataChanged(this.validator, p);
        }
    }

    public boolean isDataChanged() {
        return this.isDataChanged;
    }

    class CL
    implements CommandBarListener {
        CL() {
        }

        public void action(String name) {
            if (SyncBar.ADD.equals(name)) {
                XActionInvoker.invoke((String)"WebPrjAddModuleHelper", (String)"Add", (XModelObject)SyncProjectStepView.this.support.getTarget(), (Properties)SyncProjectStepView.this.support.getProperties());
                SyncProjectStepView.this.list.update();
                SyncProjectStepView.this.moduleTable.update();
                SyncProjectStepView.this.bar.updateControl();
                SyncProjectStepView.this.validate();
                return;
            }
            XModelObject s = SyncProjectStepView.this.getSelectedObject();
            if (s == null) {
                return;
            }
            if (SyncBar.RESTORE.equals(name)) {
                int i;
                String uri = s.getAttributeValue("URI");
                String path = s.getAttributeValue("path on disk");
                if (uri.length() == 0 && path.length() > 0 && (i = path.lastIndexOf(47)) >= 0) {
                    s.setAttributeValue("URI", "/WEB-INF/" + path.substring(i + 1));
                }
                s.set("state", "restored");
            } else if (SyncBar.DELETE.equals(name)) {
                int si = SyncProjectStepView.this.list.getTable().getSelectionIndex();
                if (si < 0) {
                    return;
                }
                XModelObject so = SyncProjectStepView.this.listmodel.getModelObject(si);
                boolean isConfig = "JstWebConfig".equals(so.getModelEntity().getName());
                String msg = !isConfig ? MessageFormat.format(Messages.SyncProjectStepView_DeleteModule, SyncProjectStepView.this.listmodel.getValueAt(si, 0)) : MessageFormat.format(Messages.SyncProjectStepView_DeleteURI, SyncProjectStepView.this.listmodel.getValueAt(si, 1));
                MessageDialog d = new MessageDialog(SyncProjectStepView.this.panel.getShell(), Messages.SyncProjectStepView_Confirmation, null, msg, 3, new String[]{Messages.SyncProjectStepView_OK, Messages.SyncProjectStepView_Cancel}, 0);
                int i = d.open();
                if (i != 0) {
                    return;
                }
                s.set("state", "deleted");
                XModelObject[] sc = s.getChildren();
                int k = 0;
                while (k < sc.length) {
                    sc[k].set("state", "deleted");
                    ++k;
                }
            }
            SyncProjectStepView.this.list.update();
            SyncProjectStepView.this.bar.updateControl();
            SyncProjectStepView.this.moduleTable.update();
            SyncProjectStepView.this.validate();
        }
    }

    class SL
    extends SelectionAdapter {
        SL() {
        }

        public void widgetSelected(SelectionEvent e) {
            SyncProjectStepView.this.updateSelection();
            SyncProjectStepView.this.validate();
        }
    }
}

