/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.validator.ui;

import java.util.ArrayList;
import org.eclipse.swt.widgets.Combo;

public class DefaultComboModel {
    protected Combo combo;
    protected ArrayList<Object> list = new ArrayList();

    public void dispose() {
        if (this.list != null) {
            this.list.clear();
        }
        this.list = null;
    }

    public void setCombo(Combo combo) {
        this.combo = combo;
    }

    public int getIndexOf(Object object) {
        int i = 0;
        while (i < this.list.size()) {
            if (this.list.get(i) == object) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void removeAllElements() {
        if (this.combo != null) {
            this.combo.removeAll();
        }
        this.list.clear();
    }

    public Object getSelectedItem() {
        return this.combo == null ? null : this.getElementAt(this.combo.getSelectionIndex());
    }

    public void setSelectedItem(Object o) {
        if (this.combo == null) {
            return;
        }
        int i = this.getIndexOf(o);
        if (i < 0) {
            this.combo.setText("");
        } else {
            this.combo.setText(this.combo.getItem(i));
        }
    }

    public Object getElementAt(int i) {
        return i < 0 || i >= this.list.size() ? null : this.list.get(i);
    }

    public int getSize() {
        return this.list.size();
    }

    public void addElement(Object o) {
        this.list.add(o);
        if (this.combo != null) {
            this.combo.add(this.getPresentation(o));
        }
    }

    public String getPresentation(Object object) {
        return object == null ? "" : object.toString();
    }

    public void refresh() {
        if (this.combo == null || this.isUpToDate()) {
            return;
        }
        Object selected = this.getSelectedItem();
        this.combo.removeAll();
        int s = this.getSize();
        int i = 0;
        while (i < s) {
            this.combo.add(this.getPresentation(this.getElementAt(i)));
            ++i;
        }
        if (selected != null) {
            this.setSelectedItem(selected);
        }
        this.combo.pack(true);
    }

    private boolean isUpToDate() {
        int s = this.getSize();
        if (this.combo.getItemCount() != s) {
            return false;
        }
        int i = 0;
        while (i < s) {
            String s1 = this.getPresentation(this.getElementAt(i));
            String s2 = this.combo.getItem(i);
            if (s1 == null || !s1.equals(s2)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

