/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.validator.ui;

import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.common.editor.AbstractSelectionProvider;
import org.jboss.tools.common.editor.ObjectMultiPageEditor;
import org.jboss.tools.common.editor.ObjectTextEditor;
import org.jboss.tools.common.editor.TreeGuiEditor;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.texteditors.XMLTextEditorComponent;
import org.jboss.tools.struts.validator.ui.XStudioValidatorPlugin;
import org.jboss.tools.struts.validator.ui.constants.ConstantsEditor;
import org.jboss.tools.struts.validator.ui.formset.FormsetsEditor;
import org.jboss.tools.struts.validator.ui.global.ValidatorsEditor;
import org.jboss.tools.struts.validator.ui.internal.ValidatorManager;

public class ValidationCompoundEditor
extends ObjectMultiPageEditor {
    public static String ENTITY = "FileValidationRules";
    protected FormsetsEditor formsetsEditor;
    protected ValidatorsEditor validatorsEditor;
    protected ConstantsEditor constantsEditor;
    AbstractSelectionProvider emptyProvider = new SP();

    protected Composite createPageContainer(Composite parent) {
        Composite composite = super.createPageContainer(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.jboss.tools.struts.ui.validation_editor");
        return composite;
    }

    public void dispose() {
        try {
            this.getSite().setSelectionProvider(null);
        }
        catch (Exception e) {
            XStudioValidatorPlugin.getPluginLog().logError((Throwable)e);
        }
        this.selectionProvider.setHost(null);
        if (this.formsetsEditor != null) {
            this.formsetsEditor.dispose();
        }
        this.formsetsEditor = null;
        if (this.validatorsEditor != null) {
            this.validatorsEditor.dispose();
        }
        this.validatorsEditor = null;
        if (this.constantsEditor != null) {
            this.constantsEditor.dispose();
        }
        this.constantsEditor = null;
        super.dispose();
    }

    protected boolean isWrongEntity(String entity) {
        return entity == null || !entity.startsWith(ENTITY);
    }

    protected void doCreatePages() {
        if (this.isAppropriateNature()) {
            this.createFormsetsPage();
            this.createValidatorsPage();
            this.createConstantsPage();
            this.createTreePage();
        }
        this.createTextPage();
        if (this.textEditor != null) {
            this.selectionProvider.addHost("textEditor", (ISelectionProvider)this.getTextSelectionProvider());
        }
        this.initEditors();
        if (this.treeEditor != null) {
            this.selectionProvider.addHost("treeEditor", this.treeEditor.getSelectionProvider());
        }
        if (this.treeFormPage != null) {
            this.selectionProvider.addHost("treeEditor", this.treeFormPage.getSelectionProvider());
        }
        if (this.formsetsEditor != null) {
            this.selectionProvider.setHost(this.formsetsEditor.getSelectionProvider());
        }
    }

    protected void createFormsetsPage() {
        this.formsetsEditor = new FormsetsEditor();
        if (this.getModelObject().getModelEntity().getName().endsWith("11")) {
            this.formsetsEditor.set11();
        }
        try {
            this.formsetsEditor.init(this.getEditorSite(), this.getEditorInput());
            int index = this.addPage((IEditorPart)this.formsetsEditor, this.getEditorInput());
            this.setPageText(index, "Formsets");
        }
        catch (Exception e) {
            XStudioValidatorPlugin.getPluginLog().logError((Throwable)e);
        }
        this.formsetsEditor.addErrorSelectionListener(this.createErrorSelectionListener());
        this.selectionProvider.addHost("formsetsEditor", this.formsetsEditor.getSelectionProvider());
    }

    protected void createValidatorsPage() {
        this.validatorsEditor = new ValidatorsEditor();
        try {
            this.validatorsEditor.init(this.getEditorSite(), this.getEditorInput());
            int index = this.addPage((IEditorPart)this.validatorsEditor, this.getEditorInput());
            this.setPageText(index, "Validators");
        }
        catch (Exception e) {
            XStudioValidatorPlugin.getPluginLog().logError((Throwable)e);
        }
        this.validatorsEditor.addErrorSelectionListener(this.createErrorSelectionListener());
        this.selectionProvider.addHost("validatorsEditor", this.validatorsEditor.getSelectionProvider());
    }

    protected void createConstantsPage() {
        this.constantsEditor = new ConstantsEditor();
        try {
            this.constantsEditor.init(this.getEditorSite(), this.getEditorInput());
            int index = this.addPage((IEditorPart)this.constantsEditor, this.getEditorInput());
            this.setPageText(index, "Constants");
        }
        catch (Exception e) {
            XStudioValidatorPlugin.getPluginLog().logError((Throwable)e);
        }
        this.constantsEditor.addErrorSelectionListener(this.createErrorSelectionListener());
        this.selectionProvider.addHost("constantsEditor", this.constantsEditor.getSelectionProvider());
    }

    protected void createTreePage() {
        this.treeEditor = new TreeGuiEditor();
        try {
            this.treeEditor.init(this.getEditorSite(), this.getEditorInput());
            int index = this.addPage((IEditorPart)this.treeEditor, this.getEditorInput());
            this.setPageText(index, "Tree");
        }
        catch (Exception e) {
            XStudioValidatorPlugin.getPluginLog().logError((Throwable)e);
        }
        this.treeEditor.addErrorSelectionListener(this.createErrorSelectionListener());
        this.selectionProvider.addHost("treeEditor", this.treeEditor.getSelectionProvider());
    }

    protected ObjectTextEditor createTextEditor() {
        return new XMLTextEditorComponent();
    }

    protected void setNormalMode() {
        if (!this.isAppropriateNature()) {
            return;
        }
        if (this.formsetsEditor != null) {
            this.formsetsEditor.setObject(this.object, this.isErrorMode());
            this.constantsEditor.setObject(this.object, this.isErrorMode());
            this.validatorsEditor.setObject(this.object, this.isErrorMode());
            this.treeEditor.setObject(this.object, this.isErrorMode());
            this.formsetsEditor.update();
            this.constantsEditor.update();
            this.validatorsEditor.update();
        }
        if (this.treeFormPage != null) {
            this.treeFormPage.initialize((Object)this.getModelObject());
            this.treeFormPage.setErrorMode(this.isErrorMode());
        }
    }

    protected void setErrorMode() {
        this.setNormalMode();
    }

    protected void updateSelectionProvider() {
        int i = this.getActivePage();
        AbstractSelectionProvider p = this.emptyProvider;
        if (this.formsetsEditor != null) {
            p = this.isErrorMode ? this.emptyProvider : (i == 0 ? this.formsetsEditor.getSelectionProvider() : (i == 1 ? this.validatorsEditor.getSelectionProvider() : (i == 2 ? this.constantsEditor.getSelectionProvider() : (i == 3 ? this.treeEditor.getSelectionProvider() : this.emptyProvider))));
        } else if (this.treeEditor != null) {
            p = this.treeEditor.getSelectionProvider();
        } else if (this.treeFormPage != null) {
            p = this.treeFormPage.getSelectionProvider();
        }
        this.selectionProvider.setHost((ISelectionProvider)p);
        if (p instanceof AbstractSelectionProvider) {
            p.fireSelectionChanged();
        } else if (i == 3) {
            this.treeEditor.fireEditorSelected();
        }
    }

    protected void updateEditableMode() {
        if (this.isAppropriateNature() && this.formsetsEditor != null) {
            this.formsetsEditor.updateEditableMode();
            this.validatorsEditor.updateEditableMode();
            this.constantsEditor.updateEditableMode();
        }
    }

    public void registerValidator() {
        ValidatorManager.getDefault().registerValidators((Object)this);
    }

    public void unregisterValidator() {
        ValidatorManager.getDefault().unregisterValidators((Object)this);
    }

    public Object getAdapter(Class adapter) {
        return super.getAdapter(adapter);
    }

    class SP
    extends AbstractSelectionProvider {
        SP() {
        }

        protected XModelObject getSelectedModelObject() {
            return null;
        }

        protected void setSelectedModelObject(XModelObject object) {
        }
    }
}

