/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.validator.ui.formset;

import java.util.Set;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultCreateHandler;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.objecteditor.XChildrenEditor;
import org.jboss.tools.common.model.ui.swt.util.BorderLayout;
import org.jboss.tools.common.model.util.AbstractTableHelper;
import org.jboss.tools.common.model.util.FindObjectHelper;
import org.jboss.tools.struts.validator.ui.formset.ActionNames;
import org.jboss.tools.struts.validator.ui.formset.FEditorConstants;
import org.jboss.tools.struts.validator.ui.formset.TH;
import org.jboss.tools.struts.validator.ui.formset.model.FConstantsModel;
import org.jboss.tools.struts.validator.ui.formset.model.FModel;
import org.jboss.tools.struts.validator.ui.formset.model.FormsetsModel;

public class FConstantsEditor
extends XChildrenEditor
implements ActionNames {
    protected FormsetsModel formsetsModel;
    protected FConstantsModel fmodel;

    public FConstantsEditor() {
        this.bar.getLayout().buttonWidth = 80;
    }

    public void dispose() {
        super.dispose();
        if (this.formsetsModel != null) {
            this.formsetsModel.dispose();
        }
        this.formsetsModel = null;
        if (this.fmodel != null) {
            this.fmodel.dispose();
        }
        this.fmodel = null;
    }

    public Control createControl(Composite parent) {
        this.control = new Group(parent, 0);
        BorderLayout bl = new BorderLayout();
        this.control.setLayout((Layout)bl);
        bl.northHeight = 3;
        this.xtable.createControl(this.control);
        bl.centerComposite = this.xtable.getControl();
        this.createCommandBar();
        this.enableSelectionListener();
        this.update();
        return this.control;
    }

    protected AbstractTableHelper createHelper() {
        return new TH();
    }

    public void setFModel(FModel fmodel) {
        if (this.fmodel == fmodel) {
            return;
        }
        this.formsetsModel = fmodel == null ? null : (FormsetsModel)fmodel.getParent();
        this.fmodel = (FConstantsModel)fmodel;
        ((TH)this.helper).setFModel(fmodel);
        this.update();
    }

    protected Color getItemColor(int i) {
        if (this.helper == null || this.fmodel == null) {
            return DEFAULT_COLOR;
        }
        XModelObject o = this.helper.getModelObject(i);
        boolean isInherited = o != null && this.fmodel.isChildInherited(o);
        return isInherited ? FEditorConstants.INHERITED : DEFAULT_COLOR;
    }

    protected void updateBar() {
        boolean enabled = this.fmodel != null && this.fmodel.isEditable();
        XModelObject o = this.helper == null ? null : this.helper.getModelObject(this.xtable.getSelectionIndex());
        this.bar.setEnabled(ActionNames.ADD, enabled);
        if (o == null || this.fmodel == null) {
            this.bar.rename(DEFAULT, ActionNames.DELETE);
            this.bar.setEnabled(ActionNames.DELETE, false);
            this.bar.rename(OVERWRITE, ActionNames.EDIT);
            this.bar.setEnabled(ActionNames.EDIT, false);
            return;
        }
        boolean inh = this.fmodel.isChildInherited(o);
        boolean ovr = this.fmodel.isChildOverriding(o);
        if (inh) {
            this.bar.rename(ActionNames.EDIT, OVERWRITE);
        } else {
            this.bar.rename(OVERWRITE, ActionNames.EDIT);
        }
        if (ovr) {
            this.bar.rename(ActionNames.DELETE, DEFAULT);
        } else {
            this.bar.rename(DEFAULT, ActionNames.DELETE);
        }
        this.bar.setEnabled(ActionNames.DELETE, !inh && enabled);
        this.bar.setEnabled(DEFAULT, !inh && enabled);
        this.bar.setEnabled(ActionNames.EDIT, enabled);
        this.bar.setEnabled(OVERWRITE, enabled);
    }

    public void action(String name) {
        if (name.equals(ActionNames.ADD)) {
            this.actionAdd();
        } else {
            XModelObject o = this.helper.getModelObject(this.xtable.getSelectionIndex());
            if (o == null) {
                return;
            }
            if (name.equals(ActionNames.DELETE)) {
                this.callAction(o, "DeleteActions.Delete");
            } else if (name.equals(ActionNames.EDIT)) {
                this.callAction(o, "Properties.Properties");
            } else if (name.equals(OVERWRITE)) {
                try {
                    this.executeOverwrite();
                }
                catch (XModelException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            } else if (name.equals(DEFAULT)) {
                this.callAction(o, "DeleteActions.ResetDefault");
            }
        }
    }

    private void actionAdd() {
        XModelObject[] fs = this.formsetsModel.getCurrentFormsets();
        if (fs.length == 0) {
            return;
        }
        Set set = this.getKeys();
        this.callAction(fs[0], "CreateActions.AddConstant");
        this.update();
        int i = this.getAddedKey(set);
        if (i >= 0) {
            this.xtable.setSelection(i);
        }
    }

    protected void executeOverwrite() throws XModelException {
        if (this.helper == null || this.fmodel == null) {
            return;
        }
        XModelObject o = this.helper.getModelObject(this.xtable.getSelectionIndex());
        if (o == null) {
            return;
        }
        XModelObject[] os = this.fmodel.getParent().getModelObjects();
        if (os.length == 0) {
            return;
        }
        XModelObject copy = o.copy(0);
        long q = copy.getTimeStamp();
        XActionInvoker.invoke((String)"SVWAddConstant", (String)"Edit", (XModelObject)copy, null);
        if (q == copy.getTimeStamp()) {
            return;
        }
        DefaultCreateHandler.addCreatedObject((XModelObject)os[0], (XModelObject)copy, (int)FindObjectHelper.IN_EDITOR_ONLY);
    }
}

