/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.validator.ui.formset;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.struts.validator.ui.Messages;
import org.jboss.tools.struts.validator.ui.ValidatorAttributeEditor;
import org.jboss.tools.struts.validator.ui.formset.FEditorConstants;
import org.jboss.tools.struts.validator.ui.formset.model.FModel;
import org.jboss.tools.struts.validator.ui.formset.model.FieldModel;

abstract class FieldAttributeEditor
extends ValidatorAttributeEditor {
    static String EDIT = Messages.FieldEditor_Edit;
    static String OVERWRITE = Messages.FieldEditor_Override;
    static String DEFAULT = Messages.FieldEditor_Default;
    protected FieldModel fmodel = null;
    protected boolean enabled = true;
    protected int status = 0;
    protected String displayName;
    Label label;
    protected Text text;

    public FieldAttributeEditor(String name, String displayName, String command) {
        super(name, new String[]{EDIT}, new String[]{command});
        this.displayName = displayName;
    }

    public void setFModel(FModel fmodel) {
        if (this.fmodel == fmodel) {
            return;
        }
        this.fmodel = (FieldModel)fmodel;
        this.update();
    }

    public void update() {
        this.text.setText(this.getText());
        int s = this.getStatus();
        if (s == this.status) {
            return;
        }
        this.status = s;
        if (s == FieldModel.INHERITED) {
            this.text.setForeground(FEditorConstants.INHERITED);
        } else {
            this.text.setForeground(FEditorConstants.DEFAULT_COLOR);
        }
        if (s == FieldModel.DEFINED) {
            this.bar.setCommands(new String[]{EDIT});
        } else if (s == FieldModel.OVERWRITTEN) {
            this.bar.setCommands(new String[]{EDIT, DEFAULT});
        } else {
            this.bar.setCommands(new String[]{OVERWRITE});
        }
        this.bar.update();
        this.bar.getControl().getParent().layout();
    }

    public void setEnabled(boolean b) {
        this.enabled = this.fmodel != null && this.fmodel.isEditable();
        int s = this.getStatus();
        if (s == FieldModel.DEFINED) {
            this.bar.setEnabled(EDIT, this.enabled);
        } else if (s == FieldModel.OVERWRITTEN) {
            this.bar.setEnabled(EDIT, this.enabled);
            this.bar.setEnabled(DEFAULT, this.enabled);
            this.bar.setCommands(new String[]{EDIT, DEFAULT});
        } else {
            this.bar.setEnabled(OVERWRITE, this.enabled);
        }
    }

    public void action(String name) {
        if (OVERWRITE.equals(name)) {
            this.overwrite();
        } else if (DEFAULT.equals(name)) {
            this.setDefault();
        } else if (EDIT.equals(name)) {
            this.edit();
        }
    }

    public XModelObject getModelObject() {
        if (this.fmodel == null) {
            return null;
        }
        XModelObject[] os = this.fmodel.getModelObjects();
        return os.length == 0 ? null : os[0];
    }

    public Control createControl(Composite parent) {
        this.control = new Composite(parent, 0);
        GridLayout gl = new GridLayout(3, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        this.control.setLayout((Layout)gl);
        this.label = new Label(this.control, 0);
        this.label.setText(this.displayName);
        GridData gd = new GridData(32);
        gd.widthHint = LABEL_WIDTH;
        this.label.setLayoutData((Object)gd);
        this.text = new Text(this.control, 2056);
        this.text.setBackground(new Color(null, 255, 255, 255));
        gd = new GridData(768);
        this.text.setLayoutData((Object)gd);
        this.bar.createControl(this.control);
        gd = new GridData(128);
        this.bar.getControl().setLayoutData((Object)gd);
        return this.control;
    }

    protected abstract String getText();

    protected abstract int getStatus();

    protected abstract void setDefault();

    protected abstract void overwrite();

    protected void edit() {
        XModelObject o = this.getModelObject();
        if (o != null) {
            this.invoke(this.commands[0], o);
        }
    }
}

