/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.validator.ui.formset;

import java.util.Properties;
import java.util.Set;
import org.eclipse.swt.graphics.Color;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultCreateHandler;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.ui.objecteditor.XChildrenEditor;
import org.jboss.tools.common.model.util.FindObjectHelper;
import org.jboss.tools.struts.validator.ui.formset.ActionNames;
import org.jboss.tools.struts.validator.ui.formset.FEditorConstants;
import org.jboss.tools.struts.validator.ui.formset.FieldDataTableHelper;
import org.jboss.tools.struts.validator.ui.formset.model.DependencyModel;
import org.jboss.tools.struts.validator.ui.formset.model.FModel;

public abstract class FieldDataEditor
extends XChildrenEditor
implements ActionNames {
    protected DependencyModel fmodel;

    public FieldDataEditor() {
        this.bar.getLayout().buttonWidth = 70;
    }

    public void dispose() {
        super.dispose();
        if (this.fmodel != null) {
            this.fmodel.dispose();
        }
        this.fmodel = null;
    }

    public void setFModel(FModel fmodel) {
        if (this.fmodel == fmodel) {
            return;
        }
        this.fmodel = (DependencyModel)fmodel;
        this.getFieldDataTableHelper().setFModel(fmodel);
        this.update();
    }

    public FieldDataTableHelper getFieldDataTableHelper() {
        return (FieldDataTableHelper)this.helper;
    }

    protected Color getItemColor(int i) {
        if (this.helper == null || this.fmodel == null) {
            return DEFAULT_COLOR;
        }
        XModelObject o = this.helper.getModelObject(i);
        boolean isInherited = o != null && this.fmodel.isChildInherited(o);
        return isInherited ? FEditorConstants.INHERITED : DEFAULT_COLOR;
    }

    protected void updateBar() {
        XModelObject o;
        boolean enabled = this.helper != null && this.fmodel != null && this.fmodel.isEditable();
        this.bar.setEnabled(ActionNames.ADD, enabled);
        XModelObject xModelObject = o = this.helper == null ? null : this.helper.getModelObject(this.xtable.getSelectionIndex());
        if (o == null || this.fmodel == null) {
            this.bar.rename(DEFAULT, ActionNames.DELETE);
            this.bar.setEnabled(ActionNames.DELETE, false);
            this.bar.rename(OVERWRITE, ActionNames.EDIT);
            this.bar.setEnabled(ActionNames.EDIT, false);
            return;
        }
        boolean inh = this.fmodel.isChildInherited(o);
        boolean ovr = this.fmodel.isChildOverriding(o);
        if (inh) {
            this.bar.rename(ActionNames.EDIT, OVERWRITE);
        } else {
            this.bar.rename(OVERWRITE, ActionNames.EDIT);
        }
        if (ovr) {
            this.bar.rename(ActionNames.DELETE, DEFAULT);
        } else {
            this.bar.rename(DEFAULT, ActionNames.DELETE);
        }
        this.bar.setEnabled(ActionNames.DELETE, enabled);
        this.bar.setEnabled(DEFAULT, enabled);
        this.bar.setEnabled(ActionNames.EDIT, enabled);
        this.bar.setEnabled(OVERWRITE, enabled);
    }

    public void action(String name) {
        if (name.equals(ActionNames.ADD)) {
            this.add();
        } else {
            XModelObject o = this.helper.getModelObject(this.xtable.getSelectionIndex());
            if (o == null) {
                return;
            }
            if (name.equals(ActionNames.EDIT)) {
                this.executeEdit(o);
            } else if (name.equals(OVERWRITE)) {
                try {
                    this.executeOverwrite();
                }
                catch (XModelException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            } else if (name.equals(ActionNames.DELETE)) {
                this.callAction(o, "DeleteActions.Delete");
            } else if (name.equals(DEFAULT)) {
                this.callAction(o, "DeleteActions.ResetDefault");
            }
        }
    }

    protected void add() {
        Set set = this.getKeys();
        this.executeAdd();
        this.update();
        int i = this.getAddedKey(set);
        if (i >= 0) {
            this.xtable.setSelection(i);
        }
    }

    protected void executeAdd() {
    }

    protected void executeEdit(XModelObject o) {
        this.callAction(o, "Properties.Properties");
    }

    protected void executeOverwrite() throws XModelException {
        if (this.helper == null || this.fmodel == null) {
            return;
        }
        XModelObject o = this.helper.getModelObject(this.xtable.getSelectionIndex());
        if (o == null) {
            return;
        }
        FModel pf = this.fmodel.getParent();
        XModelObject[] targets = FieldDataEditor.getTarget(pf);
        if (targets == null) {
            return;
        }
        XModelObject target = targets[0];
        XModelObject po = targets[1];
        XModelObject co = targets[2];
        XModelObject copy = o.copy();
        String name = copy.getAttributeValue("name");
        if (name != null && name.length() == 0 && this.fmodel.getName().length() > 0) {
            copy.setAttributeValue("name", this.fmodel.getName());
        }
        long q = copy.getTimeStamp();
        this.executeEdit(copy);
        if (q == copy.getTimeStamp()) {
            return;
        }
        if (po != null) {
            target.addChild(copy);
            DefaultCreateHandler.addCreatedObject((XModelObject)po, (XModelObject)co, (int)FindObjectHelper.IN_EDITOR_ONLY);
        } else {
            DefaultCreateHandler.addCreatedObject((XModelObject)target, (XModelObject)copy, (int)FindObjectHelper.IN_EDITOR_ONLY);
        }
    }

    protected void executeAdd(String entity, String actionpath, Properties p) {
        if (this.helper == null || this.fmodel == null) {
            return;
        }
        FModel pf = this.fmodel instanceof DependencyModel ? this.fmodel.getParent() : this.fmodel;
        XModelObject[] targets = FieldDataEditor.getTarget(pf);
        if (targets == null) {
            return;
        }
        XModelObject target = targets[0];
        XModelObject po = targets[1];
        XModelObject co = targets[2];
        long ts = target.getTimeStamp();
        if (p == null) {
            p = new Properties();
        }
        p.put("shell", this.bar.getControl().getShell());
        if (entity != null) {
            XActionInvoker.invoke((String)entity, (String)actionpath, (XModelObject)target, (Properties)p);
        } else {
            XActionInvoker.invoke((String)actionpath, (XModelObject)target, (Properties)p);
        }
        if (ts == target.getTimeStamp()) {
            return;
        }
        if (po != null && co != null) {
            try {
                DefaultCreateHandler.addCreatedObject((XModelObject)po, (XModelObject)co, (int)FindObjectHelper.IN_EDITOR_ONLY);
            }
            catch (XModelException e) {
                ModelPlugin.getPluginLog().logError((Throwable)e);
            }
        }
    }

    static XModelObject[] getTarget(FModel pf) {
        XModelObject[] os = pf.getModelObjects();
        if (os.length == 0) {
            return null;
        }
        if (!pf.isInherited()) {
            XModelObject[] xModelObjectArray = new XModelObject[3];
            xModelObjectArray[0] = os[0];
            return xModelObjectArray;
        }
        if (!pf.getParent().isInherited()) {
            XModelObject[] pos = pf.getParent().getModelObjects();
            if (pos.length == 0) {
                return null;
            }
            XModelObject pcopy = os[0].copy(0);
            return new XModelObject[]{pcopy, pos[0], pcopy};
        }
        XModelObject[] gos = pf.getParent().getParent().getModelObjects();
        if (gos.length == 0) {
            return null;
        }
        XModelObject[] pos = pf.getParent().getModelObjects();
        if (pos.length == 0) {
            return null;
        }
        XModelObject pcopy = os[0].copy(0);
        XModelObject gcopy = pos[0].copy(0);
        gcopy.addChild(pcopy);
        return new XModelObject[]{pcopy, gos[0], gcopy};
    }
}

