/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.validator.ui.formset;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.jboss.tools.common.editor.AbstractSelectionProvider;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.dnd.ControlDragDrop;
import org.jboss.tools.common.model.ui.dnd.IControlDragDropProvider;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.struts.validator.ui.XStudioValidatorPlugin;
import org.jboss.tools.struts.validator.ui.formset.FEditorConstants;
import org.jboss.tools.struts.validator.ui.formset.FSelectionListener;
import org.jboss.tools.struts.validator.ui.formset.FormsEditorDrop;
import org.jboss.tools.struts.validator.ui.formset.MenuInvoker;
import org.jboss.tools.struts.validator.ui.formset.model.FModel;
import org.jboss.tools.struts.validator.ui.formset.model.FormsetsModel;

public class FormsEditor {
    protected TreeViewer treeViewer;
    protected FormsetsModel formsetsModel = null;
    protected FSelectionListener[] selectionListeners = new FSelectionListener[2];
    WorkbenchContentProvider treeContent = new FormsetsTreeContent();
    LabelProvider treeLabel = new FormsetsTreeLabel();
    protected MenuInvoker menu = null;
    FormsEditorDrop dndProvider = new FormsEditorDrop();
    ControlDragDrop dnd = new ControlDragDrop();
    AbstractSelectionProvider selectionProvider = new SP();

    public FormsEditor() {
        this.dnd.setProvider((IControlDragDropProvider)this.dndProvider);
    }

    public void registerMenu(MenuInvoker menu) {
        this.menu = menu;
    }

    public Control createControl(Composite parent) {
        this.treeViewer = new TreeViewer(parent, 2820);
        this.treeViewer.setContentProvider((IContentProvider)this.treeContent);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.treeLabel);
        this.treeViewer.getTree().addSelectionListener((SelectionListener)new TS());
        if (this.formsetsModel != null) {
            this.treeViewer.setInput((Object)this);
        }
        this.menu.setViewer(this.treeViewer);
        this.dndProvider.setTreeViewer(this.treeViewer);
        this.dnd.enableDrop();
        this.dnd.enableDrag();
        return this.treeViewer.getTree();
    }

    public Control getControl() {
        return this.treeViewer.getTree();
    }

    public void addListener(FSelectionListener selectionListener) {
        int i = this.selectionListeners[0] == null ? 0 : 1;
        this.selectionListeners[i] = selectionListener;
    }

    public void setFormsetsModel(FormsetsModel formsetsModel) {
        this.formsetsModel = formsetsModel;
        if (this.treeViewer != null && !this.treeViewer.getTree().isDisposed()) {
            this.treeViewer.setInput((Object)formsetsModel);
        }
    }

    public void setObject(XModelObject object) {
        this.reloadTree();
    }

    protected void reloadTree() {
        if (this.treeViewer.getTree() == null || this.treeViewer.getTree().isDisposed()) {
            return;
        }
        this.treeViewer.refresh();
    }

    void updateTree(FModel source) {
        FModel s = this.getSelectedFModel();
        this.treeViewer.refresh((Object)source);
        if (s != null) {
            this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)s), true);
        }
    }

    private FModel toFModel(Object o) {
        return !(o instanceof FModel) ? null : (FModel)o;
    }

    public FModel getSelectedFModel() {
        TreeItem[] ti = null;
        try {
            ti = this.treeViewer.getTree().getSelection();
        }
        catch (Exception ex) {
            XStudioValidatorPlugin.getPluginLog().logError((Throwable)ex);
            return null;
        }
        return ti == null || ti.length == 0 ? null : this.toFModel(ti[0].getData());
    }

    public void select(FModel m) {
        this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)m), true);
        this.updateSelection();
    }

    void updateSelection() {
        FModel f = this.getSelectedFModel();
        int i = 0;
        while (i < this.selectionListeners.length) {
            if (this.selectionListeners[i] != null) {
                this.selectionListeners[i].setSelected(f);
            }
            ++i;
        }
        this.selectionProvider.fireSelectionChanged();
    }

    String getSelectionPath() {
        FModel f = this.getSelectedFModel();
        return f == null ? null : f.getPath();
    }

    void setSelectionPath(String path) {
    }

    public ISelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    class FormsetsTreeContent
    extends WorkbenchContentProvider {
        FormsetsTreeContent() {
        }

        public Object[] getChildren(Object element) {
            FModel f = FormsEditor.this.toFModel(element);
            if (f == null) {
                return new Object[0];
            }
            Object[] os = new Object[f.getChildCount()];
            int i = 0;
            while (i < os.length) {
                os[i] = f.getChildAt(i);
                ++i;
            }
            return os;
        }

        public Object[] getElements(Object element) {
            Object[] objectArray;
            if (FormsEditor.this.formsetsModel == null) {
                objectArray = new Object[]{};
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = FormsEditor.this.formsetsModel;
            }
            return objectArray;
        }

        public Object getParent(Object element) {
            FModel f = FormsEditor.this.toFModel(element);
            return f == null ? null : f.getParent();
        }

        public boolean hasChildren(Object element) {
            FModel f = FormsEditor.this.toFModel(element);
            return f != null && f.getChildCount() > 0;
        }
    }

    class FormsetsTreeLabel
    extends LabelProvider
    implements IColorProvider {
        FormsetsTreeLabel() {
        }

        public Image getImage(Object element) {
            FModel f = FormsEditor.this.toFModel(element);
            XModelObject o = f == null ? null : f.getModelObjectForIcon();
            return o == null ? null : EclipseResourceUtil.getImage((XModelObject)o);
        }

        public String getText(Object element) {
            FModel f = FormsEditor.this.toFModel(element);
            return f == null ? "" : f.toString();
        }

        public Color getForeground(Object element) {
            FModel f = FormsEditor.this.toFModel(element);
            return f != null && f.isInherited() ? FEditorConstants.INHERITED : FEditorConstants.DEFAULT_COLOR;
        }

        public Color getBackground(Object element) {
            return Display.getDefault().getSystemColor(1);
        }
    }

    class SP
    extends AbstractSelectionProvider {
        SP() {
        }

        protected XModelObject getSelectedModelObject() {
            FModel f = FormsEditor.this.getSelectedFModel();
            if (f == null) {
                return null;
            }
            XModelObject[] os = f.getModelObjects();
            return os.length == 0 ? null : os[0];
        }

        protected void setSelectedModelObject(XModelObject object) {
        }
    }

    class TS
    implements SelectionListener {
        TS() {
        }

        public void widgetSelected(SelectionEvent e) {
            FormsEditor.this.updateSelection();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

