/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.validator.ui.formset;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultCreateHandler;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultRemoveHandler;
import org.jboss.tools.common.meta.help.HelpUtil;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.ui.action.CommandBar;
import org.jboss.tools.common.model.ui.action.CommandBarLayout;
import org.jboss.tools.common.model.ui.action.CommandBarListener;
import org.jboss.tools.common.model.undo.XTransactionUndo;
import org.jboss.tools.common.model.undo.XUndoManager;
import org.jboss.tools.common.model.undo.XUndoable;
import org.jboss.tools.common.model.util.FindObjectHelper;
import org.jboss.tools.struts.validator.ui.Messages;
import org.jboss.tools.struts.validator.ui.XStudioValidatorPlugin;
import org.jboss.tools.struts.validator.ui.formset.ActionNames;
import org.jboss.tools.struts.validator.ui.formset.FEditorConstants;
import org.jboss.tools.struts.validator.ui.formset.FSelectionListener;
import org.jboss.tools.struts.validator.ui.formset.FieldDataEditor;
import org.jboss.tools.struts.validator.ui.formset.FormsetsEditor;
import org.jboss.tools.struts.validator.ui.formset.model.DependencyModel;
import org.jboss.tools.struts.validator.ui.formset.model.FModel;
import org.jboss.tools.struts.validator.ui.formset.model.FieldModel;
import org.jboss.tools.struts.validator.ui.formset.model.FormModel;
import org.jboss.tools.struts.validator.ui.formset.model.FormsetsModel;
import org.jboss.tools.struts.validators.model.XModelEntityResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormsetsBar
implements CommandBarListener,
ActionNames,
FSelectionListener {
    static String CREATE = Messages.FormsetsBar_Create;
    static String CREATE_FORMSET = Messages.FormsetsBar_CreateFormset;
    static String DELETE_FORMSET = Messages.FormsetsBar_DeleteFormset;
    static String CREATE_FORM = Messages.FormsetsBar_CreateForm;
    static String CREATE_FIELD = Messages.FormsetsBar_CreateField;
    static String CREATE_DEPEN = Messages.FormsetsBar_AddValidationRule;
    static String[] createActions = new String[]{CREATE, CREATE_FORM, CREATE_FIELD, CREATE_DEPEN, CREATE, CREATE};
    static String HELP = Messages.FormsetsBar_Help;
    protected Composite control;
    protected CommandBar formBar = this.createBar();
    protected FormsetsEditor formsetsEditor = null;
    protected XModelObject root = null;
    protected FModel selected = null;
    protected int selectedStatus = -1;
    protected int inheritanceStatus = -1;
    protected boolean enabled = false;
    static String SEPARATOR = "separator";

    public FormsetsBar() {
        this.setIcons();
    }

    public void dispose() {
        if (this.formBar != null) {
            this.formBar.dispose();
        }
        this.formBar = null;
    }

    public Control createControl(Composite parent) {
        this.control = new Composite(parent, 0);
        this.control.setLayout((Layout)new RowLayout());
        this.formBar.createControl(this.control);
        return this.control;
    }

    public Control getControl() {
        return this.control;
    }

    public void setObject(XModelObject object) {
        this.root = object;
        this.setSelected(this.selected);
    }

    public XModelObject getObject() {
        return this.root;
    }

    private CommandBar createBar() {
        CommandBar c = new CommandBar();
        CommandBarLayout layout = c.getLayout();
        layout.iconsOnly = true;
        layout.asToolBar = true;
        c.setCommands(new String[]{CREATE_FORMSET, DELETE_FORMSET, "_SEPARATOR_", CREATE, EDIT, DELETE});
        c.setEnabled(CREATE_FORMSET, false);
        c.setEnabled(DELETE_FORMSET, false);
        c.setEnabled(CREATE, false);
        c.setEnabled(EDIT, false);
        c.setEnabled(DELETE, false);
        c.addCommandBarListener((CommandBarListener)this);
        return c;
    }

    @Override
    public void setSelected(FModel model) {
        int s;
        boolean enabledChanged = this.updateFramesetEnabled();
        if (!enabledChanged && this.selected == model && this.selectedStatus > -1 && this.inheritanceStatus == this.getInheritanceStatus(model)) {
            return;
        }
        this.selected = model;
        this.updateInheritance();
        int n = this.selected == null ? 0 : (this.selected instanceof FormsetsModel ? 1 : (this.selected instanceof FormModel ? 2 : (this.selected instanceof FieldModel ? 3 : (s = this.selected instanceof DependencyModel ? 4 : 5))));
        if (enabledChanged || this.selectedStatus != s) {
            if (this.selectedStatus < 0) {
                this.selectedStatus = 0;
            }
            this.formBar.rename(createActions[this.selectedStatus], createActions[s]);
            this.selectedStatus = s;
            boolean e = !CREATE.equals(createActions[s]) && this.enabled;
            this.formBar.setEnabled(createActions[s], e);
            this.formBar.setEnabled(EDIT, e);
            this.formBar.setEnabled(OVERWRITE, e);
            this.formBar.setEnabled(DELETE, s > 0 && s < 5 && this.enabled);
            this.formBar.setEnabled(DEFAULT, s > 0 && s < 5 && this.enabled);
        }
    }

    private int getInheritanceStatus(FModel model) {
        return model == null ? 0 : (model.isInherited() ? 1 : (model.isOverriding() ? 2 : 0));
    }

    private void updateInheritance() {
        this.updateInheritance(this.updateFramesetEnabled());
    }

    private void updateInheritance(boolean enabledChanged) {
        if (this.hasNoFormsets()) {
            return;
        }
        int is = this.getInheritanceStatus(this.selected);
        if (!enabledChanged && this.inheritanceStatus == is) {
            return;
        }
        this.inheritanceStatus = is;
        if (is == 1) {
            this.formBar.rename(EDIT, OVERWRITE);
        } else {
            this.formBar.rename(OVERWRITE, EDIT);
        }
        if (is == 2) {
            this.formBar.rename(DELETE, DEFAULT);
            this.formBar.setEnabled(DEFAULT, true);
        } else {
            this.formBar.rename(DEFAULT, DELETE);
            this.formBar.setEnabled(DELETE, is != 1);
        }
    }

    public void action(String name) {
        if (name.equals(CREATE_FORMSET)) {
            this.createFormset();
        } else if (this.isCreateAction(name)) {
            FModel m = this.selected;
            Set<String> s = this.getCurrentChildren(m);
            if (name.equals(CREATE_FORM)) {
                this.createForm();
            } else if (name.equals(CREATE_FIELD)) {
                this.createField();
            } else if (name.equals(CREATE_DEPEN)) {
                this.createDependency();
            }
            this.select(this.getNew(s, m));
        } else if (name.equals(DELETE_FORMSET)) {
            this.deleteFormset();
        } else if (name.equals(DELETE)) {
            FModel m = this.selected == null ? null : this.selected.getParent();
            this.deleteObject(false);
            if (m != null && m.getChild(this.selected.getName()) == null) {
                this.select(m);
            }
        } else if (name.equals(DEFAULT)) {
            this.deleteObject(true);
        } else if (name.equals(EDIT)) {
            this.editObject();
        } else if (name.equals(OVERWRITE)) {
            this.overwriteObject();
        } else if (name.equals(HELP)) {
            this.help();
        }
    }

    private boolean isCreateAction(String name) {
        return CREATE_FORM.equals(name) || CREATE_FIELD.equals(name) || CREATE_DEPEN.equals(name);
    }

    private void select(FModel m) {
        if (m != null) {
            this.formsetsEditor.formsEditor.select(m);
        }
    }

    private Set<String> getCurrentChildren(FModel m) {
        HashSet<String> s = new HashSet<String>();
        if (m != null) {
            int i = 0;
            while (i < m.getChildCount()) {
                s.add(m.getChildAt(i).toString());
                ++i;
            }
        }
        return s;
    }

    private FModel getNew(Set s, FModel m) {
        if (m == null || m.getChildCount() != s.size() + 1) {
            return null;
        }
        if (m != null) {
            int i = 0;
            while (i < m.getChildCount()) {
                FModel c = m.getChildAt(i);
                if (!s.contains(c.toString())) {
                    return c;
                }
                ++i;
            }
        }
        return null;
    }

    private void setIcons() {
        this.formBar.setImage(CREATE_FORMSET, FEditorConstants.IMAGE_CREATE_FORMSET);
        this.formBar.setImage(DELETE_FORMSET, FEditorConstants.IMAGE_DELETE);
        this.formBar.setImage(CREATE, FEditorConstants.IMAGE_CREATE);
        this.formBar.setImage(EDIT, FEditorConstants.IMAGE_EDIT);
        this.formBar.setImage(DELETE, FEditorConstants.IMAGE_DELETE);
    }

    private void help() {
        if (this.selected == null) {
            return;
        }
        try {
            HelpUtil.helpEclipse((XModel)this.selected.getModel(), (String)this.selected.getKey());
        }
        catch (Exception e) {
            XStudioValidatorPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    private void createFormset() {
        this.invoke("CreateActions.AddFormset", this.root);
    }

    private void deleteFormset() {
        XModelObject[] os = this.formsetsEditor.getFormsetsModel().getCurrentFormsets();
        this.deleteObject(os, false);
    }

    private void createForm() {
        XModelObject[] os = this.formsetsEditor.getFormsetsModel().getCurrentFormsets();
        if (os.length > 0) {
            this.invoke("CreateActions.AddForm", os[0]);
        }
    }

    private void createField() {
        XModelObject[] fs = this.formsetsEditor.getFormsetsModel().getCurrentFormsets();
        if (this.selected == null) {
            return;
        }
        XModelObject[] os = this.selected.getModelObjects();
        int i = 0;
        while (i < os.length) {
            XModelObject o;
            if (this.isCurrent(fs, os[i]) && (o = this.getAncestor(os[i], "ValidationForm")) != null) {
                this.invoke("CreateActions.AddField", o);
                return;
            }
            ++i;
        }
    }

    private XModelObject getAncestor(XModelObject o, String entity) {
        while (o != null && !o.getModelEntity().getName().startsWith(entity)) {
            o = o.getParent();
        }
        return o;
    }

    private void createDependency() {
        XModelObject[] fs = this.formsetsEditor.getFormsetsModel().getCurrentFormsets();
        if (this.selected == null) {
            return;
        }
        XModelObject[] os = this.selected.getModelObjects();
        int i = 0;
        while (i < os.length) {
            XModelObject o;
            if (this.isCurrent(fs, os[i]) && (o = this.getAncestor(os[i], "ValidationField")) != null) {
                Properties p = new Properties();
                p.setProperty("help", "Wizard_Validation_Dependency");
                p.put("shell", this.formBar.getControl().getShell());
                XActionInvoker.invoke((String)"ValidationDependencyHelper", (String)"CreateActions.AddDependency", (XModelObject)os[i], (Properties)p);
                return;
            }
            ++i;
        }
    }

    private boolean isCurrent(XModelObject[] fs, XModelObject o) {
        String op = o.getPath();
        if (op == null) {
            return false;
        }
        int i = 0;
        while (i < fs.length) {
            if (fs[i].getPath() != null && op.startsWith(fs[i].getPath())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void deleteObject(boolean isOverriding) {
        XModelObject[] fs = this.formsetsEditor.getFormsetsModel().getCurrentFormsets();
        if (this.selected instanceof DependencyModel) {
            this.deleteDependency(fs, this.selected);
        } else {
            XModelObject[] os = this.selected.getModelObjects();
            ArrayList<XModelObject> l = new ArrayList<XModelObject>();
            int i = 0;
            while (i < os.length) {
                if (this.isCurrent(fs, os[i])) {
                    l.add(os[i]);
                }
                ++i;
            }
            os = l.toArray(new XModelObject[0]);
            this.deleteObject(os, isOverriding);
        }
        this.updateInheritance();
    }

    private void deleteObject(XModelObject[] os, boolean isOverriding) {
        String action;
        if (os.length == 0) {
            return;
        }
        String string = action = isOverriding ? "DeleteActions.ResetDefault" : "DeleteActions.Delete";
        if (os.length == 1) {
            this.invoke(action, os[0]);
            return;
        }
        XUndoManager undo = os[0].getModel().getUndoManager();
        XTransactionUndo u = new XTransactionUndo(os[0].getPresentationString(), 2);
        undo.addUndoable((XUndoable)u);
        try {
            try {
                this.invoke(action, os[0]);
                if (os[0].isActive()) {
                    undo.rollbackTransactionInProgress();
                } else {
                    int i = 1;
                    while (i < os.length) {
                        if (os[i].isActive()) {
                            DefaultRemoveHandler.removeFromParent((XModelObject)os[i]);
                        }
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                XStudioValidatorPlugin.getPluginLog().logError((Throwable)e);
                undo.rollbackTransactionInProgress();
                u.commit();
            }
        }
        finally {
            u.commit();
        }
    }

    private void editObject() {
        XModelObject[] fs = this.formsetsEditor.getFormsetsModel().getCurrentFormsets();
        XModelObject[] os = this.selected.getModelObjects();
        int i = 0;
        while (i < os.length) {
            if (this.isCurrent(fs, os[i])) {
                this.invoke("Properties.Properties", os[i]);
                return;
            }
            ++i;
        }
    }

    private void overwriteObject() {
        XModelObject[] targets = FieldDataEditor.getTarget(this.selected);
        if (targets != null && targets[1] != null) {
            try {
                DefaultCreateHandler.addCreatedObject((XModelObject)targets[1], (XModelObject)targets[2], (int)FindObjectHelper.IN_EDITOR_ONLY);
            }
            catch (XModelException e) {
                ModelPlugin.getPluginLog().logError((Throwable)e);
            }
        }
        this.updateInheritance();
    }

    private void deleteDependency(XModelObject[] fs, FModel f) {
        XModelObject[] os = f.getParent().getModelObjects();
        if (os.length == 0) {
            return;
        }
        Properties p = new Properties();
        p.setProperty("dependency name", f.getName());
        XActionInvoker.invoke((String)"ValidationDependencyHelper", (String)"DeleteActions.Delete", (XModelObject)os[0], (Properties)p);
    }

    private void invoke(String actionpath, XModelObject object) {
        XActionInvoker.invoke((String)actionpath, (XModelObject)object, null);
    }

    public String[] getMenu() {
        String edit;
        ArrayList<String> l = new ArrayList<String>();
        if (this.selectedStatus >= 0 && !createActions[this.selectedStatus].equals(CREATE) && this.addToMenu(l, createActions[this.selectedStatus])) {
            l.add(SEPARATOR);
        }
        String string = edit = this.inheritanceStatus == 1 ? OVERWRITE : EDIT;
        if (this.addToMenu(l, edit)) {
            l.add(SEPARATOR);
        }
        String delete = this.inheritanceStatus == 2 ? DEFAULT : DELETE;
        this.addToMenu(l, delete);
        return l.toArray(new String[0]);
    }

    private boolean addToMenu(ArrayList<String> menu, String command) {
        boolean b = this.formBar.isEnabled(command);
        if (b) {
            menu.add(command);
        }
        return b;
    }

    private boolean updateFramesetEnabled() {
        boolean e;
        boolean bl = e = this.root != null && this.root.isObjectEditable();
        if (this.hasNoFormsets()) {
            if (!this.enabled && !e) {
                return false;
            }
            this.enabled = false;
            this.formBar.setEnabled(CREATE_FORMSET, e);
            this.formBar.setEnabled(DELETE_FORMSET, false);
            return true;
        }
        if (e != this.enabled) {
            this.enabled = e;
            this.formBar.setEnabled(CREATE_FORMSET, this.enabled);
            this.formBar.setEnabled(DELETE_FORMSET, this.enabled);
            return true;
        }
        return false;
    }

    private boolean hasNoFormsets() {
        XModelObject[] xmos;
        return this.root != null && (xmos = XModelEntityResolver.getResolvedChildren((XModelObject)this.root, (String)"ValidationFormset")).length == 0;
    }
}

