/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.validator.ui.formset;

import java.util.HashSet;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.struts.validator.ui.DefaultComboModel;
import org.jboss.tools.struts.validator.ui.XStudioValidatorPlugin;
import org.jboss.tools.struts.validator.ui.formset.ActionNames;
import org.jboss.tools.struts.validator.ui.formset.FormsetsEditor;

public class LanguageEditor
implements SelectionListener,
ActionNames {
    protected Composite control;
    protected ComboModel combomodel = new ComboModel();
    protected Combo combo;
    protected FormsetsEditor formsetsEditor = null;
    protected boolean lock = false;

    public Control createControl(Composite parent) {
        this.control = new Composite(parent, 0);
        this.control.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(this.control, 0);
        label.setText("Language/Country");
        this.combo = new Combo(this.control, 12);
        this.combomodel.setCombo(this.combo);
        this.combo.addSelectionListener((SelectionListener)this);
        return this.control;
    }

    public Control getControl() {
        return this.control;
    }

    public void update() {
        boolean _isBoxEnabled;
        if (this.combo == null || this.combo.isDisposed()) {
            return;
        }
        if (this.lock) {
            return;
        }
        this.lock = true;
        Object[] ls = this.formsetsEditor.formsetsModel.getDistinctFormsets();
        XModelObject lc = (XModelObject)this.getNewItem(ls, this.combomodel);
        if (lc == null) {
            lc = (XModelObject)this.combomodel.getSelectedItem();
        }
        if (this.isChanged(ls, this.combomodel)) {
            lc = (XModelObject)this.setBoxValues(ls, this.combomodel, lc);
        } else {
            this.combomodel.refresh();
        }
        if (lc != null) {
            this.formsetsEditor.formsetsModel.setLanguage(lc.getAttributeValue("language"), lc.getAttributeValue("country"));
        }
        boolean bl = _isBoxEnabled = ls.length > 1 || ls.length == 1 && (ls[0].getAttributeValue("language").length() > 0 || ls[0].getAttributeValue("country").length() > 0);
        if (_isBoxEnabled != this.control.isVisible() || !this.control.getParent().isVisible()) {
            this.control.setVisible(_isBoxEnabled);
            this.control.setEnabled(_isBoxEnabled);
            this.control.getParent().getParent().layout();
            this.control.getParent().redraw();
        }
        this.lock = false;
    }

    private Object getNewItem(Object[] ls, ComboModel combomodel) {
        int sz;
        block6: {
            sz = combomodel.getSize();
            if (sz < ls.length) break block6;
            return null;
        }
        try {
            HashSet<String> set = new HashSet<String>();
            int i = 0;
            while (i < sz) {
                set.add(combomodel.getElementAt(i).toString());
                ++i;
            }
            i = 0;
            while (i < ls.length) {
                if (!set.contains(ls[i].toString())) {
                    return ls[i];
                }
                ++i;
            }
        }
        catch (Exception e) {
            XStudioValidatorPlugin.getPluginLog().logError((Throwable)e);
        }
        return null;
    }

    private boolean isChanged(Object[] vs, ComboModel combomodel) {
        if (combomodel.getSize() != vs.length) {
            return true;
        }
        int i = 0;
        while (i < vs.length) {
            if (vs[i] != combomodel.getElementAt(i)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Object setBoxValues(Object[] vs, ComboModel combomodel, Object selected) {
        boolean e = false;
        combomodel.removeAllElements();
        int i = 0;
        while (i < vs.length) {
            if (vs[i] == selected) {
                e = true;
            }
            combomodel.addElement(vs[i]);
            ++i;
        }
        if (!e) {
            Object object = selected = vs.length > 0 ? vs[0] : null;
        }
        if (selected != null) {
            combomodel.setSelectedItem(selected);
        }
        return selected;
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.lock) {
            return;
        }
        this.update();
        this.lock = false;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    class ComboModel
    extends DefaultComboModel {
        ComboModel() {
        }

        public String getPresentation(Object object) {
            if (!(object instanceof XModelObject)) {
                return super.getPresentation(object);
            }
            XModelObject o = (XModelObject)object;
            String lg = o.getAttributeValue("language");
            String ct = o.getAttributeValue("country");
            return lg.length() + ct.length() == 0 ? "default" : String.valueOf(lg) + "_" + ct;
        }
    }
}

