/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.validator.ui.formset.model;

import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.struts.validator.ui.XStudioValidatorPlugin;

public class FModel {
    protected FModel parent = null;
    protected String name = "";
    protected XModelObject[] objects = new XModelObject[0];
    protected FModel[] children = new FModel[0];
    protected boolean isInherited = false;
    protected boolean isInheriting = false;
    protected XModelObject fake = null;

    public void dispose() {
    }

    public static FModel createInstance(Class c, FModel parent, String name) {
        FModel f = null;
        try {
            f = (FModel)c.newInstance();
        }
        catch (Exception e) {
            XStudioValidatorPlugin.getPluginLog().logError((Throwable)e);
        }
        f.parent = parent;
        f.name = name;
        return f;
    }

    public XModel getModel() {
        return this.parent == null ? null : this.parent.getModel();
    }

    public boolean isEditable() {
        return this.parent != null && this.parent.isEditable();
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.parent == null ? this.name : String.valueOf(this.parent.getPath()) + "/" + this.name.replace('/', '#');
    }

    public FModel getChild(String name) {
        int i = 0;
        while (i < this.children.length) {
            if (this.children[i].getName().equals(name)) {
                return this.children[i];
            }
            ++i;
        }
        return null;
    }

    public boolean isInherited() {
        return this.isInherited;
    }

    public boolean isOverriding() {
        return !this.isInherited && this.isInheriting;
    }

    public FModel getParent() {
        return this.parent;
    }

    public XModelObject[] getModelObjects() {
        return this.objects;
    }

    public XModelObject getFakeObject() {
        return this.fake;
    }

    public XModelObject getModelObjectForIcon() {
        return this.objects.length == 0 ? this.fake : this.objects[0];
    }

    public int getChildCount() {
        return this.children.length;
    }

    public FModel getChildAt(int i) {
        return this.children[i];
    }

    public void reload() {
    }

    public void fire(FModel source) {
        this.parent.fire(source);
    }

    protected boolean isInherited(XModelObject object) {
        return object == null || this.parent.isInherited(object.getParent());
    }

    public String toString() {
        return this.name;
    }

    public String getKey() {
        return "Validation_Editor_Object";
    }
}

