/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.validator.ui.formset.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.struts.validator.ui.formset.model.FConstantsModel;
import org.jboss.tools.struts.validator.ui.formset.model.FModel;
import org.jboss.tools.struts.validator.ui.formset.model.FModelListener;
import org.jboss.tools.struts.validator.ui.formset.model.FSUtil;
import org.jboss.tools.struts.validator.ui.formset.model.FormModel;
import org.jboss.tools.struts.validators.model.XModelEntityResolver;

public class FormsetsModel
extends FModel {
    protected String language = "";
    protected String country = "";
    protected XModelObject root = null;
    protected FModelListener listener = null;
    protected FModel constants = FModel.createInstance(FConstantsModel.class, this, "Constants");
    protected FModel empty = FModel.createInstance(FModel.class, this, "No one frameset is created");
    protected XModelObject[] distinctFormsets = new XModelObject[0];

    public void dispose() {
        super.dispose();
        this.listener = null;
        if (this.constants != null) {
            this.constants.dispose();
        }
        this.constants = null;
        if (this.empty != null) {
            this.empty.dispose();
        }
        this.empty = null;
    }

    public XModel getModel() {
        return this.root == null ? null : this.root.getModel();
    }

    public void addListener(FModelListener listener) {
        this.listener = listener;
    }

    public int getChildCount() {
        return this.root == null || this.objects.length == 0 ? 0 : this.children.length + 1;
    }

    public FModel getChildAt(int i) {
        return i > 0 ? super.getChildAt(i - 1) : this.constants;
    }

    public XModelObject[] getDistinctFormsets() {
        return this.distinctFormsets;
    }

    public FModel getConstantsModel() {
        return this.constants;
    }

    public String[] getLanguages() {
        if (this.root == null) {
            return new String[0];
        }
        XModelObject[] os = XModelEntityResolver.getResolvedChildren((XModelObject)this.root, (String)"ValidationFormset");
        TreeSet<String> s = new TreeSet<String>();
        int i = 0;
        while (i < os.length) {
            s.add(os[i].getAttributeValue("language"));
            ++i;
        }
        return s.toArray(new String[0]);
    }

    public String[] getCountries(String language) {
        if (this.root == null) {
            return new String[0];
        }
        XModelObject[] os = XModelEntityResolver.getResolvedChildren((XModelObject)this.root, (String)"ValidationFormset");
        TreeSet<String> s = new TreeSet<String>();
        int i = 0;
        while (i < os.length) {
            if (os[i].getAttributeValue("language").equals(language)) {
                s.add(os[i].getAttributeValue("country"));
            }
            ++i;
        }
        return s.toArray(new String[0]);
    }

    public XModelObject[] getCurrentFormsets() {
        ArrayList<XModelObject> list = new ArrayList<XModelObject>();
        int i = 0;
        while (i < this.objects.length) {
            String l = this.objects[i].getAttributeValue("language");
            String c = this.objects[i].getAttributeValue("country");
            if (l.equals(this.language) && c.equals(this.country)) {
                list.add(this.objects[i]);
            }
            ++i;
        }
        return list.toArray(new XModelObject[0]);
    }

    public void setLanguage(String language, String country) {
        if (this.language.equals(language) && this.country.equals(country)) {
            return;
        }
        this.language = language;
        this.country = country;
        this.reload();
    }

    public void setObject(XModelObject root) {
        this.root = root;
        this.reload();
    }

    public boolean isEditable() {
        return this.root != null && this.root.isObjectEditable();
    }

    public XModelObject getModelObject() {
        return this.root;
    }

    public void clear() {
        this.objects = new XModelObject[0];
        this.children = new FModel[0];
        this.fire(this);
    }

    public void reload() {
        if (this.root == null) {
            this.clear();
        } else {
            boolean differ = this.reloadDistinctFormsets();
            XModelObject[] fs = XModelEntityResolver.getResolvedChildren((XModelObject)this.root, (String)"ValidationFormset");
            ArrayList<XModelObject> list = new ArrayList<XModelObject>();
            int i = 0;
            while (i < fs.length) {
                String l = fs[i].getAttributeValue("language");
                String c = fs[i].getAttributeValue("country");
                if ((l.length() <= 0 || l.equals(this.language)) && (c.length() <= 0 || c.equals(this.country))) {
                    list.add(fs[i]);
                }
                ++i;
            }
            Object[] os = list.toArray(new XModelObject[0]);
            Arrays.sort(os, new FSComparator());
            differ |= FSUtil.differ((Object[])this.objects, os);
            this.objects = os;
            this.constants.reload();
            if (differ |= this.reloadForms()) {
                this.fire(this);
            }
        }
    }

    private boolean reloadDistinctFormsets() {
        TreeMap<String, XModelObject> s = new TreeMap<String, XModelObject>();
        XModelObject[] fs = XModelEntityResolver.getResolvedChildren((XModelObject)this.root, (String)"ValidationFormset");
        int i = 0;
        while (i < fs.length) {
            String lc = String.valueOf(fs[i].getAttributeValue("language")) + "_" + fs[i].getAttributeValue("country");
            if (!s.containsKey(lc)) {
                s.put(lc, fs[i]);
            }
            ++i;
        }
        Object[] df = s.values().toArray(new XModelObject[0]);
        boolean differ = FSUtil.differ((Object[])this.distinctFormsets, df);
        if (differ) {
            this.distinctFormsets = df;
        }
        return differ;
    }

    private boolean reloadForms() {
        HashMap<String, FModel> c = new HashMap<String, FModel>();
        int i = 0;
        while (i < this.children.length) {
            c.put(this.children[i].getName(), this.children[i]);
            ++i;
        }
        HashSet<String> q = new HashSet<String>();
        ArrayList<FModel> l2 = new ArrayList<FModel>();
        int i2 = 0;
        while (i2 < this.objects.length) {
            XModelObject[] fs = XModelEntityResolver.getResolvedChildren((XModelObject)this.objects[i2], (String)"ValidationForm");
            int j = 0;
            while (j < fs.length) {
                String n = fs[j].getAttributeValue("name");
                if (!q.contains(n)) {
                    q.add(n);
                    FModel f = (FModel)c.remove(n);
                    if (f == null) {
                        f = FModel.createInstance(FormModel.class, this, n);
                    }
                    f.reload();
                    l2.add(f);
                }
                ++j;
            }
            ++i2;
        }
        boolean differ = FSUtil.differ((Object[])this.children, l2);
        if (differ) {
            this.children = l2.toArray(new FModel[0]);
        }
        return differ;
    }

    public boolean isInherited(XModelObject formset) {
        return !this.language.equals(formset.getAttributeValue("language")) || !this.country.equals(formset.getAttributeValue("country"));
    }

    public void fire(FModel source) {
        if (this.listener != null) {
            this.listener.modelChanged(source);
        }
    }

    public String toString() {
        return this.getModelObjects().length == 0 ? "No one frameset is created" : this.getModelObjects()[0].getPresentationString();
    }

    public String getKey() {
        return "Validation_Editor_Formset";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FSComparator
    implements Comparator<XModelObject> {
        FSComparator() {
        }

        @Override
        public int compare(XModelObject m1, XModelObject m2) {
            int l2;
            int l1 = m1.getAttributeValue("country").length();
            if (l1 != (l2 = m2.getAttributeValue("country").length())) {
                return l1 < l2 ? 1 : -1;
            }
            l1 = m1.getAttributeValue("language").length();
            return l1 < (l2 = m2.getAttributeValue("language").length()) ? 1 : (l1 > l2 ? -1 : 0);
        }

        @Override
        public boolean equals(Object obj) {
            return true;
        }
    }
}

