/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.validator.ui.global;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.event.XModelTreeEvent;
import org.jboss.tools.common.model.ui.action.CommandBar;
import org.jboss.tools.common.model.ui.action.CommandBarListener;
import org.jboss.tools.struts.messages.StrutsUIMessages;
import org.jboss.tools.struts.validator.ui.DefaultComboModel;
import org.jboss.tools.struts.validator.ui.formset.FEditorConstants;
import org.jboss.tools.struts.validator.ui.global.GlobalEditorListener;
import org.jboss.tools.struts.validator.ui.internal.ValidatorCommand;
import org.jboss.tools.struts.validator.ui.internal.ValidatorManager;
import org.jboss.tools.struts.validators.model.XModelEntityResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalEditor
implements SelectionListener,
CommandBarListener {
    protected Composite control;
    protected ComboModel combomodel = new ComboModel();
    protected Combo combo;
    protected CommandBar bar = new CommandBar();
    protected XModelObject root = null;
    protected XModelObject selected = null;
    protected boolean lock = false;
    protected GlobalEditorListener listener = null;

    public void dispose() {
        this.listener = null;
        if (this.combomodel != null) {
            this.combomodel.dispose();
        }
        this.combomodel = null;
        if (this.bar != null) {
            this.bar.dispose();
        }
        this.bar = null;
    }

    public void setObject(XModelObject root) {
        this.root = root;
    }

    public Control createControl(Composite parent) {
        this.control = new Composite(parent, 0);
        GridLayout gl = new GridLayout(5, false);
        gl.marginWidth = 0;
        gl.marginHeight = 3;
        gl.horizontalSpacing = 5;
        gl.verticalSpacing = 0;
        this.control.setLayout((Layout)gl);
        Label label = new Label(this.control, 258);
        GridData gd = new GridData(768);
        gd.horizontalSpan = gl.numColumns;
        label.setLayoutData((Object)gd);
        label = new Label(this.control, 514);
        gd = new GridData();
        gd.horizontalIndent = 2;
        gd.heightHint = 18;
        label.setLayoutData((Object)gd);
        label = new Label(this.control, 0);
        label.setText("Current Global Section");
        this.combo = new Combo(this.control, 12);
        this.combomodel.setCombo(this.combo);
        gd = new GridData();
        gd.widthHint = 65;
        this.combo.setLayoutData((Object)gd);
        label = new Label(this.control, 514);
        gd = new GridData();
        gd.heightHint = 18;
        label.setLayoutData((Object)gd);
        this.createCommadBar();
        label = new Label(this.control, 258);
        gd = new GridData(768);
        gd.horizontalSpan = gl.numColumns;
        label.setLayoutData((Object)gd);
        this.update();
        this.combo.addSelectionListener((SelectionListener)this);
        return this.control;
    }

    protected void createCommadBar() {
        this.bar.getLayout().asToolBar = true;
        this.bar.getLayout().iconsOnly = true;
        this.bar.setCommands(new String[]{StrutsUIMessages.ADD, StrutsUIMessages.DELETE});
        this.bar.setImage(StrutsUIMessages.ADD, FEditorConstants.IMAGE_CREATE);
        this.bar.setImage(StrutsUIMessages.DELETE, FEditorConstants.IMAGE_DELETE);
        this.bar.createControl(this.control);
        this.bar.addCommandBarListener((CommandBarListener)this);
    }

    public Control getControl() {
        return this.control;
    }

    public void addGlobalEditorListener(GlobalEditorListener listener) {
        this.listener = listener;
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.lock) {
            return;
        }
        XModelObject o = (XModelObject)this.combomodel.getSelectedItem();
        if (o == this.selected) {
            return;
        }
        if (this.listener != null) {
            this.selected = o;
            this.listener.setSelected(this.selected);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void update() {
        XModelObject[] cs;
        this.lock = true;
        XModelObject[] xModelObjectArray = cs = this.root == null ? new XModelObject[]{} : XModelEntityResolver.getResolvedChildren((XModelObject)this.root, (String)"ValidationGlobal");
        if (!this.isEqualData(cs)) {
            XModelObject s = (XModelObject)this.combomodel.getSelectedItem();
            this.combomodel.removeAllElements();
            int i = 0;
            while (i < cs.length) {
                this.combomodel.addElement(cs[i]);
                ++i;
            }
            if (s != null && this.combomodel.getIndexOf(s) >= 0) {
                this.combomodel.setSelectedItem(s);
            }
            if (s != this.combomodel.getSelectedItem()) {
                s = null;
            }
            if (s == null && cs.length != 0) {
                s = cs[0];
                this.combomodel.setSelectedItem(s);
            }
            if (this.selected != s) {
                this.selected = s;
                this.listener.setSelected(this.selected);
            }
            this.combo.redraw();
        }
        this.updateCommandsEnabled();
        this.lock = false;
    }

    private boolean isEqualData(XModelObject[] cs) {
        if (this.combomodel.getSize() != cs.length) {
            return false;
        }
        int i = 0;
        while (i < cs.length) {
            if (this.combomodel.getElementAt(i) != cs[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void action(String name) {
        if (this.root == null || !this.root.isActive()) {
            return;
        }
        if (StrutsUIMessages.ADD.equals(name)) {
            Set<Object> set = this.getKeys();
            this.invoke("CreateActions.AddGlobal", this.root);
            Object added = this.getAddedKey(set);
            if (added != null) {
                this.combomodel.setSelectedItem(added);
                this.widgetSelected(null);
            }
        } else if (StrutsUIMessages.DELETE.equals(name) && this.selected != null) {
            this.invoke("DeleteActions.Delete", this.selected);
        }
    }

    private void invoke(String actionname, XModelObject object) {
        XActionInvoker.invoke((String)actionname, (XModelObject)object, null);
    }

    public void structureChanged(XModelTreeEvent event) {
        if (this.root == null) {
            return;
        }
        if (event.kind() == 1) {
            if (this.root != event.getModelObject()) {
                return;
            }
            XModelObject added = (XModelObject)event.getInfo();
            this.combomodel.setSelectedItem(added);
        }
    }

    protected Set<Object> getKeys() {
        HashSet<Object> set = new HashSet<Object>();
        int i = 0;
        while (i < this.combomodel.getSize()) {
            set.add(this.combomodel.getElementAt(i));
            ++i;
        }
        return set;
    }

    protected Object getAddedKey(Set set) {
        int i = 0;
        while (i < this.combomodel.getSize()) {
            Object o = this.combomodel.getElementAt(i);
            if (!set.contains(o)) {
                return o;
            }
            ++i;
        }
        return null;
    }

    public void updateCommandsEnabled() {
        boolean enabled = this.root != null && this.root.isObjectEditable();
        this.bar.setEnabled(StrutsUIMessages.ADD, enabled);
        this.bar.setEnabled(StrutsUIMessages.DELETE, enabled);
    }

    public ValidatorCommand getCommand(int cmd) {
        return ValidatorManager.getDefault().getCommand(cmd, this);
    }

    public void setCommand(int cmd) {
        ValidatorManager.getDefault().setCommand(new ValidatorCommand(cmd, this));
    }

    public boolean isGlobalSelected() {
        return this.selected != null;
    }

    class ComboModel
    extends DefaultComboModel {
        ComboModel() {
        }

        public String getPresentation(Object object) {
            int i;
            if (!(object instanceof XModelObject)) {
                return super.getPresentation(object);
            }
            XModelObject o = (XModelObject)object;
            String s = o.getPresentationString();
            if (this.list.size() > 1 && (i = this.getIndexOf(object)) > 0) {
                s = String.valueOf(s) + " (" + (i + 1) + ")";
            }
            return s;
        }
    }
}

