/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.validator.ui.global;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.ui.swt.util.BorderLayout;
import org.jboss.tools.common.model.ui.swt.util.VerticalFillLayout;
import org.jboss.tools.struts.messages.StrutsUIMessages;
import org.jboss.tools.struts.validator.ui.ValidatorAttributeEditor;

class TextAreaAttributeEditor
extends ValidatorAttributeEditor {
    Label label;
    String displayName;
    Text text;
    int lock = 0;

    public TextAreaAttributeEditor(String name, String displayName) {
        super(name, StrutsUIMessages.CHANGE, null);
        this.displayName = displayName;
    }

    public Control createControl(Composite parent) {
        this.control = new Composite(parent, 0);
        BorderLayout bl = new BorderLayout();
        this.control.setLayout((Layout)bl);
        Composite c = new Composite(this.control, 0);
        bl.northComposite = c;
        VerticalFillLayout vfl = new VerticalFillLayout();
        vfl.leftMargin = 4;
        c.setLayout((Layout)vfl);
        this.label = new Label(c, 0);
        this.label.setText(this.displayName);
        VerticalFillLayout.createSeparator((Composite)c, (int)1);
        this.text = new Text(this.control, 2818);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TextAreaAttributeEditor.this.save();
            }
        });
        this.text.setBackground(new Color(null, 255, 255, 255));
        bl.centerComposite = this.text;
        return this.control;
    }

    public void load() {
        if (this.object == null || this.text == null) {
            return;
        }
        if (this.lock > 0) {
            return;
        }
        ++this.lock;
        try {
            this.text.setText(this.object.getAttributeValue(this.name));
        }
        finally {
            --this.lock;
        }
    }

    public void save() {
        if (this.object == null || this.text == null) {
            return;
        }
        if (this.lock > 0) {
            return;
        }
        ++this.lock;
        try {
            try {
                this.object.getModel().changeObjectAttribute(this.object, this.name, this.text.getText());
            }
            catch (XModelException e) {
                ModelPlugin.getPluginLog().logError((Throwable)e);
                --this.lock;
            }
        }
        finally {
            --this.lock;
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.text != null) {
            this.text.setEditable(enabled);
        }
    }
}

