/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.validator.ui.global;

import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.struts.messages.StrutsUIMessages;
import org.jboss.tools.struts.validator.ui.ValidatorAttributeEditor;

class TextAttributeEditor
extends ValidatorAttributeEditor {
    private static String CHANGE = StrutsUIMessages.CHANGE;
    public static int LABEL_WIDTH = 90;
    Label label;
    String displayName;
    protected Text text;

    public TextAttributeEditor(String name, String displayName, String command) {
        super(name, CHANGE, command);
        this.displayName = displayName;
    }

    public Control createControl(Composite parent) {
        this.control = new Composite(parent, 0);
        GridLayout gl = new GridLayout(3, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        this.control.setLayout((Layout)gl);
        this.label = new Label(this.control, 0);
        this.label.setText(this.displayName);
        GridData gd = new GridData(32);
        gd.widthHint = LABEL_WIDTH;
        this.label.setLayoutData((Object)gd);
        this.text = new Text(this.control, 2048);
        this.text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                TextAttributeEditor.this.save();
            }
        });
        this.text.setBackground(new Color(null, 255, 255, 255));
        gd = new GridData(768);
        this.text.setLayoutData((Object)gd);
        this.bar.createControl(this.control);
        gd = new GridData(128);
        this.bar.getControl().setLayoutData((Object)gd);
        return this.control;
    }

    public void load() {
        if (this.object != null && this.text != null) {
            this.text.setText(this.object.getAttributeValue(this.name));
        }
    }

    public void save() {
        if (this.object != null && this.text != null) {
            try {
                this.object.getModel().changeObjectAttribute(this.object, this.name, this.text.getText());
            }
            catch (XModelException e) {
                ModelPlugin.getPluginLog().logError((Throwable)e);
            }
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.text != null) {
            this.text.setEditable(enabled);
        }
        if (this.bar != null) {
            this.bar.setEnabled(CHANGE, enabled);
        }
    }
}

