/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.validator.ui.global;

import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.editor.DefaultEditorPart;
import org.jboss.tools.common.model.ui.swt.util.BorderLayout;
import org.jboss.tools.common.model.ui.swt.util.VerticalFillLayout;
import org.jboss.tools.struts.validator.ui.ValidatorAttributeEditor;
import org.jboss.tools.struts.validator.ui.global.DependsAttributeEditor;
import org.jboss.tools.struts.validator.ui.global.KeyAttributeEditor;
import org.jboss.tools.struts.validator.ui.global.TextAreaAttributeEditor;
import org.jboss.tools.struts.validator.ui.global.TextAttributeEditor;

public class ValidatorEditor
extends DefaultEditorPart {
    static int EDITOR_HEIGHT = 22;
    protected Composite control;
    protected Composite control2;
    private XModelObject object = null;
    protected Group dependsGroup;
    protected Group javaGroup;
    protected Group javaScriptGroup;
    ValidatorAttributeEditor dependsEditor = new DependsAttributeEditor();
    ValidatorAttributeEditor messageKeyEditor = new KeyAttributeEditor();
    ValidatorAttributeEditor classEditor = new TextAttributeEditor("classname", "Class Name", "EditActions.EditClassname");
    ValidatorAttributeEditor methodEditor = new TextAttributeEditor("method", "Method", "EditActions.EditMethod");
    ValidatorAttributeEditor methodParamsEditor = new TextAttributeEditor("methodParams", "Method Params", "EditActions.EditMethodParams");
    ValidatorAttributeEditor functionNameEditor = new TextAttributeEditor("jsFunctionName", "Function Name", "EditActions.EditFunctionName");
    ValidatorAttributeEditor functionBodyEditor = new TextAreaAttributeEditor("javascript", "Function Body");
    ValidatorAttributeEditor[] editors = new ValidatorAttributeEditor[]{this.dependsEditor, this.messageKeyEditor, this.classEditor, this.methodEditor, this.methodParamsEditor, this.functionNameEditor, this.functionBodyEditor};

    public void dispose() {
        if (this.editors != null) {
            int i = 0;
            while (i < this.editors.length) {
                if (this.editors[i] != null) {
                    this.editors[i].dispose();
                }
                ++i;
            }
        }
        this.editors = null;
        this.dependsEditor = null;
        this.messageKeyEditor = null;
        this.classEditor = null;
        this.methodEditor = null;
        this.methodParamsEditor = null;
        this.functionNameEditor = null;
        this.functionBodyEditor = null;
    }

    public Control createControl(Composite parent) {
        this.control = new Composite(parent, 0);
        this.control.setLayout((Layout)new FillLayout(512));
        this.control2 = new Composite(this.control, 0);
        BorderLayout bl = new BorderLayout();
        this.control2.setLayout((Layout)bl);
        Composite c1 = new Composite(this.control2, 0);
        bl.northComposite = c1;
        c1.setLayout((Layout)new VerticalFillLayout());
        this.createDependsGroup(c1);
        this.createJavaGroup(c1);
        Composite c2 = new Composite(this.control2, 0);
        bl.centerComposite = c2;
        c2.setLayout((Layout)new FillLayout(512));
        this.createJavaScriptGroup(c2);
        this.control2.setVisible(false);
        return this.control;
    }

    protected void createDependsGroup(Composite parent) {
        this.dependsGroup = new Group(parent, 16);
        VerticalFillLayout vfl = new VerticalFillLayout();
        vfl.leftMargin = 4;
        this.dependsGroup.setLayout((Layout)vfl);
        this.dependsEditor.createControl((Composite)this.dependsGroup);
        VerticalFillLayout.createSeparator((Composite)this.dependsGroup, (int)2);
        this.messageKeyEditor.createControl((Composite)this.dependsGroup);
        VerticalFillLayout.createSeparator((Composite)this.dependsGroup, (int)2);
    }

    protected void createJavaGroup(Composite parent) {
        this.javaGroup = new Group(parent, 16);
        this.javaGroup.setText("Java");
        VerticalFillLayout vfl = new VerticalFillLayout();
        vfl.leftMargin = 4;
        this.javaGroup.setLayout((Layout)vfl);
        this.classEditor.createControl((Composite)this.javaGroup);
        VerticalFillLayout.createSeparator((Composite)this.javaGroup, (int)2);
        this.methodEditor.createControl((Composite)this.javaGroup);
        VerticalFillLayout.createSeparator((Composite)this.javaGroup, (int)2);
        this.methodParamsEditor.createControl((Composite)this.javaGroup);
        VerticalFillLayout.createSeparator((Composite)this.javaGroup, (int)2);
    }

    protected void createJavaScriptGroup(Composite parent) {
        this.javaScriptGroup = new Group(parent, 16);
        this.javaScriptGroup.setText("JavaScript");
        BorderLayout bl = new BorderLayout();
        this.javaScriptGroup.setLayout((Layout)bl);
        Composite c = new Composite((Composite)this.javaScriptGroup, 0);
        VerticalFillLayout vfl = new VerticalFillLayout();
        vfl.leftMargin = 4;
        c.setLayout((Layout)vfl);
        this.functionNameEditor.createControl(c);
        bl.northComposite = c;
        bl.centerComposite = this.functionBodyEditor.createControl((Composite)this.javaScriptGroup);
    }

    public void setObject(XModelObject object) {
        if (this.object == object) {
            this.update();
            return;
        }
        if (this.object == null != (object == null)) {
            this.control2.setVisible(object != null);
            this.control2.layout();
        }
        this.object = object;
        int i = 0;
        while (i < this.editors.length) {
            this.editors[i].setObject(object);
            ++i;
        }
        this.update();
        this.control.redraw();
    }

    public void update() {
        if (this.object == null) {
            return;
        }
        int i = 0;
        while (i < this.editors.length) {
            this.editors[i].load();
            ++i;
        }
        this.updateFunctionBodyEditorComponent();
        this.setEnabled(this.object.isObjectEditable());
    }

    public void updateFunctionBodyEditorComponent() {
        if (this.object == null) {
            return;
        }
    }

    private void setEnabled(boolean enabled) {
        this.dependsEditor.setEnabled(enabled);
        this.messageKeyEditor.setEnabled(enabled);
        this.classEditor.setEnabled(enabled);
        this.methodEditor.setEnabled(enabled);
        this.methodParamsEditor.setEnabled(enabled);
        this.functionNameEditor.setEnabled(enabled);
        this.functionBodyEditor.setEnabled(enabled);
    }
}

