/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.validator.ui.global;

import java.util.Set;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.event.XModelTreeEvent;
import org.jboss.tools.common.model.ui.objecteditor.XChildrenEditor;
import org.jboss.tools.common.model.ui.swt.util.BorderLayout;
import org.jboss.tools.common.model.util.AbstractTableHelper;
import org.jboss.tools.struts.validator.ui.formset.FEditorConstants;
import org.jboss.tools.struts.validator.ui.global.GlobalEditor;
import org.jboss.tools.struts.validator.ui.global.GlobalEditorListener;
import org.jboss.tools.struts.validator.ui.global.ValidatorEditor;
import org.jboss.tools.struts.validators.model.helpers.ValidatorsTableHelper;

public class ValidatorListEditor
extends XChildrenEditor
implements GlobalEditorListener,
SelectionListener {
    protected XModelObject selected = null;
    protected ValidatorEditor listener = null;
    protected GlobalEditor globalEditor = null;
    protected boolean lock2 = false;

    public void dispose() {
        super.dispose();
        this.listener = null;
        if (this.globalEditor != null) {
            this.globalEditor.dispose();
        }
        this.globalEditor = null;
    }

    public void addListener(ValidatorEditor listener) {
        this.listener = listener;
    }

    public void setGlobalEditor(GlobalEditor globalEditor) {
        this.globalEditor = globalEditor;
    }

    public Control createControl(Composite parent) {
        this.control = new Group(parent, 0);
        ((Group)this.control).setText("Validators");
        BorderLayout bl = new BorderLayout();
        this.control.setLayout((Layout)bl);
        this.xtable.createControl(this.control);
        bl.centerComposite = this.xtable.getControl();
        Composite c = new Composite(this.control, 0);
        bl.northComposite = c;
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginWidth = 4;
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        c.setLayout((Layout)gl);
        this.createCommandBar();
        this.bar.createControl(c);
        GridData gd = new GridData(640);
        this.bar.getControl().setLayoutData((Object)gd);
        this.enableSelectionListener();
        this.update();
        this.xtable.getTable().addSelectionListener((SelectionListener)this);
        return this.control;
    }

    protected AbstractTableHelper createHelper() {
        return new ValidatorsTableHelper();
    }

    protected void createCommandBar() {
        this.bar.getLayout().asToolBar = true;
        this.bar.setCommands(new String[]{ADD, DELETE, EDIT});
        this.bar.getLayout().direction = 256;
        this.bar.getLayout().iconsOnly = true;
        this.bar.setImage(ADD, FEditorConstants.IMAGE_CREATE);
        this.bar.setImage(EDIT, FEditorConstants.IMAGE_EDIT);
        this.bar.setImage(DELETE, FEditorConstants.IMAGE_DELETE);
    }

    public void setSelected(XModelObject selected) {
        if (this.selected == selected) {
            return;
        }
        this.selected = selected;
        this.update();
    }

    protected Color getItemColor(int i) {
        XModelObject o = this.helper.getModelObject(i);
        boolean isSg = o != null && this.selected == o.getParent();
        return isSg ? DEFAULT_COLOR : FEditorConstants.INHERITED;
    }

    public void update() {
        this.lock2 = true;
        if (this.xtable.getControl() == null || this.xtable.getControl().isDisposed()) {
            return;
        }
        this.lock = true;
        this.xtable.update();
        this.lock = false;
        if (this.selectionListener != null) {
            this.updateBar();
        }
        this.lock2 = false;
        this.widgetSelected(null);
    }

    protected void updateBar() {
        super.updateBar();
        if (!this.globalEditor.isGlobalSelected()) {
            this.bar.setEnabled(ADD, false);
        }
    }

    public void structureChanged(XModelTreeEvent event) {
        if (this.helper.getModelObject() == null) {
            return;
        }
        if (event.kind() == 1) {
            if (this.helper.getModelObject() != event.getModelObject().getParent()) {
                return;
            }
            XModelObject added = (XModelObject)event.getInfo();
            int i = 0;
            while (i < this.helper.size()) {
                if (added == this.helper.getModelObject(i)) {
                    this.xtable.setSelection(i);
                }
                ++i;
            }
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.globalEditor != null) {
            this.globalEditor.updateCommandsEnabled();
        }
        if (this.lock2 || this.listener == null) {
            return;
        }
        if (this.xtable.getControl() == null || this.xtable.getControl().isDisposed()) {
            return;
        }
        int r = this.xtable.getSelectionIndex();
        this.listener.setObject(this.helper.getModelObject(r));
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    protected void add() {
        if (this.selected == null) {
            return;
        }
        Set set = this.getKeys();
        this.callAction(this.selected, "CreateActions.AddValidator");
        this.update();
        int i = this.getAddedKey(set);
        if (i >= 0) {
            this.xtable.setSelection(i);
        }
    }
}

