/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.validator.ui.wizard.depends;

import java.util.HashSet;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.action.CommandBar;
import org.jboss.tools.common.model.ui.action.CommandBarListener;
import org.jboss.tools.common.model.ui.objecteditor.XTable;
import org.jboss.tools.common.model.ui.objecteditor.XTableProvider;
import org.jboss.tools.struts.messages.StrutsUIMessages;
import org.jboss.tools.struts.validator.ui.wizard.depends.ListModel;
import org.jboss.tools.struts.validator.ui.wizard.key.PathListener;
import org.jboss.tools.struts.validators.model.XModelEntityResolver;

public class DependencyLRView
implements PathListener,
CommandBarListener,
SelectionListener {
    static String ADD_NEW = StrutsUIMessages.ADD_NEW;
    static String ADD = StrutsUIMessages.ADD_ARROW_RIGHT;
    static String REMOVE = StrutsUIMessages.REMOVE_ARROW_LEFT;
    static String UP = StrutsUIMessages.UP;
    static String DOWN = StrutsUIMessages.DOWN;
    static String[][] commands = new String[][]{{ADD, REMOVE}, {UP, DOWN}, {ADD_NEW}};
    protected ListModel sourceModel = new ListModel();
    protected ListModel targetModel = new ListModel();
    protected XTable sourceList = new XTable();
    protected XTable targetList = new XTable();
    protected CommandBar barNew = new CommandBar();
    protected CommandBar barAdd = new CommandBar();
    protected CommandBar barUp = new CommandBar();
    protected CommandBar[] bars = new CommandBar[]{this.barAdd, this.barUp, this.barNew};
    protected Properties p;
    protected Control control;

    public DependencyLRView() {
        int i = 0;
        while (i < this.bars.length) {
            this.bars[i].getLayout().buttonWidth = 80;
            this.bars[i].getLayout().direction = 512;
            this.bars[i].setCommands(commands[i]);
            this.bars[i].addCommandBarListener((CommandBarListener)this);
            ++i;
        }
        this.sourceModel.setTable(this.sourceList);
        this.targetModel.setTable(this.targetList);
        this.sourceList.setTableProvider((XTableProvider)this.sourceModel);
        this.targetList.setTableProvider((XTableProvider)this.targetModel);
        this.sourceList.setMultiSelected();
        this.targetList.setMultiSelected();
        this.sourceModel.setName("Available Rules");
        this.targetModel.setName("Selected Rules");
    }

    public void dispose() {
        if (this.sourceList != null) {
            this.sourceList.dispose();
        }
        this.sourceList = null;
        if (this.targetList != null) {
            this.targetList.dispose();
        }
        this.targetList = null;
        if (this.barNew != null) {
            this.barNew.dispose();
        }
        this.barNew = null;
        if (this.barAdd != null) {
            this.barAdd.dispose();
        }
        this.barAdd = null;
        if (this.barUp != null) {
            this.barUp.dispose();
        }
        this.barUp = null;
        if (this.p != null) {
            this.p.clear();
        }
        this.p = null;
    }

    public void setObject(Object data) {
        this.p = (Properties)data;
    }

    public void objectSelected(XModelObject object) {
        this.sourceModel.removeAllElements();
        if (object == null) {
            return;
        }
        HashSet<String> s = new HashSet<String>();
        XModelObject[] gs = XModelEntityResolver.getResolvedChildren((XModelObject)object, (String)"ValidationGlobal");
        int i = 0;
        while (i < gs.length) {
            XModelObject[] vs = XModelEntityResolver.getResolvedChildren((XModelObject)gs[i], (String)"ValidationValidator");
            int j = 0;
            while (j < vs.length) {
                String n = vs[j].getPathPart();
                if (!s.contains(n)) {
                    s.add(n);
                    this.sourceModel.getList().add(n);
                }
                ++j;
            }
            ++i;
        }
        this.sourceModel.fireStructureChanged();
        this.updateSelectionDependentActions();
    }

    private void loadTarget() {
        this.targetModel.removeAllElements();
        if (this.p == null) {
            return;
        }
        String value = this.p.getProperty("value");
        StringTokenizer st = new StringTokenizer(value, ",");
        HashSet<String> s = new HashSet<String>();
        while (st.hasMoreTokens()) {
            String n = st.nextToken().trim();
            if (s.contains(n)) continue;
            s.add(n);
            this.targetModel.getList().add(n);
        }
        this.targetModel.fireStructureChanged();
        this.updateSelectionDependentActions();
    }

    public void saveTarget() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.targetModel.getList().size()) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this.targetModel.getList().get(i));
            ++i;
        }
        if (this.p != null) {
            this.p.setProperty("value", sb.toString());
        }
    }

    public void action(String name) {
        if (ADD_NEW.equals(name)) {
            this.addNew();
        } else if (ADD.equals(name)) {
            this.addSelected();
        } else if (REMOVE.equals(name)) {
            this.removeSelected();
        } else if (UP.equals(name)) {
            this.moveUp();
        } else if (DOWN.equals(name)) {
            this.moveDown();
        }
    }

    private void addNew() {
        InputDialog d = new InputDialog(this.control.getShell(), StrutsUIMessages.ADD_VALIDATOR, "name", "", null);
        d.create();
        if (d.open() != 0) {
            return;
        }
        String s = d.getValue();
        if (s != null && this.targetModel.getList().indexOf(s) < 0) {
            this.targetModel.getList().addElement(s);
            this.targetModel.fireStructureChanged();
            int si = this.targetModel.getRowCount() - 1;
            if (si >= 0) {
                this.targetList.setSelection(si);
            }
            this.updateSelectionDependentActions();
        }
    }

    private void addSelected() {
        int[] is = this.sourceList.getTable().getSelectionIndices();
        int si = -1;
        int i = 0;
        while (i < is.length) {
            Object s = this.sourceModel.getList().get(is[i]);
            if (this.targetModel.getList().indexOf(s) < 0) {
                this.targetModel.getList().add(s);
                si = this.targetModel.getList().size() - 1;
            }
            ++i;
        }
        this.targetModel.fireStructureChanged();
        if (si >= 0) {
            this.targetList.getTable().setSelection(si);
        }
        this.updateSelectionDependentActions();
    }

    private void removeSelected() {
        int[] is = this.targetList.getTable().getSelectionIndices();
        Object[] os = new Object[is.length];
        int i = 0;
        while (i < is.length) {
            os[i] = this.targetModel.getList().get(is[i]);
            ++i;
        }
        int s = -1;
        int i2 = 0;
        while (i2 < is.length) {
            this.targetModel.getList().remove(os[i2]);
            s = is[i2];
            if (s >= this.targetModel.getColumnCount()) {
                s = this.targetModel.getColumnCount() - 1;
            }
            ++i2;
        }
        this.targetModel.fireStructureChanged();
        if (s >= 0) {
            this.targetList.setSelection(s);
        }
        this.updateSelectionDependentActions();
    }

    private void moveUp() {
        int[] is = this.targetList.getTable().getSelectionIndices();
        if (is.length != 1) {
            return;
        }
        this.move(is[0], is[0] - 1);
    }

    private void moveDown() {
        int[] is = this.targetList.getTable().getSelectionIndices();
        if (is.length != 1) {
            return;
        }
        this.move(is[0], is[0] + 1);
    }

    private void move(int from, int to) {
        if (to < 0 || to >= this.targetModel.getList().size()) {
            return;
        }
        Object o = this.targetModel.getList().elementAt(from);
        this.targetModel.getList().removeElementAt(from);
        this.targetModel.getList().insertElementAt(o, to);
        this.targetModel.fireStructureChanged();
        this.targetList.getTable().setSelection(to);
        this.updateSelectionDependentActions();
    }

    public Control createControl(Composite parent) {
        Composite c = new Composite(parent, 0);
        this.control = c;
        GridLayout g = new GridLayout(3, false);
        c.setLayout((Layout)g);
        Control slc = this.sourceList.createControl(c);
        slc.setLayoutData((Object)new GridData(1808));
        Control bc = this.createBar(c);
        bc.setLayoutData((Object)new GridData(1040));
        Control tlc = this.targetList.createControl(c);
        tlc.setLayoutData((Object)new GridData(1808));
        this.loadTarget();
        this.sourceList.getTable().addSelectionListener((SelectionListener)this);
        this.targetList.getTable().addSelectionListener((SelectionListener)this);
        this.updateSelectionDependentActions();
        return c;
    }

    private Control createBar(Composite parent) {
        Composite c = new Composite(parent, 0);
        GridLayout g = new GridLayout(1, false);
        c.setLayout((Layout)g);
        this.barAdd.createControl(c);
        this.barNew.createControl(c);
        this.barUp.createControl(c);
        return c;
    }

    private void updateSelectionDependentActions() {
        if (this.sourceList == null || !this.sourceList.isActive()) {
            return;
        }
        int targetSelection = this.targetList.getTable().getSelectionIndex();
        this.barAdd.setEnabled(ADD, this.canAddSelection());
        this.barAdd.setEnabled(REMOVE, targetSelection >= 0);
        this.barUp.setEnabled(UP, targetSelection > 0);
        this.barUp.setEnabled(DOWN, targetSelection >= 0 && targetSelection < this.targetList.getTable().getItemCount() - 1);
    }

    private boolean canAddSelection() {
        int[] is = this.sourceList.getTable().getSelectionIndices();
        if (is == null) {
            return false;
        }
        int i = 0;
        while (i < is.length) {
            Object s = this.sourceModel.getList().get(is[i]);
            if (this.targetModel.getList().indexOf(s) < 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void widgetSelected(SelectionEvent e) {
        this.updateSelectionDependentActions();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }
}

