/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.validator.ui.wizard.key;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.action.CommandBar;
import org.jboss.tools.common.model.ui.action.CommandBarListener;
import org.jboss.tools.struts.validator.ui.Messages;
import org.jboss.tools.struts.validator.ui.wizard.key.PathListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResourcePathView
implements CommandBarListener,
SelectionListener {
    protected CommandBar commandBar = new CommandBar();
    protected Combo combo;
    protected String selected = null;
    protected PathListener listener = null;
    protected XModel model;
    protected XModelObject object;
    private boolean lock = false;

    public void addPathListener(PathListener listener) {
        this.listener = listener;
    }

    public Control createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.horizontalSpacing = 10;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setText(MessageFormat.format(Messages.AbstractResourcePathView_Label, this.getDisplayName()));
        this.combo = new Combo(composite, 2056);
        GridData d = new GridData(768);
        this.combo.setLayoutData((Object)d);
        this.populateCombo();
        if (this.combo.getItemCount() > 0) {
            this.combo.setText(this.combo.getItem(0));
        }
        this.combo.addSelectionListener((SelectionListener)this);
        this.commandBar.setMnemonicEnabled(true);
        this.commandBar.setCommands(new String[]{Messages.AbstractResourcePathView_Browse});
        this.commandBar.addCommandBarListener((CommandBarListener)this);
        this.commandBar.getLayout().setMargins(0, 0, 0, 0);
        this.commandBar.getLayout().buttonWidth = this.convertHorizontalDLUsToPixels((Control)parent, 61);
        this.commandBar.createControl(composite);
        return composite;
    }

    protected abstract Vector<String> history();

    protected abstract String[] getRequiredValues();

    protected int convertHorizontalDLUsToPixels(Control control, int dlus) {
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        int averageWidth = gc.getFontMetrics().getAverageCharWidth();
        gc.dispose();
        double horizontalDialogUnitSize = (double)averageWidth * 0.25;
        return (int)Math.round((double)dlus * horizontalDialogUnitSize);
    }

    protected abstract String getDisplayName();

    public void setObject(Object data) {
        this.lock = true;
        Properties p = (Properties)data;
        this.model = (XModel)p.get("model");
        this.object = (XModelObject)p.get("object");
        this.lock = false;
        this.updateSelection();
    }

    public void updateSelection() {
        String s;
        if (this.lock || this.combo == null) {
            return;
        }
        int i = this.combo.getSelectionIndex();
        String string = s = i < 0 ? null : this.combo.getItem(i);
        if (this.selected == s || this.selected != null && this.selected.equals(s)) {
            return;
        }
        this.selected = s;
        this.fireSelectionChanged();
    }

    private void fireSelectionChanged() {
        if (this.listener != null) {
            this.listener.objectSelected(this.getSelectedFile());
        }
    }

    protected XModelObject getSelectedFile() {
        int i = this.combo.getSelectionIndex();
        String s = i < 0 ? null : this.combo.getItem(i);
        return s == null || this.model == null ? null : this.model.getByPath(s);
    }

    protected void addValue(String s) {
        this.lock = true;
        Vector<String> history = this.history();
        history.remove(s);
        history.insertElementAt(s, 0);
        this.populateCombo();
        if (history.size() > 0) {
            this.combo.setText(s);
        }
        this.lock = false;
        this.updateSelection();
    }

    protected void populateCombo() {
        Vector<String> history = this.history();
        this.combo.removeAll();
        String[] vs = this.getRequiredValues();
        HashSet<String> used = new HashSet<String>();
        int i = 0;
        while (i < vs.length) {
            if (!used.contains(vs[i])) {
                used.add(vs[i]);
                this.combo.add(vs[i]);
            }
            ++i;
        }
        i = 0;
        while (i < history.size()) {
            String v = history.elementAt(i).toString();
            if (!used.contains(v)) {
                used.add(v);
                this.combo.add(v);
            }
            ++i;
        }
    }

    public void widgetSelected(SelectionEvent e) {
        this.updateSelection();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

