/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.validator.ui.wizard.key;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Properties;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.common.model.ServiceDialog;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.ui.wizards.query.AbstractQueryWizardView;
import org.jboss.tools.common.model.undo.XUndoManager;
import org.jboss.tools.struts.messages.StrutsUIMessages;
import org.jboss.tools.struts.validator.ui.wizard.key.KeysEditor;
import org.jboss.tools.struts.validator.ui.wizard.key.ResourcePathView;

public class SelectKeyWizardView
extends AbstractQueryWizardView {
    protected ResourcePathView path = new ResourcePathView();
    protected KeysEditor keys = new KeysEditor();
    protected XUndoManager undo = null;
    Properties p;
    Listener listener = new Listener();

    public SelectKeyWizardView() {
        this.path.addPathListener(this.keys);
    }

    public Control createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 10;
        layout.marginWidth = 10;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        Control pc = this.path.createControl(composite);
        pc.setLayoutData((Object)new GridData(768));
        Control kc = this.keys.createControl(composite);
        kc.setLayoutData((Object)new GridData(1808));
        this.path.updateSelection();
        return composite;
    }

    public void setObject(Object data) {
        super.setObject(data);
        this.p = (Properties)data;
        this.model = (XModel)this.p.get("model");
        this.undo = this.model.getUndoManager();
        this.undo.beginTransaction();
        this.keys.setListener(this.listener);
        this.keys.setInitialSelection(this.p.getProperty("key"));
        this.path.setObject(data);
    }

    public void dispose() {
        if (this.undo == null) {
            return;
        }
        if (this.code() == 0) {
            this.undo.commitTransaction();
            this.keys.save();
        } else if (this.undo.getTransactionStatus() > 0) {
            ServiceDialog d = this.model.getService();
            int q = d.showDialog(StrutsUIMessages.QUESTION, StrutsUIMessages.SAVE_CHANGES, new String[]{StrutsUIMessages.OK, StrutsUIMessages.CANCEL}, null, 0);
            if (q == 0) {
                this.undo.commitTransaction();
                this.keys.save();
            } else {
                this.undo.rollbackTransaction();
            }
        }
        this.undo = null;
        super.dispose();
    }

    public void updateBar() {
        if (this.p == null) {
            return;
        }
        String s = this.p.getProperty("key");
        this.getCommandBar().setEnabled(OK, s != null && s.length() > 0);
    }

    class Listener
    implements PropertyChangeListener {
        Listener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (SelectKeyWizardView.this.p == null) {
                return;
            }
            String s = (String)evt.getNewValue();
            if (s == null) {
                SelectKeyWizardView.this.p.remove("key");
            } else {
                SelectKeyWizardView.this.p.setProperty("key", s);
            }
            SelectKeyWizardView.this.updateBar();
        }
    }
}

