/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.verification;

import java.util.Set;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.verification.vrules.VAction;
import org.jboss.tools.common.verification.vrules.VObject;
import org.jboss.tools.common.verification.vrules.VResult;
import org.jboss.tools.common.verification.vrules.VRule;
import org.jboss.tools.common.verification.vrules.layer.VObjectImpl;
import org.jboss.tools.struts.model.handlers.JumpByForwardPathHandler;
import org.jboss.tools.struts.model.helpers.StrutsProcessHelper;
import org.jboss.tools.struts.model.helpers.StrutsProcessStructureHelper;
import org.jboss.tools.struts.model.helpers.TilesHelper;
import org.jboss.tools.struts.verification.ValidateTypeUtil;
import org.jboss.tools.struts.webprj.model.helpers.WebModulesHelper;
import org.jboss.tools.struts.webprj.pattern.UrlPattern;

public class ActionForwardCheck
implements VAction {
    protected VRule rule;
    protected VObject object;
    protected XModel model;
    protected XModelObject forward;
    protected XModelObject config;
    protected String path;
    protected String module;
    protected Set modules;
    protected String pathModule = null;
    protected static StrutsProcessStructureHelper h = new StrutsProcessStructureHelper();

    public VRule getRule() {
        return this.rule;
    }

    public void setRule(VRule rule) {
        this.rule = rule;
    }

    protected boolean isRelevant(VObject object) {
        return object.getParent() != null && object.getParent().getEntity().getName().startsWith("StrutsAction");
    }

    public VResult[] check(VObject object) {
        if (!this.isRelevant(object)) {
            return null;
        }
        this.object = object;
        this.forward = ((VObjectImpl)object).getModelObject();
        this.model = this.forward.getModel();
        this.path = JumpByForwardPathHandler.getResourcePath((String)this.forward.getAttributeValue("path"));
        VResult[] rs = this.checkPath();
        if (rs != null) {
            return rs;
        }
        rs = this.checkClasses();
        if (rs != null) {
            return rs;
        }
        return null;
    }

    protected VResult[] checkClasses() {
        return this.checkClass("className", "class");
    }

    protected boolean isAllowedEmptyPath() {
        return false;
    }

    protected VResult[] checkPath() {
        boolean cR;
        if (this.path.length() == 0) {
            return this.isAllowedEmptyPath() ? null : this.fire("empty", "path", null);
        }
        this.config = StrutsProcessStructureHelper.instance.getParentFile(this.forward);
        WebModulesHelper wh = WebModulesHelper.getInstance((XModel)this.model);
        if (TilesHelper.findTile((XModelObject)this.config, (String)this.path) != null) {
            return null;
        }
        this.module = StrutsProcessStructureHelper.instance.getProcessModule(this.forward);
        this.modules = wh.getModules();
        this.pathModule = wh.getModuleForPath(this.path, this.module);
        if (this.pathModule == null) {
            this.pathModule = "";
        }
        if (StrutsProcessHelper.isHttp((String)this.path)) {
            return null;
        }
        UrlPattern up = wh.getUrlPattern(this.module);
        boolean isFolder = this.path.endsWith("/") && this.path.startsWith("/");
        boolean isAction = !isFolder && up.isActionUrl(this.path);
        boolean isPage = this.path.endsWith(".jsp") || this.path.indexOf(".htm") > 0 || this.path.endsWith(".css");
        String s = this.forward.getAttributeValue("contextRelative");
        boolean bl = cR = "true".equals(s) || "yes".equals(s);
        if (isFolder || isAction || isPage) {
            if (this.forward.getModelEntity().getAttribute("contextRelative") != null) {
                if (!cR && this.pathModule.length() > 0 && this.path.startsWith(String.valueOf(this.pathModule) + "/")) {
                    return this.fire("cross", "contextRelative", null);
                }
                if (cR && this.pathModule.length() > 0 && !this.path.startsWith(String.valueOf(this.pathModule) + "/")) {
                    return this.fire("mono", "contextRelative", null);
                }
            } else if (!this.pathModule.equals(this.module) || this.pathModule.length() > 0 && this.path.startsWith(String.valueOf(this.pathModule) + "/")) {
                return this.fire("mono", "path", null);
            }
        }
        XModelObject target = null;
        String kind = "tile";
        if (isFolder) {
            kind = "resource folder";
            target = this.model.getByPath(this.path.substring(0, this.path.length() - 1));
        } else if (isAction) {
            kind = "action";
            this.path = up.getActionPath(this.path);
            if (!cR) {
                target = this.config.getChildByPath("action-mappings/" + this.path.replace('/', '#'));
                if (target == null) {
                    XModelObject[] cgs = wh.getConfigsForModule(this.model, this.pathModule);
                    int i = 0;
                    while (i < cgs.length && target == null) {
                        if (cgs[i] != this.config) {
                            target = cgs[i].getChildByPath("action-mappings/" + this.path.replace('/', '#'));
                        }
                        ++i;
                    }
                }
            } else {
                XModelObject[] cgs = wh.getConfigsForModule(this.model, this.pathModule);
                if (cgs.length > 0 && this.pathModule.length() > 0 && this.path.startsWith(this.pathModule)) {
                    this.path = this.path.substring(this.pathModule.length());
                }
                int i = 0;
                while (i < cgs.length && target == null) {
                    target = cgs[i].getChildByPath("action-mappings/" + this.path.replace('/', '#'));
                    ++i;
                }
            }
        } else {
            XModelObject fs;
            String string = kind = isPage ? "page" : "tile or page";
            if (this.path.endsWith(".css")) {
                kind = "resource";
            }
            if ((fs = wh.getRootFileSystemForModule(this.model, this.pathModule)) != null) {
                if (this.pathModule.length() > 0 && this.path.startsWith(this.pathModule)) {
                    this.path = this.path.substring(this.pathModule.length());
                }
                if (this.path.startsWith("/")) {
                    this.path = this.path.substring(1);
                }
                target = fs.getChildByPath(this.path);
            }
        }
        return target == null ? this.fire("exists", "path", kind) : null;
    }

    protected VResult[] checkClass(String attr, String id) {
        ValidateTypeUtil tv = new ValidateTypeUtil();
        int tvr = tv.checkClass(this.object, attr, "org.apache.struts.action.ActionForward");
        if (tvr == ValidateTypeUtil.NOT_FOUND) {
            return this.fire(id, attr, null);
        }
        if (tvr == ValidateTypeUtil.NOT_UPTODATE) {
            return null;
        }
        return null;
    }

    protected VResult[] fire(String id, String attr, String info) {
        Object[] objectArray;
        if (info == null) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = this.object;
            objectArray = objectArray2;
            objectArray2[1] = this.object.getParent();
        } else {
            Object[] objectArray3 = new Object[3];
            objectArray3[0] = this.object;
            objectArray3[1] = this.object.getParent();
            objectArray = objectArray3;
            objectArray3[2] = info;
        }
        Object[] os = objectArray;
        VResult result = this.rule.getResultFactory().getResult(id, this.object, (Object)attr, this.object, (Object)attr, os);
        return new VResult[]{result};
    }
}

