/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.verification;

import java.util.ArrayList;
import java.util.Set;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.verification.vrules.VAction;
import org.jboss.tools.common.verification.vrules.VObject;
import org.jboss.tools.common.verification.vrules.VResult;
import org.jboss.tools.common.verification.vrules.VRule;
import org.jboss.tools.common.verification.vrules.layer.VObjectImpl;
import org.jboss.tools.struts.model.helpers.StrutsProcessHelper;
import org.jboss.tools.struts.model.helpers.StrutsProcessStructureHelper;
import org.jboss.tools.struts.model.helpers.TilesHelper;
import org.jboss.tools.struts.webprj.model.helpers.WebModulesHelper;
import org.jboss.tools.struts.webprj.pattern.UrlPattern;

public class ActionRefsCheck
implements VAction {
    protected VRule rule;
    protected VObject object;
    protected XModel model;
    protected XModelObject action;
    protected XModelObject config;
    protected String path;
    protected String module;
    protected Set modules;
    protected String pathModule = null;
    protected static StrutsProcessStructureHelper h = new StrutsProcessStructureHelper();

    public VResult[] check(VObject object) {
        VResult result;
        this.object = object;
        this.action = ((VObjectImpl)object).getModelObject();
        this.model = this.action.getModel();
        ArrayList<VResult> results = new ArrayList<VResult>();
        VResult vResult = result = this.isInputReferencingForwardOrEmpty() ? null : this.checkPath("input");
        if (result != null) {
            results.add(result);
        }
        if ((result = this.checkPath("forward")) != null) {
            results.add(result);
        }
        if ((result = this.checkPath("include")) != null) {
            results.add(result);
        }
        return results.toArray(new VResult[results.size()]);
    }

    public VRule getRule() {
        return this.rule;
    }

    public void setRule(VRule rule) {
        this.rule = rule;
    }

    boolean isInputReferencingForwardOrEmpty() {
        String v = this.action.getAttributeValue("input");
        if (v == null || v.length() == 0) {
            return true;
        }
        if (v.indexOf(47) < 0 && v.indexOf(46) < 0) {
            XModelObject f = this.action.getChildByPath(v);
            if (f != null) {
                return true;
            }
            XModelObject cfg = this.action.getParent().getParent();
            f = cfg.getChildByPath("global-forwards/" + v);
            if (f != null) {
                return true;
            }
            WebModulesHelper h = WebModulesHelper.getInstance((XModel)this.action.getModel());
            XModelObject[] cfgs = h.getConfigsForModule(cfg.getModel(), h.getModuleForConfig(cfg));
            if (cfgs == null || cfgs.length < 2) {
                return false;
            }
            int i = 0;
            while (i < cfgs.length) {
                f = cfgs[i].getChildByPath("global-forwards/" + v);
                if (f != null) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected VResult checkPath(String attr) {
        this.path = this.action.getAttributeValue(attr);
        if (this.path == null || this.path.length() == 0) {
            return null;
        }
        this.config = StrutsProcessStructureHelper.instance.getParentFile(this.action);
        WebModulesHelper wh = WebModulesHelper.getInstance((XModel)this.model);
        if (TilesHelper.findTile((XModelObject)this.config, (String)this.path) != null) {
            return null;
        }
        this.module = StrutsProcessStructureHelper.instance.getProcessModule(this.action);
        this.modules = wh.getModules();
        this.pathModule = wh.getModuleForPath(this.path, this.module);
        if (StrutsProcessHelper.isHttp((String)this.path)) {
            return null;
        }
        UrlPattern up = wh.getUrlPattern(this.module);
        boolean isFolder = this.path.endsWith("/") && this.path.startsWith("/");
        boolean isAction = !isFolder && up.isActionUrl(this.path);
        boolean isPage = this.path.endsWith(".jsp") || this.path.indexOf(".htm") > 0 || this.path.endsWith(".css");
        XModelObject target = null;
        String kind = "tile";
        if (isFolder) {
            kind = "resource folder";
            this.path = this.path.substring(0, this.path.length() - 1);
            target = this.model.getByPath(this.path);
        } else if (isAction) {
            kind = "action";
            this.path = up.getActionPath(this.path);
            XModelObject[] cgs = wh.getConfigsForModule(this.model, this.pathModule);
            if (cgs.length > 0 && this.pathModule.length() > 0 && this.path.startsWith(this.pathModule)) {
                this.path = this.path.substring(this.pathModule.length());
            }
            int i = 0;
            while (i < cgs.length && target == null) {
                target = cgs[i].getChildByPath("action-mappings/" + this.path.replace('/', '#'));
                ++i;
            }
        } else {
            XModelObject fs;
            String string = kind = isPage ? "page" : "tile or page";
            if (this.path.endsWith(".css")) {
                kind = "resource";
            }
            if ((fs = wh.getRootFileSystemForModule(this.model, this.pathModule)) != null) {
                if (this.pathModule.length() > 0 && this.path.startsWith(this.pathModule)) {
                    this.path = this.path.substring(this.pathModule.length());
                }
                if (this.path.startsWith("/")) {
                    this.path = this.path.substring(1);
                }
                target = fs.getChildByPath(this.path);
            }
        }
        return target == null ? this.fire(attr, attr, String.valueOf(kind) + " " + this.path) : null;
    }

    protected VResult fire(String id, String attr, String value) {
        Object[] os = new Object[]{this.object, value};
        VResult result = this.rule.getResultFactory().getResult(id, this.object, (Object)attr, this.object, (Object)attr, os);
        return result;
    }
}

