/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.text.ext.hyperlink;

import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlink;
import org.jboss.tools.common.text.ext.hyperlink.xpl.Messages;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.StructuredSelectionHelper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.jboss.tools.jst.text.ext.hyperlink.jsp.JSPRootHyperlinkPartitioner;
import org.jboss.tools.jst.web.project.WebProject;
import org.jboss.tools.jst.web.tld.ITaglibMapping;
import org.jboss.tools.jst.web.tld.TaglibMapping;
import org.jboss.tools.struts.text.ext.StrutsExtensionsPlugin;
import org.jboss.tools.struts.text.ext.hyperlink.StrutsFormBeanHyperlink;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class StrutsBeanNameHyperlink
extends AbstractHyperlink {
    private static final String[] TAGS_TO_FIND = new String[]{"cookie", "define", "header", "include", "message", "page", "parameter", "resource", "size", "struts"};
    IRegion fLastRegion = null;

    protected void doHyperlink(IRegion region) {
        if (region == null) {
            this.openFileFailed();
            return;
        }
        String forID = this.getForId(region);
        String prefix = this.getPrefix(region);
        IRegion elementByID = this.findElementByIDBackward(forID, region.getOffset(), prefix);
        if (elementByID != null) {
            StructuredSelectionHelper.setSelectionAndRevealInActiveEditor((IRegion)elementByID);
            return;
        }
        StrutsFormBeanHyperlink openOn = new StrutsFormBeanHyperlink();
        openOn.setDocument(this.getDocument());
        openOn.setOffset(this.getOffset());
        openOn.doHyperlink(region);
    }

    private IRegion findElementByIDBackward(String id, int endOffset, String prefix) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(this.getDocument());
        try {
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)endOffset);
            if (n == null) {
                return null;
            }
            if (n instanceof Attr) {
                n = ((Attr)n).getOwnerElement();
            }
            if (!(n instanceof Node)) {
                return null;
            }
            Element element = null;
            Node parent = n;
            while (parent != null && element == null) {
                element = this.findElementByIDBackward(xmlDocument.getChildNodes(), id, endOffset, prefix);
                parent = parent.getParentNode();
            }
            if (!(element instanceof IDOMElement)) {
                return null;
            }
            final int offset = Utils.getValueStart(element);
            final int length = ((IDOMElement)element).getStartStructuredDocumentRegion().getLength();
            IRegion iRegion = new IRegion(){

                public boolean equals(Object arg) {
                    if (!(arg instanceof IRegion)) {
                        return false;
                    }
                    IRegion region = (IRegion)arg;
                    if (this.getOffset() != region.getOffset()) {
                        return false;
                    }
                    return this.getLength() == region.getLength();
                }

                public int getLength() {
                    return length;
                }

                public int getOffset() {
                    return offset;
                }

                public String toString() {
                    return "IRegion [" + this.getOffset() + ", " + this.getLength() + "]";
                }
            };
            return iRegion;
        }
        finally {
            smw.dispose();
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Element findElementByIDBackward(NodeList list, String id, int endOffset, String prefix) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(this.getDocument());
        try {
            block13: {
                int i;
                TaglibMapping tm;
                Map trackersMap;
                block12: {
                    Document xmlDocument = smw.getDocument();
                    if (xmlDocument == null) {
                        return null;
                    }
                    trackersMap = JSPRootHyperlinkPartitioner.getTrackersMap((IDocument)this.getDocument(), (int)endOffset);
                    XModel xModel = smw.getXModel();
                    tm = xModel == null ? null : WebProject.getInstance((XModel)xModel).getTaglibMapping();
                    i = list.getLength() - 1;
                    if (!true) break block12;
                    if (list == null) return null;
                    if (i < 0) break block13;
                }
                do {
                    Element element;
                    int start;
                    if (list.item(i) instanceof Element && (start = Utils.getValueStart((Node)(element = (Element)list.item(i)))) >= 0 && start < endOffset) {
                        Element child;
                        String val;
                        Attr idAttr;
                        String elementExtracted = JSPRootHyperlinkPartitioner.extractName((String)element.getNodeName(), (Map)trackersMap, (ITaglibMapping)tm);
                        if (this.isInList(elementExtracted, trackersMap, tm, prefix) && (idAttr = element.getAttributeNode("id")) != null && id.equals(val = Utils.trimQuotes((String)idAttr.getNodeValue()))) {
                            Element element2 = element;
                            return element2;
                        }
                        if (element.hasChildNodes() && (child = this.findElementByIDBackward(element.getChildNodes(), id, endOffset, prefix)) != null) {
                            Element element3 = child;
                            return element3;
                        }
                    }
                    --i;
                    if (list == null) return null;
                } while (i >= 0);
            }
            return null;
        }
        finally {
            smw.dispose();
        }
    }

    private boolean isInList(String extractedName, Map trackersMap, TaglibMapping tm, String prefix) {
        int i = 0;
        while (i < TAGS_TO_FIND.length) {
            String extractedFromList = JSPRootHyperlinkPartitioner.extractName((String)(String.valueOf(prefix) + ":" + TAGS_TO_FIND[i]), (Map)trackersMap, (ITaglibMapping)tm);
            if (extractedName.equals(extractedFromList)) {
                return true;
            }
            for (String prefixFromMap : trackersMap.keySet()) {
                if (((String)trackersMap.get(prefixFromMap)).toLowerCase().indexOf("bean") == -1 || !extractedName.equals(extractedFromList = JSPRootHyperlinkPartitioner.extractName((String)(String.valueOf(prefixFromMap) + ":" + TAGS_TO_FIND[i]), (Map)trackersMap, (ITaglibMapping)tm))) continue;
                return true;
            }
            ++i;
        }
        return false;
    }

    String getForId(IRegion region) {
        try {
            return Utils.trimQuotes((String)this.getDocument().get(region.getOffset(), region.getLength()));
        }
        catch (BadLocationException x) {
            StrutsExtensionsPlugin.getPluginLog().logError((Throwable)x);
            return null;
        }
    }

    protected IRegion doGetHyperlinkRegion(int offset) {
        this.fLastRegion = this.getRegion(offset);
        return this.fLastRegion;
    }

    private IRegion getRegion(int offset) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            IRegion region;
            smw.init(this.getDocument());
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)offset);
            if (n == null || !(n instanceof Attr) && !(n instanceof Text)) {
                return null;
            }
            int start = Utils.getValueStart((Node)n);
            int end = Utils.getValueEnd((Node)n);
            if (start < 0 || start > offset || end < offset) {
                return null;
            }
            String text = this.getDocument().get(start, end - start);
            StringBuffer sb = new StringBuffer(text);
            int bStart = 0;
            int bEnd = text.length() - 1;
            while (bStart < bEnd && (Character.isWhitespace(sb.charAt(bStart)) || sb.charAt(bStart) == '\"' || sb.charAt(bStart) == '\"')) {
                ++bStart;
            }
            while (bEnd > bStart && (Character.isWhitespace(sb.charAt(bEnd)) || sb.charAt(bEnd) == '\"' || sb.charAt(bEnd) == '\"')) {
                --bEnd;
            }
            final int propStart = bStart + start;
            final int propLength = ++bEnd - bStart;
            if (propStart > offset || propStart + propLength < offset) {
                return null;
            }
            IRegion iRegion = region = new IRegion(){

                public boolean equals(Object arg) {
                    if (!(arg instanceof IRegion)) {
                        return false;
                    }
                    IRegion region = (IRegion)arg;
                    if (this.getOffset() != region.getOffset()) {
                        return false;
                    }
                    return this.getLength() == region.getLength();
                }

                public int getLength() {
                    return propLength;
                }

                public int getOffset() {
                    return propStart;
                }

                public String toString() {
                    return "IRegion [" + this.getOffset() + ", " + this.getLength() + "]";
                }
            };
            return iRegion;
        }
        catch (BadLocationException x) {
            StrutsExtensionsPlugin.getPluginLog().logError((Throwable)x);
            return null;
        }
        finally {
            smw.dispose();
        }
    }

    private String getPrefix(IRegion region) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            smw.init(this.getDocument());
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)region.getOffset());
            if (n == null) {
                return null;
            }
            if (n instanceof Attr) {
                n = ((Attr)n).getOwnerElement();
            }
            if (n == null) {
                return null;
            }
            Node node = n;
            if (node.getNodeName().indexOf(":") == -1) {
                return null;
            }
            String string = node.getNodeName().substring(0, node.getNodeName().indexOf(":"));
            return string;
        }
        finally {
            smw.dispose();
        }
    }

    public String getHyperlinkText() {
        String forId = this.getForId(this.fLastRegion);
        if (forId == null) {
            return MessageFormat.format(Messages.BrowseFor, Messages.BeanId);
        }
        return MessageFormat.format(Messages.BrowseForBeanId, forId);
    }
}

