/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.text.ext.hyperlink;

import java.text.MessageFormat;
import java.util.Properties;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.jboss.tools.common.text.ext.hyperlink.xpl.Messages;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.jboss.tools.struts.text.ext.StrutsExtensionsPlugin;
import org.jboss.tools.struts.text.ext.hyperlink.StrutsXModelBasedHyperlink;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class StrutsBundleKeyHyperlink
extends StrutsXModelBasedHyperlink {
    protected String getRequestMethod() {
        return "struts.open.key";
    }

    protected Properties getRequestProperties(IRegion region) {
        Properties p = new Properties();
        String value = this.getKey(region);
        value = value == null ? "" : value;
        p.setProperty("key", value);
        p.setProperty("prefix", value);
        value = this.getBundle(region);
        value = value == null ? "" : value;
        p.setProperty("bundle", value);
        return p;
    }

    private String getBundle(IRegion region) {
        if (region == null) {
            return "";
        }
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(this.getDocument());
        try {
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)region.getOffset());
            if (n == null || !(n instanceof Attr)) {
                return null;
            }
            Element node = ((Attr)n).getOwnerElement();
            Attr bundleAttr = (Attr)node.getAttributes().getNamedItem("bundle");
            if (bundleAttr == null) {
                return "";
            }
            String string = Utils.getTrimmedValue((IDocument)this.getDocument(), (Attr)bundleAttr);
            return string;
        }
        catch (BadLocationException x) {
            StrutsExtensionsPlugin.getPluginLog().logError((Throwable)x);
            return "";
        }
        finally {
            smw.dispose();
        }
    }

    private String getKey(IRegion region) {
        if (region == null || this.getDocument() == null) {
            return "";
        }
        try {
            return Utils.trimQuotes((String)this.getDocument().get(region.getOffset(), region.getLength()));
        }
        catch (BadLocationException x) {
            StrutsExtensionsPlugin.getPluginLog().logError((Throwable)x);
            return "";
        }
    }

    public String getHyperlinkText() {
        String baseName = this.getBundle(this.fLastRegion);
        String propertyName = this.getKey(this.fLastRegion);
        if (baseName == null || propertyName == null) {
            return MessageFormat.format(Messages.OpenA, Messages.BundleProperty);
        }
        return MessageFormat.format(Messages.OpenBundleProperty, propertyName, baseName);
    }
}

