/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.text.ext.hyperlink;

import java.text.MessageFormat;
import java.util.Properties;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.jboss.tools.common.text.ext.hyperlink.xpl.Messages;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.jboss.tools.struts.text.ext.StrutsExtensionsPlugin;
import org.jboss.tools.struts.text.ext.StrutsTextExtMessages;
import org.jboss.tools.struts.text.ext.hyperlink.StrutsXModelBasedHyperlink;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class StrutsConfigFormPropertyHyperlink
extends StrutsXModelBasedHyperlink {
    protected String getRequestMethod() {
        return "struts.open.property";
    }

    protected Properties getRequestProperties(IRegion region) {
        Properties p = new Properties();
        String value = this.getName(region);
        if (value != null) {
            p.setProperty("property", value);
            p.setProperty("prefix", value);
        }
        if ((value = this.getFormType(region)) != null) {
            p.setProperty("type", value);
        }
        return p;
    }

    private String getName(IRegion region) {
        if (region == null || this.getDocument() == null) {
            return null;
        }
        try {
            return Utils.trimQuotes((String)this.getDocument().get(region.getOffset(), region.getLength()));
        }
        catch (BadLocationException x) {
            StrutsExtensionsPlugin.getPluginLog().logError((Throwable)x);
            return null;
        }
    }

    private String getFormType(IRegion region) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(this.getDocument());
        try {
            String type;
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)region.getOffset());
            if (n == null || !(n instanceof Attr)) {
                return null;
            }
            Element node = ((Attr)n).getOwnerElement();
            Node parent = node.getParentNode();
            Attr typeAttr = (Attr)parent.getAttributes().getNamedItem("type");
            if (typeAttr == null) {
                return null;
            }
            String string = type = Utils.getTrimmedValue((IDocument)this.getDocument(), (Attr)typeAttr);
            return string;
        }
        catch (BadLocationException x) {
            StrutsExtensionsPlugin.getPluginLog().logError((Throwable)x);
            return null;
        }
        finally {
            smw.dispose();
        }
    }

    public String getHyperlinkText() {
        String formPropertyName = this.getName(this.fLastRegion);
        if (formPropertyName == null) {
            return MessageFormat.format(Messages.OpenA, StrutsTextExtMessages.FormProperty);
        }
        return MessageFormat.format(StrutsTextExtMessages.OpenFormProperty, formPropertyName);
    }
}

