/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.text.ext.hyperlink;

import java.text.MessageFormat;
import java.util.Properties;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.jboss.tools.common.text.ext.hyperlink.xpl.Messages;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.jboss.tools.struts.text.ext.StrutsExtensionsPlugin;
import org.jboss.tools.struts.text.ext.StrutsTextExtMessages;
import org.jboss.tools.struts.text.ext.hyperlink.StrutsXModelBasedHyperlink;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class StrutsConfigForwardPathHyperlink
extends StrutsXModelBasedHyperlink {
    private static final String ACTION_TAGNAME = "action";
    private static final String NAME_ATTRNAME = "name";
    private static final String TYPE_ATTRNAME = "type";
    private static final String PATH_ATTRNAME = "path";
    private static final String FORWARD_ATTRNAME = "forward";
    private static final String INCLUDE_ATTRNAME = "include";
    private static final String INPUT_ATTRNAME = "input";

    protected String getRequestMethod() {
        return "struts.open.forward.path";
    }

    protected Properties getRequestProperties(IRegion region) {
        Properties p = new Properties();
        String path = this.getPath(region);
        if (path != null) {
            p.setProperty("model-path", path);
        }
        p.setProperty("prefix", this.getAttributeValue(region));
        return p;
    }

    private String getAttributeValue(IRegion region) {
        if (region == null || this.getDocument() == null) {
            return null;
        }
        try {
            return Utils.trimQuotes((String)this.getDocument().get(region.getOffset(), region.getLength()));
        }
        catch (BadLocationException x) {
            StrutsExtensionsPlugin.getPluginLog().logError((Throwable)x);
            return null;
        }
    }

    private String getPath(IRegion region) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(this.getDocument());
        try {
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)region.getOffset());
            if (n == null || !(n instanceof Attr)) {
                return null;
            }
            Element node = ((Attr)n).getOwnerElement();
            Node parentNode = node.getParentNode();
            if (parentNode == null) {
                return null;
            }
            if (ACTION_TAGNAME.equals(node.getNodeName())) {
                Element actionNode = node;
                if (actionNode == null) {
                    return null;
                }
                if (actionNode.getAttributes().getNamedItem(FORWARD_ATTRNAME) == null && actionNode.getAttributes().getNamedItem(INCLUDE_ATTRNAME) == null && actionNode.getAttributes().getNamedItem(INPUT_ATTRNAME) == null) {
                    return null;
                }
                Node actionParentNode = actionNode.getParentNode();
                if (actionParentNode == null) {
                    return null;
                }
                Attr actionPathAttr = (Attr)actionNode.getAttributes().getNamedItem(PATH_ATTRNAME);
                String actionPath = Utils.getTrimmedValue((IDocument)this.getDocument(), (Attr)actionPathAttr);
                if (actionPath == null) {
                    return null;
                }
                String string = String.valueOf(actionParentNode.getNodeName()) + "/" + actionPath.replace('/', '#');
                return string;
            }
            if (ACTION_TAGNAME.equals(parentNode.getNodeName())) {
                Node actionNode = parentNode;
                if (actionNode == null) {
                    return null;
                }
                Node actionParentNode = actionNode.getParentNode();
                if (actionParentNode == null) {
                    return null;
                }
                Attr actionPathAttr = (Attr)actionNode.getAttributes().getNamedItem(PATH_ATTRNAME);
                String actionPath = Utils.getTrimmedValue((IDocument)this.getDocument(), (Attr)actionPathAttr);
                Attr forwardNameAttr = (Attr)node.getAttributes().getNamedItem(NAME_ATTRNAME);
                String forwardName = Utils.getTrimmedValue((IDocument)this.getDocument(), (Attr)forwardNameAttr);
                if (actionPath == null || forwardName == null) {
                    return null;
                }
                String string = String.valueOf(actionParentNode.getNodeName()) + "/" + actionPath.replace('/', '#') + "/" + forwardName;
                return string;
            }
            Attr typeAttr = (Attr)node.getAttributes().getNamedItem(TYPE_ATTRNAME);
            Attr nameAttr = (Attr)node.getAttributes().getNamedItem(NAME_ATTRNAME);
            String nameOrType = null;
            if (typeAttr != null) {
                nameOrType = Utils.getTrimmedValue((IDocument)this.getDocument(), (Attr)typeAttr);
            } else if (nameAttr != null) {
                nameOrType = Utils.getTrimmedValue((IDocument)this.getDocument(), (Attr)nameAttr);
            }
            if (nameOrType == null || nameOrType.trim().length() == 0) {
                return null;
            }
            String string = String.valueOf(parentNode.getNodeName()) + "/" + nameOrType;
            return string;
        }
        catch (BadLocationException x) {
            StrutsExtensionsPlugin.getPluginLog().logError((Throwable)x);
            return null;
        }
        finally {
            smw.dispose();
        }
    }

    public String getHyperlinkText() {
        String path = this.getPath(this.fLastRegion);
        if (path == null) {
            return MessageFormat.format(Messages.OpenA, StrutsTextExtMessages.ForwardPath);
        }
        return MessageFormat.format(StrutsTextExtMessages.OpenForwardPath, path);
    }
}

