/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.text.ext.hyperlink;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkRegion;
import org.jboss.tools.common.text.ext.hyperlink.xml.XMLTagAttributeValueHyperlinkPartitioner;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.jboss.tools.struts.text.ext.StrutsExtensionsPlugin;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class StrutsConfigSetPropertyHyperlinkPartitioner
extends XMLTagAttributeValueHyperlinkPartitioner {
    public static final String STRUTS_XML_SET_PROPERTY_PARTITION = "org.jboss.tools.common.text.ext.xml.STRUTS_XML_SET_PROPERTY";
    private String[] STRUTS_PROJECT_NATURES = new String[]{"org.jboss.tools.struts.strutsnature"};
    private static final String CLASS_NAME_ATTR = "className";
    private static final String PROPERTY_ATTR = "property";

    protected String getPartitionType() {
        return STRUTS_XML_SET_PROPERTY_PARTITION;
    }

    protected boolean recognizeNature(IDocument document) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(document);
        try {
            IFile documentFile = smw.getFile();
            if (documentFile == null) {
                return false;
            }
            IProject project = documentFile.getProject();
            int i = 0;
            while (i < this.STRUTS_PROJECT_NATURES.length) {
                if (project.getNature(this.STRUTS_PROJECT_NATURES[i]) != null) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        catch (CoreException x) {
            StrutsExtensionsPlugin.getPluginLog().logError((Throwable)x);
            return false;
        }
        finally {
            smw.dispose();
        }
    }

    public boolean recognize(IDocument document, IHyperlinkRegion region) {
        if (document == null || region == null) {
            return false;
        }
        if (!super.recognize(document, region)) {
            return false;
        }
        if (!this.recognizeNature(document)) {
            return false;
        }
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(document);
        try {
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return false;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)region.getOffset());
            if (n == null || !(n instanceof Attr)) {
                return false;
            }
            Element node = ((Attr)n).getOwnerElement();
            String propertyValue = this.getAttributeValue(document, node, PROPERTY_ATTR);
            Node parent = node.getParentNode();
            String classNameValue = this.getAttributeValue(document, parent, CLASS_NAME_ATTR);
            boolean bl = classNameValue != null && classNameValue.length() > 0 && propertyValue != null && propertyValue.length() > 0;
            return bl;
        }
        finally {
            smw.dispose();
        }
    }

    private String getAttributeValue(IDocument document, Node node, String attrName) {
        if (node == null || document == null || attrName == null) {
            return null;
        }
        try {
            Attr attr = (Attr)node.getAttributes().getNamedItem(attrName);
            return Utils.getTrimmedValue((IDocument)document, (Attr)attr);
        }
        catch (BadLocationException x) {
            StrutsExtensionsPlugin.getPluginLog().logError((Throwable)x);
            return null;
        }
    }
}

