/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.text.ext.hyperlink;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.jboss.tools.common.text.ext.hyperlink.HyperlinkRegion;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.jboss.tools.struts.text.ext.StrutsExtensionsPlugin;
import org.jboss.tools.struts.text.ext.hyperlink.StrutsLinkHyperlink;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class StrutsContextParamLinkHyperlink
extends StrutsLinkHyperlink {
    protected IRegion getRegion(int offset) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(this.getDocument());
        try {
            HyperlinkRegion region;
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)offset);
            if (n == null || !(n instanceof Text)) {
                return null;
            }
            int start = Utils.getValueStart((Node)n);
            int end = Utils.getValueEnd((Node)n);
            if (start < 0 || start > offset) {
                return null;
            }
            String attrText = this.getDocument().get(start, end - start);
            StringBuffer sb = new StringBuffer(attrText);
            int bStart = offset - start;
            while (bStart >= 0) {
                if (!Character.isJavaIdentifierPart(sb.charAt(bStart)) && sb.charAt(bStart) != '\\' && sb.charAt(bStart) != '/' && sb.charAt(bStart) != ':' && sb.charAt(bStart) != '-' && sb.charAt(bStart) != '.' && sb.charAt(bStart) != '_' && sb.charAt(bStart) != '%' && sb.charAt(bStart) != '?' && sb.charAt(bStart) != '&' && sb.charAt(bStart) != '=') {
                    ++bStart;
                    break;
                }
                if (bStart == 0) break;
                --bStart;
            }
            int bEnd = offset - start;
            while (bEnd < sb.length()) {
                if (!Character.isJavaIdentifierPart(sb.charAt(bEnd)) && sb.charAt(bEnd) != '\\' && sb.charAt(bEnd) != '/' && sb.charAt(bEnd) != ':' && sb.charAt(bEnd) != '-' && sb.charAt(bEnd) != '.' && sb.charAt(bEnd) != '_' && sb.charAt(bEnd) != '%' && sb.charAt(bEnd) != '?' && sb.charAt(bEnd) != '&' && sb.charAt(bEnd) != '=') break;
                ++bEnd;
            }
            int propStart = bStart + start;
            int propLength = bEnd - bStart;
            if (propStart > offset || propStart + propLength < offset) {
                return null;
            }
            HyperlinkRegion hyperlinkRegion = region = new HyperlinkRegion(propStart, propLength);
            return hyperlinkRegion;
        }
        catch (BadLocationException x) {
            StrutsExtensionsPlugin.getPluginLog().logError((Throwable)x);
            return null;
        }
        finally {
            smw.dispose();
        }
    }
}

