/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.text.ext.hyperlink;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkRegion;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.jboss.tools.jst.text.ext.hyperlink.jsp.JSPTagAttributeValueHyperlinkPartitioner;
import org.jboss.tools.struts.text.ext.StrutsExtensionsPlugin;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class StrutsFormActionHyperlinkPartitioner
extends JSPTagAttributeValueHyperlinkPartitioner {
    public static final String STRUTS_JSP_FORM_ACTION_PARTITION = "org.jboss.tools.common.text.ext.jsp.STRUTS_JSP_FORM_ACTION";

    protected String getPartitionType() {
        return STRUTS_JSP_FORM_ACTION_PARTITION;
    }

    public boolean recognize(IDocument document, IHyperlinkRegion region) {
        if (!super.recognize(document, region)) {
            return false;
        }
        return this.checkTypeIsEmpty(document, (IRegion)region);
    }

    private boolean checkTypeIsEmpty(IDocument document, IRegion region) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(document);
        try {
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return false;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)region.getOffset());
            if (n == null || !(n instanceof Attr)) {
                return false;
            }
            Element node = ((Attr)n).getOwnerElement();
            Attr typeAttr = (Attr)node.getAttributes().getNamedItem("type");
            if (typeAttr == null) {
                return true;
            }
            String typeValue = Utils.getTrimmedValue((IDocument)document, (Attr)typeAttr);
            boolean bl = typeValue == null || typeValue.length() == 0;
            return bl;
        }
        catch (BadLocationException x) {
            StrutsExtensionsPlugin.getPluginLog().logError((Throwable)x);
            return false;
        }
        finally {
            smw.dispose();
        }
    }
}

